/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.HashSet;
import java.util.concurrent.Executor;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.parser.Parser;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.LuceneUtils;

public class JahiaTranslationNodeIndexer
extends JahiaNodeIndexer {
    private static final Name MIXIN_TYPES = NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "mixinTypes");
    private static final Name PRIMARY_TYPE = NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "primaryType");
    private String language;
    private NodeState parentNode;
    private ExtendedNodeType parentNodeType;

    protected JahiaTranslationNodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, Executor executor, Parser parser, QueryHandlerContext context, NodeTypeRegistry typeRegistry, NamespaceRegistry nameRegistry) {
        block3: {
            super(node, stateProvider, mappings, executor, parser, context, typeRegistry, nameRegistry);
            try {
                for (Name propName : node.getPropertyNames()) {
                    if (!"language".equals(propName.getLocalName()) || !"http://www.jcp.org/jcr/1.0".equals(propName.getNamespaceURI())) continue;
                    PropertyId id = new PropertyId(node.getNodeId(), propName);
                    PropertyState propState = (PropertyState)stateProvider.getItemState((ItemId)id);
                    this.language = propState.getValues()[0].getString();
                    break;
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Error finding language property", (Throwable)e);
            }
        }
    }

    @Override
    protected ExtendedPropertyDefinition getPropertyDefinition(String fieldName) throws RepositoryException, ItemStateException {
        ExtendedNodeType parentNodeType;
        ExtendedPropertyDefinition propDef;
        int endIndex = fieldName.lastIndexOf("_" + this.language);
        if (endIndex >= 0) {
            fieldName = fieldName.substring(0, endIndex);
        }
        return (propDef = this.getPropertyDefinitionFor(fieldName, parentNodeType = this.getParentNodeType(), this.parentNode)) != null ? propDef : this.getPropertyDefinitionFor(fieldName, this.getNodeType(), this.node);
    }

    private ExtendedNodeType getParentNodeType() throws RepositoryException, ItemStateException {
        if (this.parentNodeType == null) {
            Name parenteNodeTypeName = this.getParentNodeState().getNodeTypeName();
            this.parentNodeType = this.nodeTypeRegistry.getNodeType(JahiaTranslationNodeIndexer.getTypeNameAsString(parenteNodeTypeName, this.namespaceRegistry));
        }
        return this.parentNodeType;
    }

    private NodeState getParentNodeState() throws ItemStateException {
        if (this.parentNode == null) {
            this.parentNode = (NodeState)this.stateProvider.getItemState((ItemId)this.node.getParentId());
        }
        return this.parentNode;
    }

    @Override
    protected String getFullTextFieldName(String site) {
        return LuceneUtils.getFullTextFieldName(site, this.language);
    }

    @Override
    public Document createDoc() throws RepositoryException {
        Document doc = super.createDoc();
        this.doNotUseInExcerpt.clear();
        try {
            NodeState parentNode = this.getParentNodeState();
            NodeId parentId = parentNode.getParentId();
            if (parentId == null) {
                logger.warn("The node " + parentNode.getId().toString() + " is in 'free floating' state. You should run a consistency check/fix on the repository.");
            } else {
                doc.add((Fieldable)new Field(TRANSLATED_NODE_PARENT, false, parentId.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            if (this.language == null) {
                logger.warn("The node " + this.node.getId().toString() + " is of type " + "jnt:translation" + " but doesn't contain a valid value for the jcr:language property!");
            } else {
                doc.add((Fieldable)new Field(TRANSLATION_LANGUAGE, this.language, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            HashSet parentNodePropertyNames = new HashSet(parentNode.getPropertyNames());
            HashSet localNames = new HashSet(this.node.getPropertyNames());
            localNames.remove(PRIMARY_TYPE);
            localNames.remove(MIXIN_TYPES);
            parentNodePropertyNames.removeAll(localNames);
            parentNodePropertyNames.removeAll(this.getIndexingConfig().getExcludesFromI18NCopy());
            for (Name propName : parentNodePropertyNames) {
                try {
                    InternalValue[] values;
                    PropertyId id = new PropertyId(parentNode.getNodeId(), propName);
                    PropertyState propState = (PropertyState)this.stateProvider.getItemState((ItemId)id);
                    if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                        this.addPropertyName(doc, propState.getName());
                    }
                    for (InternalValue value : values = propState.getValues()) {
                        this.addValue(doc, value, propState.getName());
                    }
                    if (values.length <= 1) continue;
                    this.addMVPName(doc, propState.getName());
                }
                catch (NoSuchItemStateException e) {
                    this.throwRepositoryException((Exception)((Object)e));
                }
                catch (ItemStateException e) {
                    this.throwRepositoryException((Exception)((Object)e));
                }
            }
            if (this.isIndexed(J_VISIBILITY) && parentNode.hasChildNodeEntry(J_VISIBILITY)) {
                doc.add((Fieldable)new Field(CHECK_VISIBILITY, false, "1", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            for (Fieldable field : this.doNotUseInExcerpt) {
                doc.add(field);
            }
        }
        catch (ItemStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return doc;
    }
}

