/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.server.BasicCredentialsProvider;
import org.apache.jackrabbit.util.Base64;

public class JahiaBasicCredentialsProvider
extends BasicCredentialsProvider {
    public static final String IMPERSONATOR = " impersonator ";

    public JahiaBasicCredentialsProvider(String defaultHeaderValue) {
        super(defaultHeaderValue);
    }

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            try {
                String[] authStr = authHeader.split(" ");
                if (authStr.length >= 2 && authStr[0].equalsIgnoreCase("BASIC")) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Base64.decode((char[])authStr[1].toCharArray(), (OutputStream)out);
                    String decAuthStr = out.toString("ISO-8859-1");
                    int pos = decAuthStr.indexOf(58);
                    String userid = decAuthStr.substring(0, pos);
                    String passwd = decAuthStr.substring(pos + 1);
                    return this.createCredentials(userid, passwd.toCharArray());
                }
                throw new ServletException("Unable to decode authorization.");
            }
            catch (IOException e) {
                throw new ServletException("Unable to decode authorization: " + e.toString());
            }
        }
        return super.getCredentials(request);
    }

    protected Credentials createCredentials(String user, char[] password) {
        SimpleCredentials credentials = null;
        if (user != null && user.contains(IMPERSONATOR)) {
            credentials = new SimpleCredentials(StringUtils.substringBefore((String)user, (String)IMPERSONATOR), ArrayUtils.EMPTY_CHAR_ARRAY);
            credentials.setAttribute("org.apache.jackrabbit.core.security.impersonator", (Object)new SimpleCredentials(StringUtils.substringAfter((String)user, (String)IMPERSONATOR), password));
        } else {
            credentials = new SimpleCredentials(user, password);
        }
        return credentials;
    }
}

