/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.ActionResult;
import org.jahia.bin.JahiaControllerUtils;
import org.jahia.bin.Render;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.NodeConstraintViolationException;
import org.jahia.services.content.PropertyConstraintViolationException;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.usermanager.JahiaUser;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.ServletRequestUtils;

public abstract class Action {
    private String name;
    private boolean requireAuthenticatedUser = true;
    private String requiredPermission;
    private String requiredWorkspace;

    protected static String getRequiredParameter(Map<String, List<String>> parameters, String paramName) throws JahiaBadRequestException {
        if (parameters.get(paramName) == null) {
            throw new JahiaBadRequestException("Missing required '" + paramName + "' parameter in request.");
        }
        return Action.getParameter(parameters, paramName, null);
    }

    protected static String getParameter(Map<String, List<String>> parameters, String paramName) {
        return Action.getParameter(parameters, paramName, null);
    }

    protected static String getParameter(Map<String, List<String>> parameters, String paramName, String defaultValue) {
        List<String> vals = parameters.get(paramName);
        return CollectionUtils.isNotEmpty(vals) && StringUtils.isNotEmpty((String)vals.get(0)) ? vals.get(0) : defaultValue;
    }

    protected JCRNodeWrapper createNode(HttpServletRequest req, Map<String, List<String>> parameters, JCRNodeWrapper node, String nodeType, String nodeName, boolean forceCreation) throws RepositoryException {
        JCRNodeWrapper newNode;
        boolean isNodeNameToBeNormalized = ServletRequestUtils.getBooleanParameter((ServletRequest)req, (String)"jcrNormalizeNodeName", (boolean)false);
        if (StringUtils.isBlank((String)nodeName)) {
            String nodeNameProperty = "jcr:title";
            if (parameters.get("jcrNodeNameProperty") != null) {
                nodeNameProperty = parameters.get("jcrNodeNameProperty").get(0);
            }
            nodeName = parameters.get(nodeNameProperty) != null ? JCRContentUtils.generateNodeName(parameters.get(nodeNameProperty).get(0)) : nodeType.substring(nodeType.lastIndexOf(":") + 1);
            if (isNodeNameToBeNormalized) {
                nodeName = JCRContentUtils.generateNodeName(nodeName);
            }
            nodeName = JCRContentUtils.findAvailableNodeName(node, nodeName);
        } else {
            nodeName = isNodeNameToBeNormalized ? JCRContentUtils.generateNodeName(nodeName) : JCRContentUtils.escapeLocalNodeName(nodeName);
        }
        if (forceCreation) {
            nodeName = JCRContentUtils.findAvailableNodeName(node, nodeName);
        }
        try {
            newNode = node.getNode(nodeName);
            if (!newNode.isCheckedOut()) {
                newNode.checkout();
            }
        }
        catch (PathNotFoundException e) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            newNode = node.addNode(nodeName, nodeType);
        }
        if (parameters.containsKey("jcr:mixinTypes")) {
            for (Object o : (ArrayList)parameters.get("jcr:mixinTypes")) {
                String mixin = (String)o;
                newNode.addMixin(mixin);
            }
        }
        this.setProperties(newNode, parameters);
        return newNode;
    }

    protected void setProperties(JCRNodeWrapper newNode, Map<String, List<String>> parameters) throws RepositoryException {
        Set<Map.Entry<String, List<String>>> set = parameters.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            String key = entry.getKey();
            if (Render.RESERVED_PARAMETERS.contains(key)) continue;
            List<String> values = entry.getValue();
            ExtendedPropertyDefinition propertyDefinition = null;
            propertyDefinition = newNode.getApplicablePropertyDefinition(key);
            if (propertyDefinition == null) continue;
            if (propertyDefinition.isMultiple()) {
                newNode.setProperty(key, values.toArray(new String[values.size()]));
                continue;
            }
            if (values.get(0).length() <= 0) continue;
            if (propertyDefinition.getRequiredType() == 5) {
                DateTime dateTime = ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(values.get(0));
                newNode.setProperty(key, dateTime.toCalendar(Locale.ENGLISH));
                continue;
            }
            newNode.setProperty(key, values.get(0));
        }
    }

    protected JSONObject getJSONConstraintError(ConstraintViolationException e) throws RepositoryException {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("message", e.getMessage());
        if (e instanceof NodeConstraintViolationException) {
            m.put("constraintMessage", ((NodeConstraintViolationException)e).getConstraintMessage());
            Locale locale = ((NodeConstraintViolationException)e).getLocale();
            if (locale != null) {
                m.put("locale", locale.toString());
            }
            m.put("path", ((NodeConstraintViolationException)e).getPath());
        }
        if (e instanceof PropertyConstraintViolationException) {
            ExtendedPropertyDefinition definition = ((PropertyConstraintViolationException)e).getDefinition();
            m.put("propertyName", definition.getName());
            m.put("propertyLabel", definition.getLabel(LocaleContextHolder.getLocale(), definition.getDeclaringNodeType()));
        }
        return new JSONObject(m);
    }

    public abstract ActionResult doExecute(HttpServletRequest var1, RenderContext var2, Resource var3, JCRSessionWrapper var4, Map<String, List<String>> var5, URLResolver var6) throws Exception;

    protected JahiaUser getCurrentUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    public String getName() {
        return this.name != null ? this.name : StringUtils.uncapitalize((String)StringUtils.substringBeforeLast((String)this.getClass().getSimpleName(), (String)"Action"));
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public String getRequiredWorkspace() {
        return this.requiredWorkspace;
    }

    public boolean isPermitted(JCRNodeWrapper node) throws RepositoryException {
        if (StringUtils.isEmpty((String)this.getRequiredPermission())) {
            return true;
        }
        return JahiaControllerUtils.hasRequiredPermission(node, this.getCurrentUser(), this.getRequiredPermission());
    }

    public boolean isRequireAuthenticatedUser() {
        return this.requireAuthenticatedUser;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    public void setRequiredWorkspace(String requiredWorkspace) {
        this.requiredWorkspace = requiredWorkspace;
    }
}

