/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.importexport.ImportExportService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;

public class Export
extends JahiaController
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);
    public static final String CLEANUP = "cleanup";
    private static final String CONTROLLER_MAPPING = "/export";
    private static final String EXPORT_SITES_REQUIRED_PERMISSION = "adminVirtualSites";
    private static final Pattern URI_PATTERN = Pattern.compile("/export/(live|default)/(.*)\\.(xml|zip)");
    private String cleanupXsl;
    private boolean downloadExportedXmlAsFile;
    private ImportExportService importExportService;
    private String templatesCleanupXsl;

    public static String getExportServletPath() {
        return "/cms/export";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.checkUserLoggedIn();
            v0 = m = StringUtils.isNotEmpty((String)request.getPathInfo()) != false ? Export.URI_PATTERN.matcher(request.getPathInfo()) : null;
            if (m == null || !m.matches()) {
                throw new JahiaBadRequestException("Requested URI '" + request.getRequestURI() + "' is malformed");
            }
            workspace = m.group(1);
            nodePath = "/" + m.group(2);
            exportFormat = m.group(3);
            serverDirectory = null;
            if (StringUtils.isNotEmpty((String)request.getParameter("exportformat"))) {
                exportFormat = request.getParameter("exportformat");
            }
            params = this.getParams(request);
            session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace);
            exportRoot = null;
            if (request.getParameter("root") != null) {
                exportRoot = session.getNode(request.getParameter("root"));
            }
            if (StringUtils.isNotBlank((String)request.getParameter("exportPath"))) {
                serverDirectory = request.getParameter("exportPath");
                params.put("serverDirectory", serverDirectory);
            }
            if ("all".equals(exportFormat) || "site".equals(exportFormat)) {
                if (JahiaUserManagerService.isGuest(session.getUser())) {
                    throw new JahiaUnauthorizedException("User guest is not allowed to export site content");
                }
                if (!session.getRootNode().hasPermission("adminVirtualSites")) {
                    throw new JahiaForbiddenAccessException("User has no sufficient permissions to perform export of site content");
                }
                userToReset = null;
                if (!session.getUser().isRoot()) {
                    userToReset = JCRSessionFactory.getInstance().getCurrentUser();
                    JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
                }
                try {
                    if ("all".equals(exportFormat)) {
                        response.setContentType("application/zip");
                        WebUtils.setNoCacheHeaders(response);
                        params.put("allfiles", Boolean.TRUE);
                        params.put("templates", Boolean.TRUE);
                        params.put("siteinfos", Boolean.TRUE);
                        params.put("definitions", Boolean.TRUE);
                        params.put("wf", Boolean.TRUE);
                        params.put("xsl_path", this.cleanupXsl);
                        outputStream = response.getOutputStream();
                        this.importExportService.exportAll((OutputStream)outputStream, params);
                        outputStream.close();
                    }
                    if (!"site".equals(exportFormat)) ** GOTO lbl150
                    sites = new ArrayList<JCRSiteNode>();
                    sitekeys = request.getParameterValues("sitebox");
                    if (sitekeys != null) {
                        for (String sitekey : sitekeys) {
                            site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(sitekey);
                            sites.add((JCRSiteNode)site);
                        }
                    }
                    if (sites.isEmpty()) {
                    }
                    response.setContentType("application/zip");
                    WebUtils.setNoCacheHeaders(response);
                    params.put("allfiles", Boolean.TRUE);
                    params.put("templates", Boolean.TRUE);
                    params.put("siteinfos", Boolean.TRUE);
                    params.put("definitions", Boolean.TRUE);
                    if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
                        params.put("includeLive", Boolean.TRUE);
                    }
                    if (request.getParameter("users") == null && SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue") != null) {
                        siteExportUsersDefaultValue = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue"));
                        if (siteExportUsersDefaultValue.booleanValue()) {
                            params.put("includeUsers", Boolean.TRUE);
                        } else {
                            params.remove("includeUsers");
                        }
                    } else if (request.getParameter("users") != null) {
                        if (Boolean.valueOf(request.getParameter("users")).booleanValue()) {
                            params.put("includeUsers", Boolean.TRUE);
                        } else {
                            params.remove("includeUsers");
                        }
                    } else {
                        params.put("includeUsers", Boolean.TRUE);
                    }
                    params.put("includeRoles", Boolean.TRUE);
                    params.put("includeMounts", Boolean.TRUE);
                    params.put("wf", Boolean.TRUE);
                    params.put("xsl_path", this.cleanupXsl);
                    outputStream = response.getOutputStream();
                    this.importExportService.exportSites((OutputStream)outputStream, params, sites);
                    outputStream.close();
                }
                finally {
                    if (userToReset != null) {
                        JCRSessionFactory.getInstance().setCurrentUser(userToReset);
                    }
                }
            } else if ("xml".equals(exportFormat)) {
                node = session.getNode(nodePath);
                response.setContentType("text/xml");
                WebUtils.setNoCacheHeaders(response);
                if (this.downloadExportedXmlAsFile) {
                    WebUtils.setFileDownloadHeaders(response, StringUtils.substringBeforeLast((String)node.getName(), (String)".") + ".xml");
                }
                if ("template".equals(request.getParameter("cleanup"))) {
                    params.put("xsl_path", this.templatesCleanupXsl);
                } else if ("simple".equals(request.getParameter("cleanup"))) {
                    params.put("xsl_path", this.cleanupXsl);
                }
                outputStream = response.getOutputStream();
                exportedNode = new Cookie("exportedNode", node.getIdentifier());
                exportedNode.setMaxAge(60);
                exportedNode.setPath("/");
                response.addCookie(exportedNode);
                this.importExportService.exportNode(node, exportRoot, (OutputStream)outputStream, params);
            } else if ("zip".equals(exportFormat)) {
                node = session.getNode(nodePath);
                response.setContentType("application/zip");
                WebUtils.setNoCacheHeaders(response);
                if ("template".equals(request.getParameter("cleanup"))) {
                    params.put("xsl_path", this.templatesCleanupXsl);
                } else if ("simple".equals(request.getParameter("cleanup"))) {
                    params.put("xsl_path", this.cleanupXsl);
                }
                if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
                    params.put("includeLive", Boolean.TRUE);
                }
                outputStream = response.getOutputStream();
                exportedNode = new Cookie("exportedNode", node.getIdentifier());
                exportedNode.setMaxAge(60);
                exportedNode.setPath("/");
                response.addCookie(exportedNode);
                this.importExportService.exportZip(node, exportRoot, (OutputStream)outputStream, params);
                outputStream.close();
            }
lbl150:
            // 8 sources

            response.setStatus(200);
        }
        catch (IOException e) {
            if (Export.logger.isDebugEnabled()) {
                Export.logger.debug("Cannot export due to some IO exception", (Throwable)e);
            } else {
                Export.logger.warn("Cannot export due to some IO exception :" + e.getMessage());
            }
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        catch (Exception e) {
            Export.logger.error("Cannot export", (Throwable)e);
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        return null;
    }

    private Map<String, Object> getParams(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("content", !"false".equals(request.getParameter("viewContent")));
        params.put("version", "true".equals(request.getParameter("viewVersion")));
        params.put("acl", !"false".equals(request.getParameter("viewAcl")));
        params.put("metadata", !"false".equals(request.getParameter("viewMetadata")));
        params.put("links", !"false".equals(request.getParameter("viewLinks")));
        params.put("wf", "true".equals(request.getParameter("viewWorkflow")));
        return params;
    }

    public void setServletContext(ServletContext servletContext) {
        this.cleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/cleanup.xsl");
        this.templatesCleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/templatesCleanup.xsl");
    }

    public void setImportExportService(ImportExportService importExportService) {
        this.importExportService = importExportService;
    }

    public void setDownloadExportedXmlAsFile(boolean downloadExportedXmlAsFile) {
        this.downloadExportedXmlAsFile = downloadExportedXmlAsFile;
    }
}

