/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaControllerUtils;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.springframework.web.servlet.mvc.Controller;

public abstract class JahiaController
implements Controller {
    private boolean requireAuthenticatedUser;
    private String requiredPermission;

    protected static final int getIntParameter(HttpServletRequest request, String name) throws JahiaBadRequestException {
        return JahiaControllerUtils.getIntParameter(request, name);
    }

    protected static final int getIntParameter(HttpServletRequest request, String name, int defaultValue) {
        return JahiaControllerUtils.getIntParameter(request, name, defaultValue);
    }

    protected static final String getParameter(HttpServletRequest request, String name) throws JahiaBadRequestException {
        return JahiaControllerUtils.getParameter(request, name);
    }

    protected static final String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return JahiaControllerUtils.getParameter(request, name, defaultValue);
    }

    protected void checkUserAuthorized() throws JahiaForbiddenAccessException {
        if (this.getRequiredPermission() != null) {
            JahiaControllerUtils.checkUserAuthorized(this.getCurrentUser(), this.getRequiredPermission());
        }
    }

    protected void checkUserAuthorized(JCRNodeWrapper node) throws JahiaForbiddenAccessException {
        if (this.getRequiredPermission() != null) {
            JahiaControllerUtils.checkUserAuthorized(node, this.getCurrentUser(), this.getRequiredPermission());
        }
    }

    protected void checkUserLoggedIn() throws JahiaForbiddenAccessException {
        if (this.isRequireAuthenticatedUser()) {
            JahiaControllerUtils.checkUserLoggedIn(this.getCurrentUser());
        }
    }

    protected JahiaUser getCurrentUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected String getRequiredPermission() {
        return this.requiredPermission;
    }

    protected boolean isRequireAuthenticatedUser() {
        return this.requireAuthenticatedUser;
    }

    protected boolean isUserGuest() {
        return JahiaUserManagerService.isGuest(this.getCurrentUser());
    }

    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = StringUtils.defaultIfBlank((String)requiredPermission, null);
    }
}

