/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.settings.SettingsBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class Login
implements Controller {
    private static final String CONTROLLER_MAPPING = "/login";
    private static final String LOGIN_ERR_PARAM_NAME = "loginError";
    private static final String FAIL_REDIRECT_PARAM = "failureRedirect";
    private static final Pattern ERR_PARAM_NOT_ALONE_PATTERN = Pattern.compile("\\?loginError=([^&]+)\\&");
    private static final Pattern ERR_PARAM_ALONE_PATTERN = Pattern.compile("\\?loginError=([^&]+)");
    private static final Pattern ERR_PARAM_END_PATTERN = Pattern.compile("\\&loginError=([^&]+)");

    public static String getMapping() {
        return CONTROLLER_MAPPING;
    }

    public static String getServletPath() {
        return "/cms/login";
    }

    protected String getRedirectUrl(HttpServletRequest request, HttpServletResponse response) {
        String redirect = StringUtils.defaultIfEmpty((String)request.getParameter("redirect"), (String)(request.getContextPath() + "/welcome"));
        return response.encodeRedirectURL(Login.removeErrorParameter(redirect));
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String result;
        String redirectActiveStr;
        boolean redirectActive;
        boolean restMode = Boolean.valueOf(request.getParameter("restMode"));
        boolean bl = redirectActive = !restMode;
        if (redirectActive && (redirectActiveStr = request.getParameter("redirectActive")) != null) {
            redirectActive = Boolean.parseBoolean(redirectActiveStr);
        }
        if ("ok".equals(result = (String)request.getAttribute("login_valve_result"))) {
            JCRSessionFactory.getInstance().getCurrentUserSession();
            if (redirectActive && Login.isAuthorizedRedirect(request, request.getParameter("redirect"), true)) {
                response.sendRedirect(this.getRedirectUrl(request, response));
            } else {
                response.getWriter().append("OK");
            }
        } else if (!restMode) {
            if (Login.isAuthorizedRedirect(request, request.getParameter(FAIL_REDIRECT_PARAM), false)) {
                if ("bad_password".equals(result)) {
                    result = "unknown_user";
                }
                String failureRedirectUrl = this.sanitizeRedirectURL(request);
                StringBuilder url = new StringBuilder(64);
                url.append(failureRedirectUrl);
                if (failureRedirectUrl.indexOf(63) == -1) {
                    url.append("?loginError=").append(result);
                } else if (failureRedirectUrl.indexOf("?loginError=") == -1 && failureRedirectUrl.indexOf("&loginError=") == -1) {
                    url.append("&loginError=").append(result);
                }
                response.sendRedirect(url.toString());
            } else {
                String theme;
                if (request.getParameter("redirect") != null) {
                    request.setAttribute("javax.servlet.error.request_uri", (Object)request.getParameter("redirect"));
                }
                if ((theme = SettingsBean.getInstance().getPropertiesFile().getProperty("jahia.ui.theme")) != null && !"default".equals(theme)) {
                    String pathToCheck = "/errors/" + theme + "/error_401.jsp";
                    if (request.getServletContext().getResource(pathToCheck) != null) {
                        request.getRequestDispatcher("/errors/" + theme + "/error_401.jsp").forward((ServletRequest)request, (ServletResponse)response);
                        return null;
                    }
                }
                request.getRequestDispatcher("/errors/error_401.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            response.getWriter().append("unauthorized");
        }
        return null;
    }

    private String sanitizeRedirectURL(HttpServletRequest request) {
        String failureRedirectUrl = request.getParameter(FAIL_REDIRECT_PARAM);
        if (StringUtils.isNotEmpty((String)failureRedirectUrl) && failureRedirectUrl.indexOf(LOGIN_ERR_PARAM_NAME) > -1) {
            String[] urlParts = StringUtils.split((String)failureRedirectUrl, (String)"\\?");
            StringBuilder sanitizedUrlSb = new StringBuilder(urlParts[0]);
            if (urlParts.length > 1) {
                String[] urlParams = StringUtils.split((String)urlParts[1], (String)"&");
                StringBuilder paramSb = new StringBuilder();
                for (int i = 0; i < urlParams.length; ++i) {
                    if (urlParams[i].indexOf(LOGIN_ERR_PARAM_NAME) != -1) continue;
                    paramSb.append(urlParams[i]);
                }
                if (StringUtils.isNotEmpty((String)paramSb.toString())) {
                    sanitizedUrlSb.append("?").append(paramSb.toString());
                }
            }
            failureRedirectUrl = sanitizedUrlSb.toString();
        }
        return failureRedirectUrl;
    }

    protected static boolean isAuthorizedRedirect(HttpServletRequest request, String redirectUrl, boolean authorizeNullRedirect) {
        if (redirectUrl == null) {
            return authorizeNullRedirect;
        }
        boolean startWithDoubleSlash = redirectUrl.startsWith("//");
        if (redirectUrl.contains("://") || startWithDoubleSlash) {
            if (redirectUrl.startsWith("http://") || redirectUrl.startsWith("https://") || startWithDoubleSlash) {
                String urlBase;
                String redirectUrlAfterProtocol = StringUtils.substringAfter((String)redirectUrl, (String)"//");
                if (redirectUrlAfterProtocol.startsWith(urlBase = StringUtils.substringAfter((String)StringUtils.removeEnd((String)request.getRequestURL().toString(), (String)request.getRequestURI()), (String)"://"))) {
                    return true;
                }
                for (String authorizedRedirectHost : SettingsBean.getInstance().getAuthorizedRedirectHosts()) {
                    if (!redirectUrlAfterProtocol.startsWith(authorizedRedirectHost)) continue;
                    return true;
                }
            }
            return false;
        }
        int indexOfColon = redirectUrl.indexOf(":");
        int indexOfSlash = redirectUrl.indexOf("/");
        return indexOfColon < 0 || indexOfSlash >= 0 && indexOfColon >= indexOfSlash;
    }

    protected static String removeErrorParameter(String redirect) {
        redirect = ERR_PARAM_NOT_ALONE_PATTERN.matcher(redirect).replaceAll("\\?");
        redirect = ERR_PARAM_ALONE_PATTERN.matcher(redirect).replaceAll("");
        redirect = ERR_PARAM_END_PATTERN.matcher(redirect).replaceAll("");
        return redirect;
    }
}

