/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Login;
import org.jahia.exceptions.JahiaException;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;

public class Logout
implements Controller {
    private static final String DEFAULT_LOCALE = Locale.ENGLISH.toString();
    private static final transient Logger logger = LoggerFactory.getLogger(Logout.class);
    private JahiaUserManagerService userManagerService;
    protected CookieAuthConfig cookieAuthConfig;
    protected URLResolverFactory urlResolverFactory;
    protected UrlRewriteService urlRewriteService;
    private boolean fireLogoutEvent = false;
    private String preserveSessionAttributes = null;

    public static String getLogoutServletPath() {
        return "/cms/logout";
    }

    public void setFireLogoutEvent(boolean fireLogoutEvent) {
        this.fireLogoutEvent = fireLogoutEvent;
    }

    public void setPreserveSessionAttributes(String preserveSessionAttributes) {
        this.preserveSessionAttributes = preserveSessionAttributes;
    }

    private void addLocale(final JCRSiteNode site, final List<Locale> newLocaleList, final Locale curLocale) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", curLocale, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        JCRSiteNode nodeByIdentifier;
                        JCRNodeWrapper home;
                        if (site != null && (home = (nodeByIdentifier = (JCRSiteNode)session.getNodeByIdentifier(site.getIdentifier())).getHome()) != null && !newLocaleList.contains(curLocale)) {
                            newLocaleList.add(curLocale);
                        }
                    }
                    catch (RepositoryException e) {
                        logger.debug("This site does not have a published home in language " + curLocale, (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirect = request.getParameter("redirect");
        if (redirect == null) {
            redirect = request.getHeader("referer");
            if (StringUtils.isNotEmpty((String)redirect) && Login.isAuthorizedRedirect(request, redirect, false)) {
                redirect = redirect.startsWith("http://") ? StringUtils.substringAfter((String)redirect, (String)"http://") : StringUtils.substringAfter((String)redirect, (String)"https://");
                redirect = redirect.contains("/") ? "/" + StringUtils.substringAfter((String)redirect, (String)"/") : null;
            } else {
                redirect = null;
            }
        } else if (!Login.isAuthorizedRedirect(request, redirect, false)) {
            redirect = null;
        }
        if (StringUtils.isNotBlank((String)redirect)) {
            try {
                RewrittenUrl restored;
                final String r = redirect;
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                    public String getRequestURI() {
                        return r;
                    }

                    public String getPathInfo() {
                        if (r.startsWith(this.getContextPath() + "/cms/")) {
                            return StringUtils.substringAfter((String)r, (String)(this.getContextPath() + "/cms"));
                        }
                        return null;
                    }
                };
                if (this.urlRewriteService.prepareInbound((HttpServletRequest)wrapper, response) && (restored = this.urlRewriteService.rewriteInbound((HttpServletRequest)wrapper, response)) != null) {
                    redirect = request.getContextPath() + restored.getTarget();
                }
            }
            catch (Exception e) {
                logger.error("Cannot rewrite redirection url", (Throwable)e);
            }
            String prefix = request.getContextPath() + "/cms/";
            if (redirect.startsWith(prefix)) {
                String url = "/" + StringUtils.substringAfter((String)redirect, (String)prefix);
                String hash = StringUtils.substringAfterLast((String)url, (String)"#");
                url = StringUtils.substringBefore((String)url, (String)(";" + SettingsBean.getInstance().getJsessionIdParameterName()));
                url = StringUtils.substringBefore((String)url, (String)"?");
                url = StringUtils.substringBefore((String)url, (String)"#");
                if (hash != null && hash.startsWith("/sites/") && url.contains("/sites/")) {
                    url = StringUtils.substringBefore((String)url, (String)"/sites/") + StringUtils.substringBefore((String)hash, (String)":") + ".html";
                }
                ArrayList<String> urls = new ArrayList<String>();
                urls.add(url);
                if (url.startsWith("/edit/")) {
                    url = "/render/" + StringUtils.substringAfter((String)url, (String)"/edit/");
                    urls.add(url);
                } else if (url.startsWith("/editframe/default/")) {
                    url = "/render/live/" + StringUtils.substringAfter((String)url, (String)"/editframe/default/");
                    urls.add(url);
                } else if (url.startsWith("/contribute/")) {
                    url = "/render/" + StringUtils.substringAfter((String)url, (String)"/contribute/");
                    urls.add(url);
                } else if (url.startsWith("/contributeframe/default/")) {
                    url = "/render/live/" + StringUtils.substringAfter((String)url, (String)"/contributeframe/default/");
                    urls.add(url);
                }
                if (url.startsWith("/render/default/")) {
                    url = "/render/live/" + StringUtils.substringAfter((String)url, (String)"/render/default/");
                    urls.add(url);
                }
                for (String currentUrl : urls) {
                    try {
                        URLResolver r = this.urlResolverFactory.createURLResolver(currentUrl, request.getServerName(), request);
                        if (r.getPath().startsWith("/sites/")) {
                            JCRNodeWrapper n = r.getNode();
                            if (n.isNodeType("jnt:virtualsite")) {
                                n = ((JCRSiteNode)n).getHome();
                            }
                            redirect = n == null ? request.getContextPath() + "/" : prefix + r.getServletPart() + "/" + r.getWorkspace() + "/" + this.resolveLanguage(request, n.getResolveSite()) + n.getPath() + ".html";
                        } else {
                            redirect = request.getContextPath() + "/";
                        }
                        redirect = this.urlRewriteService.rewriteOutbound(redirect, request, response);
                        response.sendRedirect(response.encodeRedirectURL(redirect));
                        return;
                    }
                    catch (Exception e) {
                        logger.debug("Cannot redirect to " + currentUrl, (Throwable)e);
                    }
                }
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/"));
                return;
            }
        }
        response.sendRedirect(response.encodeRedirectURL(StringUtils.isNotEmpty((String)redirect) ? redirect : request.getContextPath() + "/"));
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.cookieAuthConfig.isActivated()) {
            this.removeAuthCookie(request, response);
        }
        Locale uiLocale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale");
        Locale locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.currentlocale");
        if (this.fireLogoutEvent) {
            SpringContextSingleton.getInstance().publishEvent(new LogoutEvent(this, request, response));
        }
        Map<String, Object> savedSessionAttributes = this.preserveSessionAttributes(request);
        request.getSession().invalidate();
        this.restoreSessionAttributes(request, savedSessionAttributes);
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupUserByPath("/users/guest").getJahiaUser());
        request.getSession().setAttribute("org.jahia.services.multilang.uilocale", (Object)uiLocale);
        request.getSession().setAttribute("org.jahia.services.multilang.currentlocale", (Object)locale);
        String redirectActiveStr = request.getParameter("redirectActive");
        if (redirectActiveStr == null || Boolean.parseBoolean(redirectActiveStr)) {
            this.doRedirect(request, response);
        }
        return null;
    }

    protected void removeAuthCookie(HttpServletRequest request, HttpServletResponse response) {
        JahiaUser curUser = JCRSessionFactory.getInstance().getCurrentUser();
        JCRPropertyWrapper cookieAuthKey = null;
        try {
            if (!JahiaUserManagerService.isGuest(curUser)) {
                JCRUserNode userNode = this.userManagerService.lookupUserByPath(curUser.getLocalPath());
                String userPropertyName = this.cookieAuthConfig.getUserPropertyName();
                if (userNode != null && userNode.hasProperty(userPropertyName)) {
                    cookieAuthKey = userNode.getProperty(userPropertyName);
                }
            }
            if (cookieAuthKey != null) {
                Cookie authCookie = new Cookie(this.cookieAuthConfig.getCookieName(), cookieAuthKey.getString());
                authCookie.setPath(StringUtils.isNotEmpty((String)request.getContextPath()) ? request.getContextPath() : "/");
                authCookie.setMaxAge(0);
                authCookie.setHttpOnly(this.cookieAuthConfig.isHttpOnly());
                authCookie.setSecure(this.cookieAuthConfig.isSecure());
                response.addCookie(authCookie);
                if (!SettingsBean.getInstance().isFullReadOnlyMode()) {
                    cookieAuthKey.remove();
                    cookieAuthKey.getSession().save();
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String resolveLanguage(HttpServletRequest request, JCRSiteNode site) throws JahiaException {
        ArrayList<Locale> newLocaleList = new ArrayList<Locale>();
        List<Object> siteLanguages = Collections.emptyList();
        try {
            if (site != null) {
                siteLanguages = site.getLanguagesAsLocales();
            }
        }
        catch (Exception t) {
            logger.debug("Exception while getting language settings as locales", (Throwable)t);
        }
        EnumerationIterator browserLocales = new EnumerationIterator(request.getLocales());
        while (browserLocales.hasNext()) {
            Locale langOnlyLocale;
            Locale curLocale = (Locale)browserLocales.next();
            if (siteLanguages.contains(curLocale)) {
                this.addLocale(site, newLocaleList, curLocale);
                continue;
            }
            if (StringUtils.isEmpty((String)curLocale.getCountry()) || !siteLanguages.contains(langOnlyLocale = new Locale(curLocale.getLanguage()))) continue;
            this.addLocale(site, newLocaleList, langOnlyLocale);
        }
        String language = DEFAULT_LOCALE;
        if (!newLocaleList.isEmpty()) {
            language = ((Locale)newLocaleList.get(0)).toString();
        } else if (site != null) {
            language = site.getDefaultLanguage();
        } else if (!StringUtils.isEmpty((String)SettingsBean.getInstance().getDefaultLanguageCode())) {
            language = SettingsBean.getInstance().getDefaultLanguageCode();
        }
        return language;
    }

    public void setCookieAuthConfig(CookieAuthConfig cookieAuthConfig) {
        this.cookieAuthConfig = cookieAuthConfig;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setUrlRewriteService(UrlRewriteService urlRewriteService) {
        this.urlRewriteService = urlRewriteService;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    private Map<String, Object> preserveSessionAttributes(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> savedSessionAttributes = new HashMap<String, Object>();
        if (this.preserveSessionAttributes != null && httpServletRequest.getSession(false) != null && this.preserveSessionAttributes.length() > 0) {
            String[] sessionAttributeNames = Patterns.TRIPLE_HASH.split(this.preserveSessionAttributes);
            HttpSession session = httpServletRequest.getSession(false);
            for (String sessionAttributeName : sessionAttributeNames) {
                Object attributeValue = session.getAttribute(sessionAttributeName);
                if (attributeValue == null) continue;
                savedSessionAttributes.put(sessionAttributeName, attributeValue);
            }
        }
        return savedSessionAttributes;
    }

    private void restoreSessionAttributes(HttpServletRequest httpServletRequest, Map<String, Object> savedSessionAttributes) {
        if (savedSessionAttributes.size() > 0) {
            HttpSession session = httpServletRequest.getSession();
            for (Map.Entry<String, Object> savedSessionAttribute : savedSessionAttributes.entrySet()) {
                session.setAttribute(savedSessionAttribute.getKey(), savedSessionAttribute.getValue());
            }
        }
    }

    public class LogoutEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7031797336948851970L;
        private HttpServletRequest request;
        private HttpServletResponse response;

        public LogoutEvent(Object source, HttpServletRequest request, HttpServletResponse response) {
            super(source);
            this.request = request;
            this.response = response;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

