/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.errors.ErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaNotFoundException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.exceptions.JahiaServiceUnavailableException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.render.AjaxRenderException;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;

public class DefaultErrorHandler
implements ErrorHandler {
    public static DefaultErrorHandler getInstance() {
        return (DefaultErrorHandler)SpringContextSingleton.getBean("org.jahia.bin.errors.handler");
    }

    @Override
    public boolean handle(Throwable e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int code = 500;
        if (e instanceof ServletException) {
            e = ((ServletException)e).getRootCause();
        }
        if (e instanceof RenderException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof PathNotFoundException) {
            code = 404;
        } else if (e instanceof TemplateNotFoundException) {
            code = 404;
        } else if (e instanceof AjaxRenderException) {
            code = 404;
        } else if (e instanceof AccessDeniedException) {
            code = JahiaUserManagerService.isGuest(JCRSessionFactory.getInstance().getCurrentUser()) ? 401 : 403;
        } else if (e instanceof JahiaException) {
            code = ((JahiaException)e).getResponseErrorCode();
        } else if (e instanceof JahiaRuntimeException) {
            if (e instanceof JahiaBadRequestException) {
                code = 400;
            } else if (e instanceof JahiaUnauthorizedException) {
                code = 401;
            } else if (e instanceof JahiaNotFoundException) {
                code = 404;
            } else if (e instanceof JahiaServiceUnavailableException) {
                code = 503;
            }
        } else if (e instanceof ClassNotFoundException) {
            code = 400;
        } else if (e instanceof IOException || e instanceof ServletException) {
            // empty if block
        }
        if (code != 0) {
            request.setAttribute("org.jahia.exception", (Object)e);
            if (SettingsBean.getInstance().isDevelopmentMode()) {
                StringWriter traceWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(traceWriter));
                traceWriter.flush();
                request.setAttribute("org.jahia.exception.trace", (Object)traceWriter.getBuffer().toString());
            }
            if (!response.isCommitted()) {
                response.sendError(code, e.getMessage());
            }
            return true;
        }
        return false;
    }
}

