/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.listeners;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.osgi.FrameworkService;
import org.springframework.web.util.Log4jConfigListener;

public class LoggingConfigListener
extends Log4jConfigListener {
    public static final String EVENT_TOPIC_LOGGING = "org/jahia/dx/logging";
    public static final String EVENT_TYPE_LOGGING_CONFIG_CHANGED = "loggingConfigurationChanged";
    private static final String JAHIA_LOG_DIR = "jahia.log.dir";
    private static final String JAHIA_LOG4J_CONFIG = "jahia.log4j.config";
    private static final String JAHIA_LOG4J_XML = "jahia/log4j.xml";

    public static Hashtable<String, Object> getConfig() {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger next = (Logger)loggers.nextElement();
            if (next.getLevel() == null) continue;
            p.put("log4j.category." + next.getName(), next.getLevel().toString());
        }
        return p;
    }

    public static String getRootLoggerLevel() {
        return LogManager.getRootLogger().getLevel().toString();
    }

    private static Logger getTargetLogger(String logger) {
        Logger rootLogger = LogManager.getRootLogger();
        return logger.equals(rootLogger.getName()) ? rootLogger : LogManager.getLogger((String)logger);
    }

    public static void setLoggerLevel(String logger, String level) {
        LoggingConfigListener.getTargetLogger(logger).setLevel(Level.toLevel((String)level));
        FrameworkService.sendEvent(EVENT_TOPIC_LOGGING, Collections.singletonMap("type", EVENT_TYPE_LOGGING_CONFIG_CHANGED), false);
    }

    public void contextInitialized(ServletContextEvent event) {
        this.initLogDir(event.getServletContext());
        this.initLog4jLocation();
        super.contextInitialized(event);
    }

    private void initLog4jLocation() {
        String lookup = null;
        if (System.getProperty(JAHIA_LOG4J_CONFIG) == null) {
            lookup = ((Object)((Object)this)).getClass().getResource("/jahia/log4j.xml") != null ? "classpath:jahia/log4j.xml" : "/WEB-INF/etc/config/log4j.xml";
            JahiaContextLoaderListener.setSystemProperty(JAHIA_LOG4J_CONFIG, lookup);
        } else {
            lookup = System.getProperty(JAHIA_LOG4J_CONFIG, lookup);
        }
        System.out.println("Set log4j.xml configuration location to: " + lookup);
    }

    protected void initLogDir(ServletContext servletContext) {
        String logDir = System.getProperty(JAHIA_LOG_DIR);
        if (logDir == null) {
            try {
                String server = servletContext.getServerInfo() != null ? servletContext.getServerInfo().toLowerCase() : null;
                String path = servletContext.getRealPath("/");
                if (server != null && path != null) {
                    if (server.contains("tomcat")) {
                        File logs;
                        File tomcatHome;
                        File war = new File(path);
                        if (war.getParentFile() != null && "webapps".equals(war.getParentFile().getName()) && (tomcatHome = war.getParentFile().getParentFile()).exists() && (logs = new File(tomcatHome, "logs")).isDirectory() && logs.canWrite()) {
                            logDir = logs.getAbsolutePath();
                        }
                    } else if (server.contains("jboss")) {
                        File deploymentsFolder;
                        File war = new File(path);
                        File earFolder = war.getParentFile();
                        if (earFolder != null && (deploymentsFolder = earFolder.getParentFile()) != null) {
                            File vfsFolder;
                            if ("deployments".equals(deploymentsFolder.getName())) {
                                File log;
                                File standaloneFolder = deploymentsFolder.getParentFile();
                                if (standaloneFolder != null && (log = new File(standaloneFolder, "log")).isDirectory() && log.canWrite()) {
                                    logDir = log.getAbsolutePath();
                                }
                            } else if ("deployment".equals(deploymentsFolder.getName()) && (vfsFolder = deploymentsFolder.getParentFile()) != null && "vfs".equals(vfsFolder.getName())) {
                                File log;
                                File standaloneFolder;
                                File file = standaloneFolder = vfsFolder.getParentFile() != null ? vfsFolder.getParentFile().getParentFile() : null;
                                if (standaloneFolder != null && (log = new File(standaloneFolder, "log")).isDirectory() && log.canWrite()) {
                                    logDir = log.getAbsolutePath();
                                }
                            }
                        }
                    } else if (server.contains("websphere")) {
                        File logs = new File("logs");
                        if (logs.isDirectory() && new File("installedApps").exists()) {
                            logDir = logs.getAbsolutePath();
                        } else {
                            File log;
                            File appSrv;
                            File installedApps;
                            File nodeCell;
                            File war = new File(path);
                            File earFolder = war.getParentFile();
                            if (earFolder != null && (nodeCell = earFolder.getParentFile()) != null && (installedApps = nodeCell.getParentFile()) != null && "installedApps".equals(installedApps.getName()) && (appSrv = installedApps.getParentFile()).exists() && (log = new File(appSrv, "logs")).isDirectory() && log.canWrite()) {
                                logDir = log.getAbsolutePath();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logDir != null) {
            if (!logDir.endsWith("/") || !logDir.endsWith("\\")) {
                logDir = logDir + File.separator;
            }
            JahiaContextLoaderListener.setSystemProperty(JAHIA_LOG_DIR, logDir);
        }
        System.out.println("Logging directory set to: " + (logDir != null ? logDir : "<current>"));
    }
}

