/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.templates;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.jahia.commons.Version;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.modulemanager.Constants;

public class ModulesPackage {
    private Map<String, PackagedModule> modules = new LinkedHashMap<String, PackagedModule>();
    private String name;
    private String description;
    private Version version;

    public static ModulesPackage create(JarFile jarFile) throws IOException {
        return new ModulesPackage(jarFile);
    }

    private static Collection<String> getPackageNames(PackagedModule module, String attributeName) {
        String attributeValue = module.getManifestAttributes().getValue(attributeName);
        if (StringUtils.isEmpty((String)attributeValue)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
        for (Clause clause : Parser.parseHeader((String)attributeValue)) {
            packageNames.add(clause.getName());
        }
        return packageNames;
    }

    private static Set<String> parseDependencies(Attributes manifestAttributes) {
        Set<String> dependencies = Collections.emptySet();
        String dependsValue = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_DEPENDS);
        if (dependsValue != null && dependsValue.length() > 0) {
            dependencies = new LinkedHashSet<String>();
            dependencies.addAll(Arrays.asList(StringUtils.split((String)dependsValue, (String)", ")));
        }
        return dependencies;
    }

    protected static void sortByDependencies(Map<String, PackagedModule> modules) throws CycleDetectedException {
        if (modules.size() <= 1) {
            return;
        }
        LinkedHashMap<String, PackagedModule> copy = new LinkedHashMap<String, PackagedModule>(modules);
        DAG dag = new DAG();
        HashMap<String, String> exports = new HashMap<String, String>();
        for (PackagedModule module : modules.values()) {
            Collection<String> exportPackages = ModulesPackage.getPackageNames(module, "Export-Package");
            for (String exportPackage : exportPackages) {
                exports.put(exportPackage, module.getName());
            }
        }
        for (PackagedModule module : modules.values()) {
            String moduleName = module.getName();
            dag.addVertex(moduleName);
            for (String dependency : module.getDepends()) {
                if (!modules.containsKey(dependency)) continue;
                dag.addEdge(moduleName, dependency);
            }
            Collection<String> importPackages = ModulesPackage.getPackageNames(module, "Import-Package");
            for (String importPackageName : importPackages) {
                if (!exports.containsKey(importPackageName) || ((String)exports.get(importPackageName)).equals(moduleName) || dag.hasEdge(moduleName, (String)exports.get(importPackageName))) continue;
                dag.addEdge(moduleName, (String)exports.get(importPackageName));
            }
        }
        List vertexes = TopologicalSorter.sort((DAG)dag);
        modules.clear();
        for (String vertex : vertexes) {
            modules.put(vertex, (PackagedModule)copy.get(vertex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModulesPackage(JarFile jarFile) throws IOException {
        Attributes manifestAttributes = jarFile.getManifest().getMainAttributes();
        this.version = new Version(manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_VERSION));
        this.name = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_NAME);
        this.description = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_DESCRIPTION);
        Enumeration<JarEntry> jars = jarFile.entries();
        while (jars.hasMoreElements()) {
            JarEntry jar = jars.nextElement();
            ZipFile moduleJarFile = null;
            FileOutputStream output = null;
            if (!StringUtils.endsWith((String)jar.getName(), (String)".jar")) continue;
            try {
                InputStream input = jarFile.getInputStream(jar);
                File moduleFile = File.createTempFile(jar.getName(), "");
                output = new FileOutputStream(moduleFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)output).write(bytes, 0, read);
                }
                moduleJarFile = new JarFile(moduleFile);
                Attributes moduleManifestAttributes = ((JarFile)moduleJarFile).getManifest().getMainAttributes();
                String bundleName = moduleManifestAttributes.getValue(Constants.ATTR_NAME_BUNDLE_SYMBOLIC_NAME);
                if (bundleName == null) {
                    throw new IOException("Jar file " + jar.getName() + " in package does not seem to be a valid bundle.");
                }
                this.modules.put(bundleName, new PackagedModule(bundleName, moduleManifestAttributes, moduleFile));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            if (moduleJarFile == null) continue;
            moduleJarFile.close();
        }
        try {
            ModulesPackage.sortByDependencies(this.modules);
        }
        catch (CycleDetectedException e) {
            throw new JahiaRuntimeException("A cyclic dependency detected in the modules of the supplied package", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, PackagedModule> getModules() {
        return this.modules;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public static class PackagedModule {
        private final Attributes manifestAttributes;
        private final File moduleFile;
        private final String name;
        private final Set<String> depends;

        protected PackagedModule(String name, Attributes manifestAttributes, File moduleFile) {
            this.name = name;
            this.manifestAttributes = manifestAttributes;
            this.moduleFile = moduleFile;
            this.depends = ModulesPackage.parseDependencies(manifestAttributes);
        }

        public Attributes getManifestAttributes() {
            return this.manifestAttributes;
        }

        public File getModuleFile() {
            return this.moduleFile;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getDepends() {
            return this.depends;
        }
    }
}

