/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.karaf.main.util.SimpleMavenResolver;
import org.apache.karaf.util.config.PropertiesLoader;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleStarter {
    private static final Logger logger = LoggerFactory.getLogger(BundleStarter.class);
    private static final String MARKER_INITIAL_BUNDLES = "[initial-bundles].dostart";
    private static final String MARKER_MIGRATE_BUNDLES = "[migrate-bundles].dostart";
    private BundleContext bundleContext;
    private File deployedBundlesDir = new File(System.getProperty("org.osgi.framework.storage"));
    private boolean firstStartup = !new File(this.deployedBundlesDir, "bundle0").exists();

    private static Collection<Bundle> getSortedModules(Map<Bundle, JahiaTemplatesPackage> modulesByBundle) {
        long startTime = System.currentTimeMillis();
        try {
            DAG dag = new DAG();
            HashMap<String, Bundle> bundlesByModuleId = new HashMap<String, Bundle>();
            for (Map.Entry<Bundle, JahiaTemplatesPackage> entry : modulesByBundle.entrySet()) {
                JahiaTemplatesPackage pkg = entry.getValue();
                String pkgId = pkg.getId();
                bundlesByModuleId.put(pkgId, entry.getKey());
                dag.addVertex(pkgId);
                for (String depPkg : pkg.getDepends()) {
                    dag.addEdge(pkgId, depPkg);
                }
                if (pkg.getDepends().contains("default") || pkg.getDepends().contains("Default Jahia Templates") || ServicesRegistry.getInstance().getJahiaTemplateManagerService().getModulesWithNoDefaultDependency().contains(pkg.getId())) continue;
                dag.addEdge(pkgId, "default");
            }
            LinkedList<Bundle> sortedBundles = new LinkedList<Bundle>();
            List vertexes = TopologicalSorter.sort((DAG)dag);
            for (String v : vertexes) {
                Bundle b = (Bundle)bundlesByModuleId.get(v);
                if (b == null) continue;
                sortedBundles.add(b);
            }
            logger.info("Sorted bundles in {} ms", (Object)(System.currentTimeMillis() - startTime));
            return sortedBundles;
        }
        catch (CycleDetectedException e) {
            logger.error("A cyclic dependency detected in the modules to be started", (Throwable)e);
            return modulesByBundle.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startBundles(Map<Bundle, JahiaTemplatesPackage> toBeStarted, boolean useModuleManagerApi) {
        logger.info("Will start {} bundle(s)", (Object)toBeStarted.size());
        Collection<Bundle> sortedBundles = BundleStarter.getSortedModules(toBeStarted);
        try {
            for (Bundle bundle : sortedBundles) {
                try {
                    logger.info("Triggering start for bundle {}/{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
                    if (useModuleManagerApi) {
                        ModuleUtils.getModuleManager().start(BundleInfo.fromBundle(bundle).getKey(), null);
                        continue;
                    }
                    bundle.start();
                }
                catch (Exception e) {
                    BundleException be = null;
                    if (e instanceof BundleException) {
                        be = (BundleException)((Object)e);
                    } else if (e instanceof ModuleManagementException && e.getCause() instanceof BundleException) {
                        be = (BundleException)e.getCause();
                    }
                    if (be != null && 4 == be.getType()) {
                        logger.warn(be.getMessage());
                        continue;
                    }
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            logger.info("Finished starting {} bundle(s)", (Object)toBeStarted.size());
        }
    }

    static void startModules(List<Bundle> moduleBundles, boolean useModuleManagerApi) {
        HashMap<Bundle, JahiaTemplatesPackage> toBeStarted = new HashMap<Bundle, JahiaTemplatesPackage>();
        for (Bundle bundle : moduleBundles) {
            JahiaTemplatesPackage pkg = BundleUtils.getModule(bundle);
            if (pkg != null) {
                toBeStarted.put(bundle, pkg);
                continue;
            }
            logger.warn("Unable to retrieve module package for bundle {}/{}. Skip starting it.", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        }
        BundleStarter.startBundles(toBeStarted, useModuleManagerApi);
    }

    BundleStarter() {
    }

    void afterFileInstallStarted() {
        if (this.firstStartup) {
            this.firstStartup = false;
            if (!this.isFileinstallStartsNewBundles()) {
                this.startAllModules();
            }
        }
        this.startMigrateBundlesIfNeeded();
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = FrameworkService.getBundleContext();
        }
        return this.bundleContext;
    }

    private List<File> getBundleRepos() {
        ArrayList<File> bundleDirs = new ArrayList<File>();
        File baseSystemRepo = new File(System.getProperty("karaf.home"), System.getProperty("karaf.default.repository", "system"));
        if (!baseSystemRepo.exists() && baseSystemRepo.isDirectory()) {
            throw new RuntimeException("system repo folder not found: " + baseSystemRepo.getAbsolutePath());
        }
        bundleDirs.add(baseSystemRepo);
        return bundleDirs;
    }

    private boolean isFileinstallStartsNewBundles() {
        return Boolean.valueOf(((Properties)SpringContextSingleton.getBean("felixFileInstallConfig")).getProperty("felix.fileinstall.bundles.new.start", "true"));
    }

    private void startAllModules() {
        LinkedList<Bundle> toBeStarted = new LinkedList<Bundle>();
        for (Bundle bundle : this.getBundleContext().getBundles()) {
            if (bundle.getState() == 32 || bundle.getState() == 1 || BundleUtils.isFragment(bundle) || !BundleUtils.isJahiaModuleBundle(bundle)) continue;
            toBeStarted.add(bundle);
        }
        BundleStarter.startModules(toBeStarted, false);
    }

    void startInitialBundlesIfNeeded() {
        File marker = new File(this.deployedBundlesDir, MARKER_INITIAL_BUNDLES);
        if (!marker.exists()) {
            return;
        }
        logger.info("Installing and starting initial bundles");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        BundleContext ctx = this.getBundleContext();
        File startupPropsFile = new File(System.getProperty("karaf.etc"), "startup.properties");
        org.apache.felix.utils.properties.Properties startupProps = PropertiesLoader.loadPropertiesOrFail((File)startupPropsFile);
        List<File> bundleDirs = this.getBundleRepos();
        SimpleMavenResolver resolver = new SimpleMavenResolver(bundleDirs);
        LinkedList<Bundle> bundlesToStart = new LinkedList<Bundle>();
        for (String key : startupProps.keySet()) {
            Integer startLevel = new Integer(startupProps.getProperty(key).trim());
            try {
                URI resolvedURI = resolver.resolve(new URI(key));
                Bundle b = ctx.installBundle(key, resolvedURI.toURL().openStream());
                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(startLevel.intValue());
                if (BundleUtils.isFragment(b)) continue;
                bundlesToStart.add(b);
            }
            catch (Exception e) {
                throw new RuntimeException("Error installing bundle listed in " + startupPropsFile + " with url: " + key + " and startlevel: " + startLevel, e);
            }
        }
        for (Bundle b : bundlesToStart) {
            try {
                b.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Error starting bundle " + b.getSymbolicName() + "/" + b.getVersion(), e);
            }
        }
        logger.info("All initial bundles installed and set to start");
        FileUtils.deleteQuietly((File)marker);
    }

    private void startMigrateBundlesIfNeeded() {
        File marker = new File(this.deployedBundlesDir, MARKER_MIGRATE_BUNDLES);
        if (!marker.exists()) {
            return;
        }
        logger.info("Starting migrated bundles");
        try {
            LinkedList<Bundle> toBeStarted = new LinkedList<Bundle>();
            List lines = FileUtils.readLines((File)marker);
            for (String line : lines) {
                String[] lineParts = line.split(",");
                String bundleSymbolicName = lineParts[0].trim();
                String bundleVersion = lineParts[1].trim();
                logger.info("Found entry for bundle {}/{}", (Object)bundleSymbolicName, (Object)bundleVersion);
                Bundle bundle = BundleUtils.getBundleBySymbolicName(bundleSymbolicName, bundleVersion);
                if (bundle != null) {
                    if (bundle.getState() != 32 && bundle.getState() != 1 && !BundleUtils.isFragment(bundle) && !((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted()) {
                        toBeStarted.add(bundle);
                        continue;
                    }
                    logger.info("No need to start bundle {}/{}. Skipping it.", (Object)bundleSymbolicName, (Object)bundleVersion);
                    continue;
                }
                logger.warn("Cannot find bundle {}/{}. Skip starting it.", (Object)bundleSymbolicName, (Object)bundleVersion);
            }
            if (!toBeStarted.isEmpty()) {
                BundleStarter.startModules(toBeStarted, false);
            }
            logger.info("Finished starting migrated bundles");
            FileUtils.deleteQuietly((File)marker);
        }
        catch (IOException e) {
            logger.error("Error reading [migrate-bundles].dostart Cause: " + e.getMessage(), (Throwable)e);
        }
    }
}

