/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.karaf.main.Main;
import org.apache.karaf.util.config.PropertiesLoader;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleStarter;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.ScriptEngineUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class FrameworkService
implements FrameworkListener {
    public static final String EVENT_TOPIC_LIFECYCLE = "org/jahia/dx/lifecycle";
    public static final String EVENT_TYPE_CLUSTERING_FEATURE_INSTALLED = "clusteringFeatureInstalled";
    public static final String EVENT_TYPE_OSGI_STARTED = "osgiContainerStarted";
    private static final Logger logger = LoggerFactory.getLogger(FrameworkService.class);
    private boolean fileInstallStarted;
    private boolean frameworkStartLevelReached;
    private Main main;
    private final ServletContext servletContext;
    private long startTime;
    private int frameworkBeginningStartLevel = 100;
    private BundleStarter bundleStarter;
    private Timer startLevelTimer = new Timer("OSGi-FrameworkService-Startup-Timer", true);

    public static BundleContext getBundleContext() {
        FrameworkService instance = FrameworkService.getInstance();
        if (instance != null && instance.main != null) {
            return instance.main.getFramework().getBundleContext();
        }
        return null;
    }

    public static FrameworkService getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyFileInstallStarted() {
        FrameworkService instance = FrameworkService.getInstance();
        instance.bundleStarter.afterFileInstallStarted();
        FrameworkService frameworkService = instance;
        synchronized (frameworkService) {
            instance.fileInstallStarted = true;
            logger.info("FileInstall watcher started");
            instance.notifyStarted();
        }
    }

    private void notifyStarted() {
        if (this.frameworkStartLevelReached && this.fileInstallStarted) {
            FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_OSGI_STARTED), false);
            this.notifyAll();
            logger.info("OSGi platform service initialized in {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        }
    }

    public static void sendEvent(String topic, Map<String, ?> properties, boolean asynchronous) {
        BundleContext context = FrameworkService.getBundleContext();
        ServiceReference ref = context.getServiceReference(EventAdmin.class.getName());
        if (ref != null) {
            Object service = context.getService(ref);
            try {
                ClassLoader classLoader = service.getClass().getClassLoader();
                Object evt = classLoader.loadClass("org.osgi.service.event.Event").getConstructor(String.class, Map.class).newInstance(topic, properties);
                logger.info("Sending {} event with the properties {} to the topic {}...", new Object[]{asynchronous ? "asynchronous" : "synchronous", properties, topic});
                MethodUtils.invokeExactMethod((Object)service, (String)(asynchronous ? "postEvent" : "sendEvent"), evt);
                logger.info("Event sent to the topic {}", (Object)topic);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private FrameworkService(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private Map<String, String> filterOutSystemProperties() {
        if (!"was".equals(SettingsBean.getInstance().getServer())) {
            return null;
        }
        HashMap<String, String> filteredOutSystemProperties = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        for (String prop : sysProps.stringPropertyNames()) {
            if (!prop.startsWith("org.osgi.framework.")) continue;
            logger.info("Filtering out system property {}", (Object)prop);
            filteredOutSystemProperties.put(prop, sysProps.getProperty(prop));
            sysProps.remove(prop);
        }
        return filteredOutSystemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8 && BundleLifecycleUtils.getFrameworkStartLevel() >= this.frameworkBeginningStartLevel) {
            FrameworkService frameworkService = this;
            synchronized (frameworkService) {
                if (!this.frameworkStartLevelReached) {
                    this.frameworkStartLevelReached = true;
                    logger.info("Framework start level reached " + this.frameworkBeginningStartLevel);
                    this.notifyStarted();
                }
            }
        }
    }

    public boolean isStarted() {
        return this.frameworkStartLevelReached && this.fileInstallStarted;
    }

    private void restoreSystemProperties(Map<String, String> systemPropertiesToRestore) {
        if (systemPropertiesToRestore == null || systemPropertiesToRestore.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> prop : systemPropertiesToRestore.entrySet()) {
            logger.info("Restoring system property {}", (Object)prop.getKey());
            System.setProperty(prop.getKey(), prop.getValue());
        }
    }

    private void setupStartupListener() {
        this.frameworkBeginningStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
        this.main.getFramework().getBundleContext().addFrameworkListener((FrameworkListener)this);
        this.startLevelTimer.schedule((TimerTask)new StartLevelChecker(), 1000L, 1000L);
    }

    private void setupSystemProperties() {
        Map unreplaced = (Map)SpringContextSingleton.getBean("osgiProperties");
        TreeMap newSystemProperties = new TreeMap();
        PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}");
        Properties systemProps = System.getProperties();
        for (Map.Entry entry : unreplaced.entrySet()) {
            newSystemProperties.put(entry.getKey(), placeholderHelper.replacePlaceholders((String)entry.getValue(), systemProps));
        }
        for (Map.Entry property : newSystemProperties.entrySet()) {
            String propertyName = (String)property.getKey();
            String oldPropertyValue = System.getProperty(propertyName);
            if (oldPropertyValue != null) {
                logger.warn("Overriding system property " + propertyName + "=" + oldPropertyValue + " with new value=" + (String)property.getValue());
            }
            JahiaContextLoaderListener.setSystemProperty(propertyName, (String)property.getValue());
        }
        File file = new File(System.getProperty("karaf.etc"), "config.properties");
        org.apache.felix.utils.properties.Properties karafConfigProperties = null;
        try {
            karafConfigProperties = PropertiesLoader.loadConfigProperties((File)file);
        }
        catch (Exception e) {
            logger.error("Unable to load properties from file " + file + ". Cause: " + e.getMessage(), (Throwable)e);
            karafConfigProperties = new org.apache.felix.utils.properties.Properties();
        }
        StringBuilder extraSystemPackages = new StringBuilder(karafConfigProperties.getProperty("org.osgi.framework.system.packages.extra"));
        boolean modifiedExtraSystemPackages = false;
        for (Map.Entry entry : newSystemProperties.entrySet()) {
            if (!((String)entry.getKey()).startsWith("org.osgi.framework.system.packages.extra.")) continue;
            extraSystemPackages.append(',').append((String)entry.getValue());
            modifiedExtraSystemPackages = true;
        }
        if (modifiedExtraSystemPackages) {
            JahiaContextLoaderListener.setSystemProperty("org.osgi.framework.system.packages.extra", extraSystemPackages.toString());
        }
    }

    public void start() {
        try {
            this.updateFileReferencesIfNeeded();
        }
        catch (Exception e) {
            logger.error("Error updating file references", (Throwable)e);
        }
        this.startTime = System.currentTimeMillis();
        logger.info("Starting OSGi platform service");
        this.startKaraf();
        this.servletContext.setAttribute(BundleContext.class.getName(), (Object)this.main.getFramework().getBundleContext());
    }

    private void startKaraf() {
        Map<String, String> filteredOutSystemProperties = this.filterOutSystemProperties();
        try {
            this.setupSystemProperties();
            this.bundleStarter = new BundleStarter();
            this.main = new Main(new String[0]);
            this.main.launch();
            this.setupStartupListener();
            this.bundleStarter.startInitialBundlesIfNeeded();
        }
        catch (Exception e) {
            this.main = null;
            logger.error("Error starting OSGi container", (Throwable)e);
            throw new JahiaRuntimeException("Error starting OSGi container", e);
        }
        finally {
            this.restoreSystemProperties(filteredOutSystemProperties);
        }
    }

    public void stop() throws BundleException {
        if (this.main != null) {
            this.destroyTimer();
            this.servletContext.removeAttribute(BundleContext.class.getName());
            try {
                this.main.destroy();
            }
            catch (Exception e) {
                logger.error("Error shutting down Karaf framework", (Throwable)e);
            }
        }
        logger.info("OSGi framework stopped");
    }

    protected void destroyTimer() {
        if (this.startLevelTimer != null) {
            try {
                this.startLevelTimer.cancel();
            }
            catch (Exception e) {
                logger.warn("Error terminating timer thread", (Throwable)e);
            }
            finally {
                this.startLevelTimer = null;
            }
        }
    }

    private void updateFileReferencesIfNeeded() {
        ScriptEngine scriptEngine;
        File script = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/scripts/groovy/updateFileReferences.groovy");
        if (!script.isFile()) {
            return;
        }
        try {
            scriptEngine = ScriptEngineUtils.getInstance().scriptEngine(FilenameUtils.getExtension((String)script.getName()));
        }
        catch (ScriptException e) {
            throw new JahiaRuntimeException(e);
        }
        if (scriptEngine == null) {
            throw new IllegalStateException("No script engine available");
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("log", (Object)logger);
        bindings.put("logger", (Object)logger);
        scriptContext.setBindings(bindings, 100);
        try (FileInputStream scriptInputStream = new FileInputStream(script);
             InputStreamReader scriptReader = new InputStreamReader((InputStream)scriptInputStream, Charsets.UTF_8);
             StringWriter out = new StringWriter();){
            scriptContext.setWriter(out);
            scriptEngine.eval((Reader)scriptReader, (ScriptContext)scriptContext);
        }
        catch (IOException | ScriptException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private class StartLevelChecker
    extends TimerTask {
        private StartLevelChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FrameworkService frameworkService = FrameworkService.this;
            synchronized (frameworkService) {
                if (FrameworkService.this.frameworkStartLevelReached) {
                    this.cancel();
                } else if (BundleLifecycleUtils.getFrameworkStartLevel() >= FrameworkService.this.frameworkBeginningStartLevel) {
                    FrameworkService.this.frameworkStartLevelReached = true;
                    logger.info("Framework start level reached " + FrameworkService.this.frameworkBeginningStartLevel);
                    FrameworkService.this.notifyStarted();
                    this.cancel();
                }
            }
        }

        @Override
        public boolean cancel() {
            logger.info("Cancelling the start level checker task");
            boolean result = super.cancel();
            FrameworkService.this.destroyTimer();
            return result;
        }
    }

    private static class Holder {
        static final FrameworkService INSTANCE = new FrameworkService(JahiaContextLoaderListener.getServletContext());

        private Holder() {
        }
    }
}

