/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogBridge {
    public static void log(String loggerName, int level, Object message, Throwable t) {
        String msg;
        if (level == Integer.MAX_VALUE) {
            return;
        }
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        String string = msg = message != null ? message.toString() : null;
        if (level >= 40000) {
            logger.error(msg, t);
        } else if (level >= 30000) {
            logger.warn(msg, t);
        } else if (level >= 20000) {
            logger.info(msg, t);
        } else if (level >= 10000) {
            logger.debug(msg, t);
        } else {
            logger.trace(msg, t);
        }
    }

    public static void putMDC(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public static String getMDC(String key) {
        return MDC.get((String)key);
    }

    public static void removeMDC(String key) {
        MDC.remove((String)key);
    }

    public static void clearMDC() {
        MDC.clear();
    }

    public static Map getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map contextMap) {
        MDC.setContextMap((Map)contextMap);
    }
}

