/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.impl.GenericPipeline;
import org.jahia.pipelines.valves.Valve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AutoRegisteredBaseAuthValve
extends BaseAuthValve
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoRegisteredBaseAuthValve.class);
    private GenericPipeline authPipeline;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    public void afterPropertiesSet() {
        this.initialize();
        this.removeValve(this.getId());
        int index = -1;
        if (this.position >= 0) {
            index = this.position;
        } else if (this.positionBefore != null) {
            index = this.indexOf(this.positionBefore);
        } else if (this.positionAfter != null) {
            index = this.indexOf(this.positionAfter);
            if (index != -1) {
                ++index;
            }
            if (index >= this.authPipeline.getValves().length) {
                index = -1;
            }
        }
        if (index != -1) {
            this.authPipeline.addValve(index, this);
            logger.info("Registered authentication valve {} at position {}", (Object)this.getId(), (Object)index);
        } else {
            this.authPipeline.addValve(this);
            logger.info("Registered authentication valve {}", (Object)this.getId());
        }
    }

    public void destroy() throws Exception {
        if (JahiaContextLoaderListener.isRunning()) {
            this.removeValve(this.getId());
            logger.info("Unregistered authentication valve {}", (Object)this.getId());
        }
    }

    private int indexOf(String id) {
        Valve[] registeredValves = this.authPipeline.getValves();
        for (int i = 0; i < registeredValves.length; ++i) {
            Valve v = registeredValves[i];
            if (!(v instanceof BaseAuthValve) || !StringUtils.equals((String)((BaseAuthValve)v).getId(), (String)id)) continue;
            return i;
        }
        return -1;
    }

    private void removeValve(String id) {
        Valve[] registeredValves;
        for (Valve v : registeredValves = this.authPipeline.getValves()) {
            if (!(v instanceof BaseAuthValve) || !StringUtils.equals((String)((BaseAuthValve)v).getId(), (String)id)) continue;
            this.authPipeline.removeValve(v);
        }
    }

    public void setAuthPipeline(GenericPipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }
}

