/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthValveImpl
extends BaseAuthValve {
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthValveImpl.class);
    private JahiaUserManagerService userManagerService;

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        block10: {
            if (!this.isEnabled()) {
                valveContext.invokeNext(context);
                return;
            }
            AuthValveContext authContext = (AuthValveContext)context;
            HttpServletRequest request = authContext.getRequest();
            String auth = request.getHeader("Authorization");
            if (auth != null && auth.startsWith("Basic ")) {
                try {
                    int colonInd;
                    Base64 decoder;
                    String cred;
                    String user;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Header found : " + auth);
                    }
                    if ((user = (cred = new String((decoder = new Base64()).decode((auth = auth.substring(6).trim()).getBytes("UTF-8")))).substring(0, colonInd = cred.indexOf(58))) == null || user.contains(" impersonator ")) break block10;
                    String pass = cred.substring(colonInd + 1);
                    JCRUserNode jcrUserNode = this.userManagerService.lookupUser(user);
                    if (jcrUserNode != null) {
                        if (jcrUserNode.verifyPassword(pass)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("User " + user + " authenticated.");
                            }
                            if (jcrUserNode.isAccountLocked()) {
                                logger.debug("Login failed. Account is locked for user " + user);
                                return;
                            }
                            authContext.getSessionFactory().setCurrentUser(jcrUserNode.getJahiaUser());
                            return;
                        }
                        logger.debug("User found but password verification failed for user : " + user);
                        break block10;
                    }
                    logger.debug("User not found : " + user);
                }
                catch (Exception e) {
                    logger.debug("Exception thrown", (Throwable)e);
                }
            } else {
                logger.debug("No authorization header found");
            }
        }
        valveContext.invokeNext(context);
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

