/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.pluto.container.PortletWindow;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPortletUtil {
    public static final String JAHIA_SHARED_MAP = "jahiaSharedMap";
    private static Logger logger = LoggerFactory.getLogger(JahiaPortletUtil.class);
    public static final String PLUTO_PREFIX = "__";
    public static final String PLUTO_ACTION = "ac";
    public static final String PLUTO_RESOURCE = "rs";

    public static String removePlutoPart(String pathInfo) {
        if (JahiaPortletUtil.isPortletRequest(pathInfo)) {
            return pathInfo.substring(0, pathInfo.indexOf("/__", 1));
        }
        return pathInfo;
    }

    public static boolean isPortletRequest(String pathInfo) {
        if (pathInfo != null) {
            StringTokenizer st = new StringTokenizer(pathInfo, "/", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("__rs")) {
                    return true;
                }
                if (!token.startsWith("__ac")) continue;
                return true;
            }
        }
        return false;
    }

    public static void copyJahiaAttributes(EntryPointInstance entryPointInstance, HttpServletRequest httpServletRequest, PortletWindow window, HttpServletRequest portalRequest, boolean canModifySharedMap, String workspaceName) {
        JahiaPortletUtil.copyAttribute("renderContext", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("script", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("scriptInfo", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("currentNode", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("workspace", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("currentResource", httpServletRequest, portalRequest, window);
        JahiaPortletUtil.copyAttribute("url", httpServletRequest, portalRequest, window);
        portalRequest.setAttribute("Pluto_" + window.getId().getStringId() + "_EntryPointInstance", (Object)entryPointInstance);
        if (entryPointInstance != null) {
            JahiaPortletUtil.copyNodeProperties(entryPointInstance, window, portalRequest, workspaceName);
        }
        JahiaPortletUtil.copySharedMapFromJahiaToPortlet(httpServletRequest, portalRequest, window, canModifySharedMap);
    }

    public static void copyAttribute(String attributeName, HttpServletRequest httpServletRequest, HttpServletRequest portalRequest, PortletWindow window) {
        JahiaPortletUtil.copyAttribute(attributeName, httpServletRequest, portalRequest, window, null, false);
    }

    public static void copyAttribute(String attributeName, HttpServletRequest httpServletRequest, HttpServletRequest portalRequest, PortletWindow window, Object defaultValue, boolean fromSession) {
        Object objectToCopy;
        if (fromSession) {
            objectToCopy = httpServletRequest.getSession().getAttribute(attributeName);
            if (objectToCopy == null) {
                objectToCopy = defaultValue;
                httpServletRequest.getSession().setAttribute(attributeName, objectToCopy);
            }
        } else {
            objectToCopy = httpServletRequest.getAttribute(attributeName);
            if (objectToCopy == null) {
                objectToCopy = defaultValue;
                httpServletRequest.setAttribute(attributeName, objectToCopy);
            }
        }
        portalRequest.setAttribute(JahiaPortletUtil.getRealAttributeName(window, attributeName), objectToCopy);
    }

    public static void copyNodeProperties(EntryPointInstance entryPointInstance, PortletWindow window, HttpServletRequest portalRequest, String workspaceName) {
        try {
            PropertyIterator propertyIterator;
            JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentUserSession(workspaceName).getNodeByUUID(entryPointInstance.getID());
            if (node != null && (propertyIterator = node.getProperties()) != null) {
                while (propertyIterator.hasNext()) {
                    Property property = propertyIterator.nextProperty();
                    PropertyDefinition def = property.getDefinition();
                    String propName = def.getName();
                    if (!def.isMultiple()) {
                        portalRequest.setAttribute(JahiaPortletUtil.getRealAttributeName(window, propName), JahiaPortletUtil.convertValue(property.getValue()));
                        continue;
                    }
                    portalRequest.setAttribute(JahiaPortletUtil.getRealAttributeName(window, propName), JahiaPortletUtil.convertValues(property.getValues()));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object convertValues(Value[] val) throws RepositoryException {
        if (val == null) {
            return null;
        }
        Object[] o = new Object[val.length];
        for (int i = 0; i < val.length; ++i) {
            o[i] = JahiaPortletUtil.convertValue(val[i]);
        }
        return o;
    }

    public static Object convertValue(Value val) throws RepositoryException {
        Object theValue;
        if (val == null) {
            return null;
        }
        switch (val.getType()) {
            case 2: {
                theValue = val.getString();
                break;
            }
            case 6: {
                theValue = val.getBoolean();
                break;
            }
            case 5: {
                theValue = val.getDate();
                break;
            }
            case 4: {
                theValue = val.getDouble();
                break;
            }
            case 3: {
                theValue = val.getLong();
                break;
            }
            case 7: {
                theValue = val.getString();
                break;
            }
            case 8: {
                theValue = val.getString();
                break;
            }
            case 9: {
                theValue = val.getString();
                break;
            }
            case 1: {
                theValue = val.getString();
                break;
            }
            case 0: {
                theValue = val.getString();
                break;
            }
            default: {
                theValue = val.getString();
            }
        }
        return theValue;
    }

    public static void copySharedMapFromJahiaToPortlet(HttpServletRequest originalRequest, HttpServletRequest portalRequest, PortletWindow window, boolean canModify) {
        HashMap sharedMap = (HashMap)originalRequest.getSession().getAttribute(JAHIA_SHARED_MAP);
        if (sharedMap == null) {
            sharedMap = new HashMap();
            originalRequest.getSession().setAttribute(JAHIA_SHARED_MAP, sharedMap);
        }
        if (canModify) {
            portalRequest.setAttribute(JahiaPortletUtil.getRealAttributeName(window, JAHIA_SHARED_MAP), sharedMap);
        } else {
            portalRequest.setAttribute(JahiaPortletUtil.getRealAttributeName(window, JAHIA_SHARED_MAP), Collections.unmodifiableMap(sharedMap));
        }
    }

    public static void copySharedMapFromPortletToJahia(HttpSession session, HttpServletRequest portalRequest, PortletWindow window) {
        Map sharedMap = (Map)portalRequest.getAttribute(JahiaPortletUtil.getRealAttributeName(window, JAHIA_SHARED_MAP));
        session.setAttribute(JAHIA_SHARED_MAP, (Object)sharedMap);
    }

    public static String getRealAttributeName(PortletWindow window, String attributeName) {
        return "Pluto_" + window.getId().getStringId() + "_" + attributeName;
    }

    public static Map<String, Object> filterJahiaAttributes(HttpServletRequest portalRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List names = EnumerationUtils.toList((Enumeration)portalRequest.getAttributeNames());
        for (String key : names) {
            if (!JahiaPortletUtil.isSpringAttribute(key)) continue;
            Object value = portalRequest.getAttribute(key);
            map.put(key, value);
            portalRequest.removeAttribute(key);
        }
        return map;
    }

    private static boolean isSpringAttribute(String key) {
        return key != null && key.indexOf("org.springframework") == 0;
    }

    public static void setJahiaAttributes(HttpServletRequest portalRequest, Map<String, Object> jahiaAttributes) {
        Set<String> keys = jahiaAttributes.keySet();
        for (String key : keys) {
            Object value = portalRequest.getAttribute(key);
            portalRequest.setAttribute(key, value);
        }
    }
}

