/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.util.Collection;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.cache.CacheImplementation;
import org.jahia.services.cache.CacheStatistics;
import org.jahia.services.cache.GroupCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache<K, V>
implements CacheStatistics {
    private static final Logger logger = LoggerFactory.getLogger(Cache.class);
    private CacheImplementation<K, CacheEntry<V>> cacheImplementation;
    private String name;

    protected Cache(String name, CacheImplementation<K, CacheEntry<V>> cacheImplementation) {
        this.cacheImplementation = cacheImplementation;
        this.init(name);
    }

    public CacheEntry<V> getCacheEntry(K entryKey) {
        if (entryKey == null) {
            return null;
        }
        CacheEntry<V> entry = this.cacheImplementation.get(entryKey);
        if (entry == null) {
            if (logger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder("Entry [");
                buffer.append(entryKey.toString());
                buffer.append("] could not be found in cache [");
                buffer.append(this.name);
                buffer.append("]!");
                logger.debug(buffer.toString());
            }
            return null;
        }
        return entry;
    }

    public V get(K entryKey) {
        if (entryKey == null) {
            logger.debug("Cannot fetch with an null entry key!!!");
            return null;
        }
        CacheEntry<V> entry = this.getCacheEntry(entryKey);
        if (entry != null) {
            return entry.getObject();
        }
        return null;
    }

    public void put(K entryKey, V entryObj) {
        this.put(entryKey, entryObj, true);
    }

    public void put(K entryKey, V entryObj, boolean propagate) {
        if (entryKey == null) {
            logger.debug("Cannot add an object with an empty key!!");
            return;
        }
        CacheEntry<V> entry = new CacheEntry<V>(entryObj);
        this.putCacheEntry(entryKey, entry, propagate);
    }

    public void putCacheEntry(K entryKey, CacheEntry<V> entry, boolean propagate) {
        this.internalPut(entryKey, entry);
    }

    private boolean internalPut(K entryKey, CacheEntry<V> entry) {
        CacheEntry<V> existingEntry;
        if (entryKey == null || entry == null) {
            logger.debug("null cache entry key or entry object, cannot cache such an object!");
            return false;
        }
        if (logger.isDebugEnabled() && (existingEntry = this.cacheImplementation.get(entryKey)) != null) {
            logger.debug("Updating cache entry " + entryKey + " for cache " + this.getName());
            if (entry.getObject().equals(existingEntry.getObject())) {
                logger.debug("Updating cache " + this.getName() + " entry " + entryKey + " with same object value (" + entry.getObject() + ")!");
            }
        }
        if (entryKey.getClass() == GroupCacheKey.class) {
            GroupCacheKey groupKey = (GroupCacheKey)entryKey;
            this.cacheImplementation.put(entryKey, groupKey.getGroupArray(), entry);
        } else {
            this.cacheImplementation.put(entryKey, null, entry);
        }
        return true;
    }

    private void init(String name) {
        this.name = name;
    }

    public void remove(K entryKey) {
        this.internalRemove(entryKey);
    }

    public final boolean isEmpty() {
        return this.cacheImplementation.isEmpty();
    }

    public final int size() {
        return this.cacheImplementation.size();
    }

    public final long getGroupsSize() {
        return this.cacheImplementation.getGroupsSize();
    }

    public final long getGroupsKeysTotal() {
        return this.cacheImplementation.getGroupsKeysTotal();
    }

    public final String getName() {
        return this.name;
    }

    public final void flush() {
        this.flush(true);
    }

    public void flush(boolean propagate) {
        this.cacheImplementation.flushAll(propagate);
        logger.debug("Flushed all entries from cache [{}]", (Object)this.name);
    }

    public final void flushGroup(String groupName) {
        this.cacheImplementation.flushGroup(groupName);
    }

    @Override
    public final long getSuccessHits() {
        return this.cacheImplementation instanceof CacheStatistics ? ((CacheStatistics)((Object)this.cacheImplementation)).getSuccessHits() : 0L;
    }

    @Override
    public final long getTotalHits() {
        return this.cacheImplementation instanceof CacheStatistics ? ((CacheStatistics)((Object)this.cacheImplementation)).getTotalHits() : 0L;
    }

    @Override
    public double getCacheEfficiency() {
        return this.cacheImplementation instanceof CacheStatistics ? ((CacheStatistics)((Object)this.cacheImplementation)).getCacheEfficiency() : 0.0;
    }

    public final boolean containsKey(K entryKey) {
        if (this.cacheImplementation.containsKey(entryKey)) {
            if (this.getCacheEntry(entryKey) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Entry " + entryKey + " has expired. containsKey will return false.");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public final Collection<K> getKeys() {
        return this.cacheImplementation.getKeys();
    }

    private void internalRemove(K entryKey) {
        if (entryKey == null) {
            return;
        }
        this.cacheImplementation.remove(entryKey);
        if (logger.isDebugEnabled()) {
            logger.debug("Removed the entry [" + entryKey.toString() + "] from cache [" + this.name + "]!");
        }
    }

    public CacheImplementation<K, CacheEntry<V>> getCacheImplementation() {
        return this.cacheImplementation;
    }
}

