/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.cache.ClassLoaderAwareCacheEntry;
import org.jahia.services.cache.ehcache.CacheInfo;
import org.jahia.services.cache.ehcache.CacheManagerInfo;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheHelper {
    public static final String CMD_FLUSH_ALL_CACHES = "FLUSH_ALL_CACHES";
    public static final String CMD_FLUSH_CHILDREN = "FLUSH_CHILDREN";
    @Deprecated
    public static final String CMD_FLUSH_CHILDS = "FLUSH_CHILDS";
    public static final String CMD_FLUSH_MATCHINGPERMISSIONS = "FLUSH_MATCHINGPERMISSIONS";
    public static final String CMD_FLUSH_OUTPUT_CACHES = "FLUSH_OUTPUT_CACHES";
    public static final String CMD_FLUSH_PATH = "FLUSH_PATH";
    public static final String CMD_FLUSH_REGEXP = "FLUSH_REGEXP";
    public static final String CMD_FLUSH_REGEXPDEP = "FLUSH_REGEXPDEP";
    public static final String CMD_FLUSH_URLRESOLVER = "FLUSH_URLRESOLVER";
    public static final String CMD_FLUSH_VANITYURL = "FLUSH_VANITYURL";
    private static final Logger logger = LoggerFactory.getLogger(CacheHelper.class);

    public static void flushAllCaches() {
        CacheHelper.flushAllCaches(false);
    }

    public static void flushAllCaches(boolean propagateInCluster) {
        logger.info("Flushing all caches{}", (Object)(propagateInCluster ? " also propagating it to all cluster members" : ""));
        CacheService cacheService = ServicesRegistry.getInstance().getCacheService();
        for (String curCacheName : cacheService.getNames()) {
            Cache cache = cacheService.getCache(curCacheName);
            if (cache == null) continue;
            cache.flush(propagateInCluster);
        }
        for (CacheManager mgr : CacheManager.ALL_CACHE_MANAGERS) {
            for (String cacheName : mgr.getCacheNames()) {
                Ehcache cache = mgr.getEhcache(cacheName);
                if (cache == null) continue;
                cache.removeAll(!propagateInCluster);
            }
        }
        if (propagateInCluster) {
            CacheHelper.sendCacheFlushCommandToCluster(CMD_FLUSH_ALL_CACHES, false, null, false);
        }
        logger.info("...done flushing all caches.");
    }

    public static void flushCachesForManager(String cacheManagerName, boolean propagateInCluster) {
        logger.info("Flushing caches for the cache manager '{}' {}", (Object)cacheManagerName, (Object)(propagateInCluster ? " also propagating it to all cluster members" : ""));
        CacheManager ehcacheManager = CacheHelper.getCacheManager(cacheManagerName);
        if (ehcacheManager == null) {
            return;
        }
        for (String cacheName : ehcacheManager.getCacheNames()) {
            Ehcache cache = ehcacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            cache.removeAll(!propagateInCluster);
        }
        logger.info("...done flushing caches for manager {}", (Object)cacheManagerName);
    }

    public static void flushEhcacheByName(String cacheName) {
        CacheHelper.flushEhcacheByName(cacheName, false);
    }

    public static void flushEhcacheByName(String cacheName, boolean propagateInCluster) {
        logger.info("Flushing {}", (Object)cacheName);
        Ehcache cache = CacheHelper.getEhcache(cacheName);
        if (cache != null) {
            cache.removeAll(!propagateInCluster);
            logger.info("...done flushing {}", (Object)cacheName);
        } else {
            logger.warn("Cache with the name {} not found. Skip flushing.", (Object)cacheName);
        }
    }

    private static Ehcache getEhcache(String cacheName) {
        Ehcache ehcache = CacheHelper.getJahiaCacheManager().getEhcache(cacheName);
        return ehcache == null ? CacheHelper.getBigCacheManager().getEhcache(cacheName) : ehcache;
    }

    public static void flushOutputCaches() {
        CacheHelper.flushOutputCaches(false);
    }

    public static void flushOutputCaches(boolean propagateInCluster) {
        logger.info("Flushing HTML output caches{}", (Object)(propagateInCluster ? " also propagating it to all cluster members" : ""));
        CacheHelper.flushOutputCachesInManager(propagateInCluster, CacheHelper.getJahiaCacheManager());
        CacheHelper.flushOutputCachesInManager(propagateInCluster, CacheHelper.getBigCacheManager());
        if (propagateInCluster) {
            CacheHelper.flushOutputCachesCluster();
        }
    }

    private static void flushOutputCachesInManager(boolean propagateInCluster, CacheManager ehcacheManager) {
        for (String cacheName : ehcacheManager.getCacheNames()) {
            Ehcache cache;
            if (!cacheName.startsWith("HTML") || (cache = ehcacheManager.getEhcache(cacheName)) == null) continue;
            cache.removeAll(!propagateInCluster);
            logger.info("...done flushing {}", (Object)cacheName);
        }
    }

    private static void flushOutputCachesCluster() {
        CacheHelper.sendCacheFlushCommandToCluster(CMD_FLUSH_OUTPUT_CACHES, false, null, false);
    }

    public static void flushOutputCachesForPath(String path, boolean flushSubtree) {
        CacheHelper.flushOutputCachesForPaths(Sets.newHashSet((Object[])new String[]{path}), flushSubtree);
    }

    public static void flushOutputCachesForPaths(Set<String> paths, boolean flushSubtree) {
        logger.debug("Flushing dependencies for paths: {}", paths);
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        net.sf.ehcache.Cache cache = cacheProvider.getDependenciesCache();
        HashSet<Object> cacheKeys = new HashSet<Object>();
        for (String path : paths) {
            Element element = cache.get((Serializable)((Object)path));
            if (element == null) continue;
            logger.debug("Flushing path: {}", (Object)path);
            cacheKeys.add(element.getObjectKey());
        }
        if (flushSubtree) {
            HashSet<String> pathsWithSubTree = new HashSet<String>(paths);
            List keys = cache.getKeys();
            for (Object key : keys) {
                String stringKey = key.toString();
                if (!CacheHelper.isKeyMatched(stringKey, paths)) continue;
                pathsWithSubTree.add(stringKey);
                cacheKeys.add(key);
            }
            paths = pathsWithSubTree;
        }
        cacheProvider.invalidate(paths, true);
        cache.removeAll(cacheKeys);
    }

    private static boolean isKeyMatched(String stringKey, Set<String> paths) {
        for (String path : paths) {
            if (!stringKey.equals(path) && !stringKey.startsWith(path + '/')) continue;
            return true;
        }
        return false;
    }

    private static CacheInfo getCacheInfo(Ehcache cache, boolean withConfig, boolean withSizeInBytes) {
        CacheInfo info = new CacheInfo(cache);
        info.setName(cache.getName());
        if (withConfig) {
            info.setConfig(cache.getCacheManager().getActiveConfigurationText(info.getName()));
        }
        StatisticsGateway stats = cache.getStatistics();
        info.setHitCount(stats.cacheHitCount());
        info.setMissCount(stats.cacheMissCount());
        info.setHitRatio(info.getAccessCount() > 0L ? (double)(info.getHitCount() * 100L) / (double)info.getAccessCount() : 0.0);
        info.setSize(stats.getSize());
        info.setLocalHeapSize(stats.getLocalHeapSize());
        info.setOverflowToDisk(cache.getCacheConfiguration().isOverflowToDisk());
        if (info.isOverflowToDisk()) {
            info.setLocalDiskSize(stats.getLocalDiskSize());
        }
        info.setOverflowToOffHeap(cache.getCacheConfiguration().isOverflowToOffHeap());
        if (info.isOverflowToOffHeap()) {
            info.setLocalOffHeapSize(stats.getLocalOffHeapSize());
        }
        if (withSizeInBytes) {
            info.setLocalHeapSizeInBytes(stats.getLocalHeapSizeInBytes());
            info.setLocalHeapSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalHeapSizeInBytes()));
            if (info.isOverflowToDisk()) {
                info.setLocalDiskSizeInBytes(stats.getLocalDiskSizeInBytes());
                info.setLocalDiskSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalDiskSizeInBytes()));
            }
            if (info.isOverflowToOffHeap()) {
                info.setLocalOffHeapSizeInBytes(stats.getLocalOffHeapSizeInBytes());
                info.setLocalOffHeapSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalOffHeapSizeInBytes()));
            }
        }
        return info;
    }

    public static CacheManager getCacheManager(String cacheManagerName) {
        for (CacheManager mgr : CacheManager.ALL_CACHE_MANAGERS) {
            if (!cacheManagerName.equals(mgr.getName())) continue;
            return mgr;
        }
        return null;
    }

    private static CacheManagerInfo getCacheManagerInfo(CacheManager manager, boolean withConfig, boolean withSizeInBytes) {
        CacheManagerInfo info = new CacheManagerInfo(manager);
        info.setName(manager.getName());
        if (withConfig) {
            info.setConfig(manager.getActiveConfigurationText());
        }
        for (String name : manager.getCacheNames()) {
            Ehcache cache = manager.getEhcache(name);
            if (cache == null) continue;
            CacheInfo cacheInfo = CacheHelper.getCacheInfo(cache, withConfig, withSizeInBytes);
            info.getCaches().put(name, cacheInfo);
            info.setHitCount(info.getHitCount() + cacheInfo.getHitCount());
            info.setMissCount(info.getMissCount() + cacheInfo.getMissCount());
            info.setOverflowToDisk(info.isOverflowToDisk() || cacheInfo.isOverflowToDisk());
            info.setOverflowToOffHeap(info.isOverflowToOffHeap() || cacheInfo.isOverflowToOffHeap());
            info.setSize(info.getSize() + cacheInfo.getSize());
            info.setLocalHeapSize(info.getLocalHeapSize() + cacheInfo.getLocalHeapSize());
            if (info.isOverflowToDisk()) {
                info.setLocalDiskSize(info.getLocalDiskSize() + cacheInfo.getLocalDiskSize());
            }
            if (info.isOverflowToOffHeap()) {
                info.setLocalOffHeapSize(info.getLocalOffHeapSize() + cacheInfo.getLocalOffHeapSize());
            }
            if (!withSizeInBytes) continue;
            info.setLocalDiskSizeInBytes(info.getLocalDiskSizeInBytes() + cacheInfo.getLocalDiskSizeInBytes());
            info.setLocalHeapSizeInBytes(info.getLocalHeapSizeInBytes() + cacheInfo.getLocalHeapSizeInBytes());
            info.setLocalOffHeapSizeInBytes(info.getLocalOffHeapSizeInBytes() + cacheInfo.getLocalOffHeapSizeInBytes());
        }
        if (withSizeInBytes) {
            info.setLocalDiskSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalDiskSizeInBytes()));
            info.setLocalHeapSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalHeapSizeInBytes()));
            if (info.isOverflowToOffHeap()) {
                info.setLocalOffHeapSizeInBytesHumanReadable(FileUtils.humanReadableByteCount(info.getLocalOffHeapSizeInBytes()));
            }
        }
        return info;
    }

    public static Map<String, CacheManagerInfo> getCacheManagerInfos(boolean withConfig, boolean withSizeInBytes) {
        TreeMap<String, CacheManagerInfo> infos = new TreeMap<String, CacheManagerInfo>();
        for (CacheManager manager : CacheManager.ALL_CACHE_MANAGERS) {
            infos.put(manager.getName(), CacheHelper.getCacheManagerInfo(manager, withConfig, withSizeInBytes));
        }
        return infos;
    }

    private static CacheManager getJahiaCacheManager() {
        return ((EhCacheProvider)SpringContextSingleton.getBean("ehCacheProvider")).getCacheManager();
    }

    private static CacheManager getBigCacheManager() {
        return ((EhCacheProvider)SpringContextSingleton.getBean("bigEhCacheProvider")).getCacheManager();
    }

    public static Object getObjectValue(Ehcache cache, String key) {
        return CacheHelper.getObjectValue(cache.get((Serializable)((Object)key)));
    }

    public static Object getObjectValue(Element cacheElement) {
        Object value = null;
        if (cacheElement != null && (value = cacheElement.getObjectValue()) != null && value instanceof ClassLoaderAwareCacheEntry) {
            value = ((ClassLoaderAwareCacheEntry)value).getValue();
        }
        return value;
    }

    public static void registerMBeans(String cacheManagerName) {
        CacheManager mgr = CacheHelper.getCacheManager(cacheManagerName);
        if (mgr == null) {
            logger.warn("Cannot find Ehcache manager for name {}. Skip registering managed beans in JMX", (Object)cacheManagerName);
            return;
        }
        ManagementService.registerMBeans((CacheManager)mgr, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private static long getClusterRevision() {
        return SpringJackrabbitRepository.getInstance().getClusterRevision();
    }

    private static net.sf.ehcache.Cache getSyncCache() {
        try {
            return ModuleCacheProvider.getInstance().getSyncCache();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sendCacheFlushCommandToCluster(String command) {
        CacheHelper.sendCacheFlushCommandToCluster(command, null);
    }

    public static void sendCacheFlushCommandToCluster(String command, String eventMessage) {
        CacheHelper.sendCacheFlushCommandToCluster(command, true, eventMessage, true);
    }

    private static void sendCacheFlushCommandToCluster(String command, boolean appendRandomSufixToCommand, String eventMessage, boolean executeConsideringCurrentClusterRevision) {
        net.sf.ehcache.Cache syncCache = CacheHelper.getSyncCache();
        if (syncCache != null) {
            long clusterRevision = CacheHelper.getClusterCacheFlushCommandRevision(executeConsideringCurrentClusterRevision);
            Element element = CacheHelper.newClusterCacheFlushCommandElement(command, appendRandomSufixToCommand, eventMessage, clusterRevision);
            CacheHelper.logClusterCacheFlushCommandSending(element);
            syncCache.put(element);
        }
    }

    private static Element newClusterCacheFlushCommandElement(String command, boolean appendRandomSufixToCommand, String eventMessage, long clusterRevision) {
        String commandString = appendRandomSufixToCommand ? command + '-' + UUID.randomUUID() : command;
        CacheClusterEvent cacheEvent = new CacheClusterEvent(eventMessage, clusterRevision);
        return new Element((Serializable)((Object)commandString), (Serializable)cacheEvent);
    }

    private static long getClusterCacheFlushCommandRevision(boolean executeConsideringCurrentClusterRevision) {
        return executeConsideringCurrentClusterRevision ? CacheHelper.getClusterRevision() : Long.MIN_VALUE;
    }

    private static void logClusterCacheFlushCommandSending(Element element) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        CacheClusterEvent cacheEvent = (CacheClusterEvent)element.getObjectValue();
        logger.debug("Sending cache flush command {} to cluster with messsage {} and cluster revision {}", new Object[]{element.getObjectKey(), cacheEvent.getEvent(), cacheEvent.getClusterRevision()});
    }

    public static void sendMultipleCacheFlushCommandsToCluster(String command, Collection<String> eventMessages) {
        CacheHelper.sendMultipleCacheFlushCommandsToCluster(command, true, eventMessages, true);
    }

    private static void sendMultipleCacheFlushCommandsToCluster(String command, boolean appendRandomSufixToCommand, Collection<String> eventMessages, boolean executeConsideringCurrentClusterRevision) {
        net.sf.ehcache.Cache syncCache = CacheHelper.getSyncCache();
        if (syncCache != null && eventMessages != null && !eventMessages.isEmpty()) {
            ArrayList<Element> cacheElements = new ArrayList<Element>(eventMessages.size());
            long clusterRevision = CacheHelper.getClusterCacheFlushCommandRevision(executeConsideringCurrentClusterRevision);
            for (String msg : eventMessages) {
                Element element = CacheHelper.newClusterCacheFlushCommandElement(command, appendRandomSufixToCommand, msg, clusterRevision);
                CacheHelper.logClusterCacheFlushCommandSending(element);
                cacheElements.add(element);
            }
            syncCache.putAll(cacheElements);
        }
    }
}

