/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.DynamicValueImpl;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueListener
extends DefaultEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValueListener.class);

    @Override
    public int getEventTypes() {
        return 21;
    }

    public void onEvent(final EventIterator eventIterator) {
        try {
            JCRSessionWrapper eventSession = ((JCREventIterator)eventIterator).getSession();
            final Locale sessionLocale = eventSession.getLocale();
            JahiaUser user = eventSession.getUser();
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, this.workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    HashSet<Session> sessions = null;
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        if (DefaultValueListener.this.isExternal(event)) continue;
                        try {
                            JCRNodeWrapper node;
                            block10: {
                                node = null;
                                String eventPath = event.getPath();
                                try {
                                    if (event.getType() == 1) {
                                        node = (JCRNodeWrapper)session.getItem(eventPath);
                                    }
                                    if (!eventPath.endsWith("jcr:mixinTypes")) break block10;
                                    String path = eventPath.substring(0, eventPath.lastIndexOf(47));
                                    node = (JCRNodeWrapper)session.getItem(path.length() == 0 ? "/" : path);
                                }
                                catch (PathNotFoundException e) {
                                    continue;
                                }
                            }
                            if (node == null || !DefaultValueListener.this.handleNode(node, sessionLocale)) continue;
                            node.getRealNode().getSession().save();
                            if (sessions == null) {
                                sessions = new HashSet<Session>();
                            }
                            sessions.add(node.getRealNode().getSession());
                        }
                        catch (NoSuchNodeTypeException node) {
                        }
                        catch (Exception e) {
                            logger.error("Error when executing event", (Throwable)e);
                        }
                    }
                    if (sessions != null && !sessions.isEmpty()) {
                        for (Session jcrsession : sessions) {
                            jcrsession.save();
                        }
                    }
                    return null;
                }
            });
        }
        catch (NoSuchNodeTypeException eventSession) {
        }
        catch (Exception e) {
            logger.error("Error when executing event", (Throwable)e);
        }
    }

    private boolean handleNode(JCRNodeWrapper node, Locale sessionLocale) throws RepositoryException {
        boolean anythingChanged = false;
        ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
        ExtendedNodeType primaryNodeType = node.getPrimaryNodeType();
        nodeTypes.add(primaryNodeType);
        ExtendedNodeType[] mixin = node.getMixinNodeTypes();
        nodeTypes.addAll(Arrays.asList(mixin));
        for (NodeType nodeType : nodeTypes) {
            ExtendedNodeDefinition[] childNodeDefinitions;
            ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(nodeType.getName());
            if (extendedNodeType == null) continue;
            ExtendedPropertyDefinition[] propertyDefinitions = extendedNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefinitions.length; ++i) {
                ExtendedPropertyDefinition propertyDefinition = propertyDefinitions[i];
                Value[] defValues = propertyDefinition.getDefaultValuesAsUnexpandedValue();
                if (defValues.length <= 0) continue;
                boolean handled = this.handlePropertyDefaultValues(node, propertyDefinition, defValues, sessionLocale);
                anythingChanged = anythingChanged || handled;
            }
            for (ExtendedNodeDefinition definition : childNodeDefinitions = extendedNodeType.getChildNodeDefinitions()) {
                if (!definition.isAutoCreated() || node.hasNode(definition.getName())) continue;
                JCRNodeWrapper autoCreated = node.addNode(definition.getName(), definition.getDefaultPrimaryTypeName());
                if (autoCreated.isNodeType("jmix:originWS")) {
                    autoCreated.setProperty("j:originWS", this.workspace);
                }
                this.handleNode(autoCreated, sessionLocale);
                anythingChanged = true;
            }
        }
        return anythingChanged;
    }

    protected boolean handlePropertyDefaultValues(JCRNodeWrapper n, ExtendedPropertyDefinition pd, Value[] values, Locale sessionLocale) throws RepositoryException {
        String propertyName;
        boolean doCreateI18n;
        boolean bl = doCreateI18n = sessionLocale != null && pd.isInternationalized();
        if (!pd.isAutoCreated() || !doCreateI18n && !pd.hasDynamicDefaultValues()) {
            return false;
        }
        JCRNodeWrapper targetNode = doCreateI18n ? n.getOrCreateI18N(sessionLocale) : n;
        if (targetNode.hasProperty(propertyName = pd.getName()) && !"__I15D_DEFAULT_VALUE__".equals(targetNode.getProperty(propertyName).getString())) {
            return false;
        }
        boolean valuesSet = false;
        Value[] expandedValues = this.expandValues(values, sessionLocale);
        if (expandedValues.length > 0) {
            if (pd.isMultiple()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting default values for property [{}].[{}]: {}", (Object[])new String[]{pd.getDeclaringNodeType().getName(), propertyName, this.asString(expandedValues)});
                }
                targetNode.setProperty(propertyName, expandedValues);
            } else if (expandedValues.length == 1) {
                targetNode.setProperty(propertyName, expandedValues[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting default value for property [{}].[{}]: {}", (Object[])new String[]{pd.getDeclaringNodeType().getName(), propertyName, expandedValues[0].getString()});
                }
            } else {
                throw new ValueFormatException("Property [" + pd.getDeclaringNodeType().getName() + "].[" + propertyName + "] cannot accept multiple values");
            }
            valuesSet = true;
        }
        return valuesSet;
    }

    private String asString(Value[] expandedValues) throws ValueFormatException, IllegalStateException, RepositoryException {
        LinkedList<String> values = new LinkedList<String>();
        for (Value v : expandedValues) {
            values.add(v.getString());
        }
        return StringUtils.join(values, (String)", ");
    }

    private Value[] expandValues(Value[] values, Locale sessionLocale) {
        LinkedList<Value> expanded = new LinkedList<Value>();
        for (Value v : values) {
            if (v instanceof DynamicValueImpl) {
                Value[] expandedValues = ((DynamicValueImpl)v).expand(sessionLocale);
                if (expandedValues == null || expandedValues.length <= 0) continue;
                for (Value ev : expandedValues) {
                    expanded.add(ev);
                }
                continue;
            }
            expanded.add(v);
        }
        return expanded.toArray(new Value[0]);
    }
}

