/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.value.AbstractValueFactory;

public class JCRValueFactoryImpl
extends AbstractValueFactory {
    private static final ValueFactory valueFactory = new JCRValueFactoryImpl();

    protected JCRValueFactoryImpl() {
    }

    public static ValueFactory getInstance() {
        return valueFactory;
    }

    protected void checkPathFormat(String pathValue) throws ValueFormatException {
    }

    protected void checkNameFormat(String nameValue) throws ValueFormatException {
    }

    public Value createValue(Node value) throws RepositoryException {
        Value valueToBeWrapped = super.createValue(value, !value.isNodeType("nt:version"));
        return new EqualsFriendlierValue(valueToBeWrapped);
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        Value valueToBeWrapped = super.createValue(value, type != 9 ? type : 10);
        return new EqualsFriendlierValue(valueToBeWrapped);
    }

    private static class EqualsFriendlierValue
    implements Value {
        private final Value value;

        private EqualsFriendlierValue(Value value) {
            this.value = value;
        }

        public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
            return this.value.getString();
        }

        public InputStream getStream() throws RepositoryException {
            return this.value.getStream();
        }

        public Binary getBinary() throws RepositoryException {
            return this.value.getBinary();
        }

        public long getLong() throws ValueFormatException, RepositoryException {
            return this.value.getLong();
        }

        public double getDouble() throws ValueFormatException, RepositoryException {
            return this.value.getDouble();
        }

        public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
            return this.value.getDecimal();
        }

        public Calendar getDate() throws ValueFormatException, RepositoryException {
            return this.value.getDate();
        }

        public boolean getBoolean() throws ValueFormatException, RepositoryException {
            return this.value.getBoolean();
        }

        public int getType() {
            return this.value.getType();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Value) {
                Value val = (Value)obj;
                int type = this.value.getType();
                if (type != val.getType()) {
                    return false;
                }
                try {
                    switch (type) {
                        case 6: {
                            return this.value.getBoolean() == val.getBoolean();
                        }
                        case 5: {
                            return this.value.getDate().equals(val.getDate());
                        }
                        case 4: {
                            Double doubleValue = this.value.getDouble();
                            return doubleValue.equals(val.getDouble());
                        }
                        case 3: {
                            return this.value.getLong() == val.getLong();
                        }
                    }
                    return this.value.getString().equals(val.getString());
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        public int hashCode() {
            try {
                return this.value != null ? this.value.getString().hashCode() : 0;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

