/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Map;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIteratorImpl
implements PropertyIterator {
    private static Logger logger = LoggerFactory.getLogger(PropertyIteratorImpl.class);
    private PropertyIterator iterator;
    private JCRSessionWrapper session;
    private JCRStoreProvider jcrStoreProvider;

    public PropertyIteratorImpl(PropertyIterator iterator, JCRSessionWrapper session, JCRStoreProvider jcrStoreProvider) {
        this.iterator = iterator;
        this.session = session;
        this.jcrStoreProvider = jcrStoreProvider;
    }

    public Property nextProperty() {
        try {
            Property next = (Property)this.iterator.next();
            if (this.jcrStoreProvider.getMountPoint().equals("/")) {
                for (Map.Entry<String, JCRStoreProvider> entry : JCRSessionFactory.getInstance().getMountPoints().entrySet()) {
                    if (!next.getPath().startsWith(entry.getKey() + '/')) continue;
                    return entry.getValue().getPropertyWrapper(next, this.session);
                }
            }
            return this.jcrStoreProvider.getPropertyWrapper(next, this.session);
        }
        catch (RepositoryException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public void skip(long skipNum) {
        this.iterator.skip(skipNum);
    }

    public long getSize() {
        return this.iterator.getSize();
    }

    public long getPosition() {
        return this.iterator.getPosition();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.nextProperty();
    }

    public void remove() {
        this.iterator.remove();
    }
}

