/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGCListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(UGCListener.class);
    private Set<String> excludePropertiesFromUGCCheck;

    @Override
    public int getEventTypes() {
        return 28;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEvent(EventIterator events) {
        JCRSessionWrapper eventSession = ((JCREventIterator)events).getSession();
        JahiaUser user = eventSession.getUser();
        final HashMap propertiesByNode = new HashMap();
        try {
            block2: while (true) {
                JCRNodeWrapper node;
                if (!events.hasNext()) {
                    if (propertiesByNode.isEmpty()) return;
                    JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, this.workspace, null, new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                            HashSet<Session> sessions = new HashSet<Session>();
                            for (Map.Entry entry : propertiesByNode.entrySet()) {
                                JCRNodeWrapper node = s.getNodeByIdentifier((String)entry.getKey());
                                if (!node.isNodeType("jmix:liveProperties")) {
                                    node.addMixin("jmix:liveProperties");
                                }
                                JCRPropertyWrapper property = node.hasProperty("j:liveProperties") ? node.getProperty("j:liveProperties") : node.setProperty("j:liveProperties", new Value[0]);
                                for (JCRValueWrapper valueWrapper : property.getValues()) {
                                    ((Set)entry.getValue()).remove(valueWrapper.getString());
                                }
                                for (String value : (Set)entry.getValue()) {
                                    property.addValue(value);
                                }
                                sessions.add(node.getRealNode().getSession());
                            }
                            for (Session session : sessions) {
                                if (!session.hasPendingChanges()) continue;
                                session.save();
                            }
                            return null;
                        }
                    });
                    return;
                }
                Event event = events.nextEvent();
                String nodePath = StringUtils.substringBeforeLast((String)event.getPath(), (String)"/");
                String propertyName = StringUtils.substringAfterLast((String)event.getPath(), (String)"/");
                if (CollectionUtils.isNotEmpty(this.excludePropertiesFromUGCCheck) && this.excludePropertiesFromUGCCheck.contains(propertyName) || !(node = eventSession.getNode(nodePath)).hasProperty("j:originWS") || !node.getProperty("j:originWS").getString().equals("default")) continue;
                if (!propertiesByNode.containsKey(node.getIdentifier())) {
                    propertiesByNode.put(node.getIdentifier(), new HashSet());
                }
                if (propertyName.equals("jcr:mixinTypes")) {
                    if (node instanceof JCRNodeDecorator) {
                        node = ((JCRNodeDecorator)node).getDecoratedNode();
                    }
                    if (!(node instanceof JCRNodeWrapperImpl)) continue;
                    ArrayList<ExtendedNodeType> newMixins = new ArrayList<ExtendedNodeType>(Arrays.asList(node.getMixinNodeTypes()));
                    newMixins.removeAll(Arrays.asList(((JCRNodeWrapperImpl)node).getOriginalMixinNodeTypes()));
                    Iterator iterator = newMixins.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        ExtendedNodeType newMixin = (ExtendedNodeType)iterator.next();
                        ((Set)propertiesByNode.get(node.getIdentifier())).add(propertyName + "=" + newMixin.getName());
                    }
                }
                ((Set)propertiesByNode.get(node.getIdentifier())).add(propertyName);
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot store live properties changes", (Throwable)e);
        }
    }

    public Set<String> getExcludePropertiesFromUGCCheck() {
        return this.excludePropertiesFromUGCCheck;
    }

    public void setExcludePropertiesFromUGCCheck(String excludePropertiesFromUGCCheck) {
        if (StringUtils.isNotEmpty((String)excludePropertiesFromUGCCheck)) {
            this.excludePropertiesFromUGCCheck = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)excludePropertiesFromUGCCheck));
        }
    }
}

