/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.jahia.services.content.JCRNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFileContent {
    private static final Detector DETECTOR = new DefaultDetector(MimeTypes.getDefaultMimeTypes());
    protected static final Logger LOGGER = LoggerFactory.getLogger(JCRFileContent.class);
    protected JCRNodeWrapper node;
    protected Node objectNode;
    protected Node contentNode;

    public JCRFileContent(JCRNodeWrapper node, Node objectNode) {
        this.node = node;
        this.objectNode = objectNode;
    }

    public InputStream downloadFile() {
        try {
            Property p = this.getContentNode().getProperty("jcr:data");
            return p.getBinary().getStream();
        }
        catch (RepositoryException e) {
            LOGGER.error("Repository error", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(InputStream is, String contentType) {
        try {
            Node content = this.objectNode.hasNode("jcr:content") ? this.objectNode.getNode("jcr:content") : (!this.objectNode.isNodeType("jnt:resource") ? this.objectNode.addNode("jcr:content", "jnt:resource") : this.objectNode);
            if (content.hasProperty("jcr:data")) {
                content.getProperty("jcr:data").remove();
            }
            BinaryImpl bin = null;
            if (contentType == null && is.markSupported()) {
                long startTime = 0L;
                if (LOGGER.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    LOGGER.debug("We don't have a proper content type for file content {}, let's detecting it...", (Object)this.node.getPath());
                }
                contentType = DETECTOR.detect(is, new Metadata()).toString();
                if (LOGGER.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    LOGGER.debug("Detected content type for file content of node {}: {}. Detection took {} ms", new Object[]{this.node.getPath(), contentType, System.currentTimeMillis() - startTime});
                }
            }
            if (contentType == null) {
                contentType = "application/binary";
            }
            try {
                bin = new BinaryImpl(is);
                content.setProperty("jcr:data", (Binary)bin);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (bin != null) {
                    bin.dispose();
                }
            }
            content.setProperty("jcr:mimeType", contentType);
            this.contentNode = content;
        }
        catch (IOException | RepositoryException ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
    }

    public String getContentType() {
        try {
            return this.getContentNode().getProperty("jcr:mimeType").getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public String getEncoding() {
        try {
            Node content = this.getContentNode();
            if (content.hasProperty("jcr:encoding")) {
                return content.getProperty("jcr:encoding").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    public long getContentLength() {
        try {
            Node content = this.getContentNode();
            return content.getProperty("jcr:data").getLength();
        }
        catch (RepositoryException repositoryException) {
            return 0L;
        }
    }

    protected Node getContentNode() throws PathNotFoundException, RepositoryException {
        if (this.contentNode == null) {
            this.contentNode = this.objectNode.getNode("jcr:content");
        }
        return this.contentNode;
    }

    public String getExtractedText() {
        try {
            Node content = this.getContentNode();
            Property extractedTextProp = content.getProperty("j:extractedText");
            return extractedTextProp != null ? extractedTextProp.getString() : null;
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public boolean isImage() {
        try {
            String extens = this.node.getPath().substring(this.node.getPath().lastIndexOf(".")).toLowerCase();
            return extens.indexOf("jpg") != -1 || extens.indexOf("jpe") != -1 || extens.indexOf("gif") != -1 || extens.indexOf("png") != -1 || extens.indexOf("bmp") != -1 || extens.indexOf("tif") != -1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getText() {
        try {
            Node content = this.getContentNode();
            Property extractedTextProp = content.getProperty("jcr:data");
            return extractedTextProp != null ? extractedTextProp.getString() : null;
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }
}

