/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSiteNode
extends JCRNodeDecorator
implements JahiaSite {
    private static final Logger logger = LoggerFactory.getLogger(JCRSiteNode.class);
    private static final String CANNOT_GET_SITE_PROPERTY = "Cannot get site property ";
    private static final String CANNOT_SET_SITE_PROPERTY = "Cannot set site property ";
    private Set<String> activeLiveLanguages;
    private List<Locale> activeLiveLanguagesAsLocales;
    private Set<String> inactiveLiveLanguages;
    private Set<String> inactiveLanguages;
    private List<Locale> inactiveLanguagesAsLocales;
    private String defaultLanguage;
    private JCRNodeWrapper home;
    private Set<String> languages;
    private List<Locale> languagesAsLocales;
    private Set<String> mandatoryLanguages;
    private Boolean mixLanguagesActive;
    private Boolean allowsUnlistedLanguages;
    private String templateFolder;
    private List<String> allServerNames;
    private List<String> serverAliases;
    private String serverName;
    private JahiaTemplatesPackage templatePackage;
    private List<String> installedModules;
    private Set<String> installedModulesWithDependencies;

    private static List<String> toUnmodifiableList(String[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String v : values) {
            list.add(v);
        }
        return Collections.unmodifiableList(list);
    }

    private static Set<String> toUnmodifiableSet(String[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String v : values) {
            set.add(v);
        }
        return Collections.unmodifiableSet(set);
    }

    public JCRSiteNode(JCRNodeWrapper node) {
        super(node);
    }

    @Override
    public Set<String> getInactiveLiveLanguages() {
        if (this.inactiveLiveLanguages == null) {
            this.inactiveLiveLanguages = this.getLanguagesInProperty("j:inactiveLiveLanguages");
        }
        return this.inactiveLiveLanguages;
    }

    @Override
    public Set<String> getInactiveLanguages() {
        if (this.inactiveLanguages == null) {
            this.inactiveLanguages = this.getLanguagesInProperty("j:inactiveLanguages");
        }
        return this.inactiveLanguages;
    }

    @Deprecated
    public List<Locale> getActiveLanguagesAsLocales() {
        return this.getActiveLiveLanguagesAsLocales();
    }

    @Deprecated
    public Set<String> getActiveLanguages() {
        return this.getActiveLiveLanguages();
    }

    public Set<String> getActiveLiveLanguages() {
        if (this.activeLiveLanguages == null) {
            HashSet<String> langs = new HashSet<String>(this.getLanguages());
            langs.removeAll(this.getInactiveLiveLanguages());
            this.activeLiveLanguages = langs;
        }
        return this.activeLiveLanguages;
    }

    public List<Locale> getActiveLiveLanguagesAsLocales() {
        if (this.activeLiveLanguagesAsLocales == null) {
            this.activeLiveLanguagesAsLocales = this.getLanguagesAsLocales(this.getActiveLiveLanguages());
        }
        return this.activeLiveLanguagesAsLocales;
    }

    public List<Locale> getInactiveLanguagesAsLocales() {
        if (this.inactiveLanguagesAsLocales == null) {
            this.inactiveLanguagesAsLocales = this.getLanguagesAsLocales(this.getInactiveLiveLanguages());
        }
        return this.inactiveLanguagesAsLocales;
    }

    private List<Locale> getLanguagesAsLocales(Set<String> languages) {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        if (languages != null) {
            for (String language : languages) {
                Locale tempLocale = LanguageCodeConverters.languageCodeToLocale(language);
                localeList.add(tempLocale);
            }
        }
        return Collections.unmodifiableList(localeList);
    }

    @Override
    public String getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            try {
                if (this.hasProperty("j:defaultLanguage")) {
                    this.defaultLanguage = this.getProperty("j:defaultLanguage").getString();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property j:defaultLanguage", (Throwable)e);
            }
        }
        return this.defaultLanguage;
    }

    public String getDescr() {
        return this.getDescription();
    }

    public JCRNodeWrapper getHome() throws RepositoryException {
        if (this.home == null) {
            JCRNodeIteratorWrapper ni = this.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
                if (!next.hasProperty("j:isHomePage") || !next.getProperty("j:isHomePage").getBoolean()) continue;
                this.home = next;
                return this.home;
            }
            if (this.hasNode("home")) {
                this.home = this.getNode("home");
            }
        }
        return this.home;
    }

    public String getHtmlMarkupFilteringTags() {
        try {
            if (this.hasProperty("j:filteredTags")) {
                return this.getProperty("j:filteredTags").getString();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:filteredTags", (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<String> getLanguages() {
        if (this.languages == null) {
            this.languages = this.getLanguagesInProperty("j:languages");
        }
        return this.languages;
    }

    @Override
    public List<Locale> getLanguagesAsLocales() {
        if (this.languagesAsLocales == null) {
            this.languagesAsLocales = this.getLanguagesAsLocales(this.getLanguages());
        }
        return this.languagesAsLocales;
    }

    @Override
    public Set<String> getMandatoryLanguages() {
        if (this.mandatoryLanguages == null) {
            this.mandatoryLanguages = this.getLanguagesInProperty("j:mandatoryLanguages");
        }
        return this.mandatoryLanguages;
    }

    private Set<String> getLanguagesInProperty(String property) {
        HashSet<String> langs = new HashSet();
        try {
            if (this.hasProperty(property)) {
                JCRValueWrapper[] values;
                for (JCRValueWrapper value : values = this.getProperty(property).getValues()) {
                    langs.add(value.getString());
                }
            }
            langs = Collections.unmodifiableSet(langs);
        }
        catch (RepositoryException e) {
            logger.error(CANNOT_GET_SITE_PROPERTY + property, (Throwable)e);
        }
        return langs;
    }

    @Override
    public JCRSiteNode getResolveSite() throws RepositoryException {
        return this;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            try {
                if (this.hasProperty("j:serverName")) {
                    this.serverName = this.getProperty("j:serverName").getString();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property j:serverName", (Throwable)e);
                return null;
            }
        }
        return this.serverName;
    }

    @Override
    public List<String> getServerNameAliases() {
        if (this.serverAliases == null) {
            try {
                if (this.hasProperty("j:serverNameAliases")) {
                    JCRValueWrapper[] v;
                    ArrayList<String> result = new ArrayList<String>();
                    for (JCRValueWrapper value : v = this.getProperty("j:serverNameAliases").getValues()) {
                        result.add(value.getString());
                    }
                    this.serverAliases = Collections.unmodifiableList(result);
                } else {
                    this.serverAliases = Collections.emptyList();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property j:serverNameAliases", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return this.serverAliases;
    }

    @Override
    public List<String> getAllServerNames() {
        if (this.allServerNames == null) {
            this.allServerNames = this.getAllServerNamesInternal();
        }
        return this.allServerNames;
    }

    private List<String> getAllServerNamesInternal() {
        ArrayList<String> result = new ArrayList<String>();
        String name = this.getServerName();
        if (name != null) {
            result.add(name);
        }
        result.addAll(this.getServerNameAliases());
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getSiteKey() {
        return this.getName();
    }

    @Override
    public String getTemplateFolder() {
        if (this.templateFolder == null) {
            String retrievedTemplateFolder = null;
            if (this.getPath().startsWith("/modules")) {
                retrievedTemplateFolder = this.getName();
            } else {
                try {
                    retrievedTemplateFolder = this.getTemplateFolderForSite();
                }
                catch (RepositoryException e) {
                    logger.error(CANNOT_GET_SITE_PROPERTY, (Throwable)e);
                }
            }
            this.templateFolder = StringUtils.substringBefore((String)retrievedTemplateFolder, (String)":");
        }
        return this.templateFolder;
    }

    private String getTemplateFolderForSite() throws RepositoryException {
        String retrievedTemplateFolder = null;
        if (this.hasProperty("j:templatesSet")) {
            retrievedTemplateFolder = this.getProperty("j:templatesSet").getString();
        } else if (this.hasProperty("j:installedModules")) {
            for (JCRValueWrapper value : this.getProperty("j:installedModules").getValues()) {
                JahiaTemplatesPackage modulesTemplatePackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(value.getString());
                if (modulesTemplatePackage == null || !StringUtils.equals((String)modulesTemplatePackage.getModuleType(), (String)"templatesSet")) continue;
                retrievedTemplateFolder = value.getString();
                break;
            }
        }
        return retrievedTemplateFolder;
    }

    @Override
    public List<String> getInstalledModules() {
        if (this.installedModules == null) {
            List<String> modules;
            if (this.getPath().startsWith("/modules")) {
                modules = new ArrayList<String>();
                modules.add(this.getName());
            } else {
                modules = this.getInstalledModulesFromProperty();
            }
            this.installedModules = modules;
        }
        return this.installedModules;
    }

    private List<String> getInstalledModulesFromProperty() {
        ArrayList<String> modules = new ArrayList<String>();
        try {
            if (this.hasProperty("j:installedModules")) {
                JCRValueWrapper[] v = this.getProperty("j:installedModules").getValues();
                for (int i = 0; i < v.length; ++i) {
                    JCRValueWrapper value = v[i];
                    modules.add(StringUtils.substringBefore((String)value.getString(), (String)":"));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:installedModules", (Throwable)e);
        }
        return modules;
    }

    public Set<String> getInstalledModulesWithAllDependencies() {
        if (this.installedModulesWithDependencies == null) {
            LinkedHashSet<String> modules = new LinkedHashSet<String>(this.getInstalledModules());
            ArrayList<String> keys = new ArrayList<String>(modules);
            TemplatePackageRegistry reg = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry();
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                JahiaTemplatesPackage aPackage = reg.lookupById(key);
                if (aPackage == null) {
                    logger.debug("Couldn't find module '{}' which is a direct or transitive dependency of the site '{}'", (Object)key, (Object)this.getName());
                    continue;
                }
                for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                    if (!modules.add(depend.getId())) continue;
                    keys.add(depend.getId());
                }
            }
            this.installedModulesWithDependencies = modules;
        }
        return this.installedModulesWithDependencies;
    }

    public List<String> getAllInstalledModules() {
        List<String> modules = this.getInstalledModulesFromProperty();
        try {
            JahiaTemplatesPackage templatesSetPackage;
            if (this.hasProperty("j:templatesSet") && (templatesSetPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.getProperty("j:templatesSet").getString())) != null) {
                for (JahiaTemplatesPackage dependency : templatesSetPackage.getDependencies()) {
                    if (modules.contains(dependency.getId())) continue;
                    modules.add(dependency.getId());
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:templatesSet", (Throwable)e);
        }
        return modules;
    }

    @Override
    public String getTemplatePackageName() {
        JahiaTemplatesPackage pkg = this.getTemplatePackage();
        return pkg != null ? pkg.getName() : null;
    }

    public JahiaTemplatesPackage getTemplatePackage() {
        if (this.templatePackage == null) {
            this.templatePackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.getTemplateFolder());
        }
        return this.templatePackage;
    }

    @Override
    public String getTitle() {
        try {
            return this.getProperty("j:title").getString();
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:title", (Throwable)e);
            return null;
        }
    }

    public boolean isHtmlMarkupFilteringEnabled() {
        try {
            if (this.hasProperty("j:doTagFiltering")) {
                return this.getProperty("j:doTagFiltering").getBoolean();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:doTagFiltering", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isMixLanguagesActive() {
        if (this.mixLanguagesActive == null) {
            this.mixLanguagesActive = false;
            try {
                if (this.hasProperty("j:mixLanguage")) {
                    this.mixLanguagesActive = this.getProperty("j:mixLanguage").getBoolean();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property j:mixLanguage", (Throwable)e);
            }
        }
        return this.mixLanguagesActive;
    }

    @Override
    public boolean isAllowsUnlistedLanguages() {
        if (this.allowsUnlistedLanguages == null) {
            this.allowsUnlistedLanguages = false;
            try {
                if (this.hasProperty("j:allowsUnlistedLanguages")) {
                    this.allowsUnlistedLanguages = this.getProperty("j:allowsUnlistedLanguages").getBoolean();
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get site property j:allowsUnlistedLanguages", (Throwable)e);
            }
        }
        return this.allowsUnlistedLanguages;
    }

    public boolean isWCAGComplianceCheckEnabled() {
        try {
            if (this.hasProperty("j:wcagCompliance")) {
                return this.getProperty("j:wcagCompliance").getBoolean();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:wcagCompliance", (Throwable)e);
        }
        return false;
    }

    @Override
    public void setDefaultLanguage(String defaultLanguage) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:defaultLanguage", defaultLanguage);
        }
        catch (RepositoryException e) {
            logger.error("Cannot set default language", (Throwable)e);
        }
    }

    private void ensureSiteInDefaultWorkspace() throws RepositoryException {
        if ("live".equals(this.getSession().getWorkspace().getName())) {
            throw new UnsupportedOperationException("Get site in default workspace");
        }
    }

    @Override
    public void setLanguages(Set<String> languages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : languages) {
                if (!LanguageCodeConverters.LANGUAGE_PATTERN.matcher(s).matches()) continue;
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:languages", l.toArray(new Value[l.size()]));
            this.languages = null;
            this.languagesAsLocales = null;
            this.inactiveLanguages = null;
            this.inactiveLiveLanguages = null;
        }
        catch (RepositoryException e) {
            logger.error("Cannot set languages", (Throwable)e);
        }
    }

    @Override
    public void setMandatoryLanguages(Set<String> mandatoryLanguages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : mandatoryLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:mandatoryLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot set mandatory languages", (Throwable)e);
        }
    }

    @Override
    public void setMixLanguagesActive(boolean mixLanguagesActive) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:mixLanguage", mixLanguagesActive);
            this.mixLanguagesActive = mixLanguagesActive;
        }
        catch (RepositoryException e) {
            logger.error("Cannot set j:mixLanguage", (Throwable)e);
        }
    }

    public void setAllowsUnlistedLanguages(Boolean allowsUnlistedLanguages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:allowsUnlistedLanguages", allowsUnlistedLanguages);
            this.allowsUnlistedLanguages = allowsUnlistedLanguages;
        }
        catch (RepositoryException e) {
            logger.error("Cannot set site property j:allowsUnlistedLanguages", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        try {
            if (this.hasProperty("j:description")) {
                return this.getProperty("j:description").getString();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get site property j:description", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isDefault() {
        try {
            return this.getParent().getProperty("j:defaultSite").getString().equals(this.getIdentifier());
        }
        catch (RepositoryException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setDescr(String descr) {
        this.setDescription(descr);
    }

    @Override
    public void setDescription(String description) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:description", description);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setInactiveLanguages(Set<String> inactiveLanguages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : inactiveLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:inactiveLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot set site property j:inactiveLanguages", (Throwable)e);
        }
    }

    @Override
    public void setInactiveLiveLanguages(Set<String> inactiveLiveLanguages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : inactiveLiveLanguages) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:inactiveLiveLanguages", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot set site property j:inactiveLiveLanguages", (Throwable)e);
        }
    }

    @Override
    public void setInstalledModules(List<String> installedModules) {
        try {
            this.ensureSiteInDefaultWorkspace();
            ArrayList<Value> l = new ArrayList<Value>();
            for (String s : installedModules) {
                l.add(this.getSession().getValueFactory().createValue(s));
            }
            this.setProperty("j:installedModules", l.toArray(new Value[l.size()]));
        }
        catch (RepositoryException e) {
            logger.error("Cannot set site property j:installedModules", (Throwable)e);
        }
    }

    @Override
    public void setAllowsUnlistedLanguages(boolean allowsUnlistedLanguages) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:allowsUnlistedLanguages", allowsUnlistedLanguages);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setServerName(String name) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:serverName", name);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setServerNameAliases(List<String> names) {
        try {
            this.ensureSiteInDefaultWorkspace();
            if (names == null || names.size() == 0) {
                this.setProperty("j:serverNameAliases", (String[])null);
            } else {
                this.setProperty("j:serverNameAliases", names.toArray(new String[names.size()]));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setTitle(String value) {
        try {
            this.ensureSiteInDefaultWorkspace();
            this.setProperty("j:title", value);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getJCRLocalPath() {
        return this.getPath();
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if ("j:defaultLanguage".equals(s)) {
            this.defaultLanguage = value;
        } else if ("j:templatesSet".equals(s)) {
            this.templateFolder = null;
        } else if ("j:serverName".equals(s)) {
            this.serverName = value;
            this.allServerNames = this.getAllServerNamesInternal();
        }
        return super.setProperty(s, value);
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if ("j:mixLanguage".equals(s)) {
            this.mixLanguagesActive = value;
        } else if ("j:allowsUnlistedLanguages".equals(s)) {
            this.allowsUnlistedLanguages = value;
        }
        return super.setProperty(s, value);
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if ("j:inactiveLanguages".equals(s)) {
            this.inactiveLanguages = JCRSiteNode.toUnmodifiableSet(values);
        } else if ("j:inactiveLiveLanguages".equals(s)) {
            this.inactiveLiveLanguages = JCRSiteNode.toUnmodifiableSet(values);
            this.inactiveLanguagesAsLocales = this.getLanguagesAsLocales(this.inactiveLiveLanguages);
            this.activeLiveLanguages = null;
            this.activeLiveLanguagesAsLocales = null;
        } else if ("j:languages".equals(s)) {
            this.languages = JCRSiteNode.toUnmodifiableSet(values);
            this.languagesAsLocales = this.getLanguagesAsLocales(this.languages);
            this.activeLiveLanguages = null;
            this.activeLiveLanguagesAsLocales = null;
        } else if ("j:mandatoryLanguages".equals(s)) {
            this.mandatoryLanguages = JCRSiteNode.toUnmodifiableSet(values);
        } else if ("j:installedModules".equals(s)) {
            this.installedModules = JCRSiteNode.toUnmodifiableList(values);
            this.installedModulesWithDependencies = null;
        } else if ("j:serverNameAliases".equals(s)) {
            this.serverAliases = JCRSiteNode.toUnmodifiableList(values);
            this.allServerNames = this.getAllServerNamesInternal();
        }
        return super.setProperty(s, values);
    }
}

