/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.servlets.RangeUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.util.Text;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.files.FileCacheEntry;
import org.jahia.services.content.files.FileCacheManager;
import org.jahia.services.content.files.FileKey;
import org.jahia.services.content.files.FileLastModifiedCacheEntry;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class FileServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(FileServlet.class);
    private static final long serialVersionUID = -414690364676304370L;
    private transient FileCacheManager cacheManager;
    private int cacheThreshold = 65536;
    private boolean cacheForLoggedUsers = true;
    private boolean cacheFromExternalProviders;
    private String characterEncoding = null;
    private transient MetricsLoggingService loggingService;
    private transient JCRSessionFactory sessionFactory;

    private boolean canCache(JCRNodeWrapper n) {
        return this.cacheFromExternalProviders || n.getProvider().canCacheNode(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block43: {
            block42: {
                block41: {
                    block45: {
                        block40: {
                            block39: {
                                block38: {
                                    timer = System.currentTimeMillis();
                                    code = 200;
                                    fileKey = this.parseKey(req);
                                    if (fileKey == null || fileKey.getWorkspace() == null || !StringUtils.isNotEmpty((String)fileKey.getPath())) ** GOTO lbl136
                                    lastModifiedCache = this.cacheManager.getLastModifiedCache();
                                    lastModifiedEntry = lastModifiedCache.get(fileKey.getCacheKey());
                                    if (!this.isNotModified(fileKey, lastModifiedEntry, req, res)) break block38;
                                    code = 304;
                                    res.setStatus(304);
                                    this.logAccess(fileKey, req, "ok-not-modified");
                                    if (FileServlet.logger.isDebugEnabled()) {
                                        FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                                    }
                                    return;
                                }
                                contentCache = this.cacheManager.getContentCache();
                                entries = contentCache.get(fileKey.getCacheKey());
                                v0 = fileEntry = entries != null ? entries.get(fileKey.getThumbnail()) : null;
                                if (fileEntry != null) ** GOTO lbl56
                                n = this.getNode(fileKey);
                                if (n != null && n.isFile()) break block39;
                                code = 404;
                                res.sendError(404);
                                if (FileServlet.logger.isDebugEnabled()) {
                                    FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                                }
                                return;
                            }
                            lastModifiedDate = n.getLastModifiedAsDate();
                            lastModified = lastModifiedDate != null ? lastModifiedDate.getTime() : 0L;
                            eTag = this.generateETag(n.getIdentifier(), lastModified);
                            if (lastModifiedEntry == null) {
                                lastModifiedEntry = new FileLastModifiedCacheEntry(eTag, lastModified);
                                if (this.canCache(n)) {
                                    lastModifiedCache.put(fileKey.getCacheKey(), lastModifiedEntry);
                                }
                            }
                            if (!this.isNotModified(fileKey, lastModifiedEntry, req, res)) break block40;
                            code = 304;
                            res.setStatus(304);
                            this.logAccess(fileKey, req, "ok-not-modified");
                            if (FileServlet.logger.isDebugEnabled()) {
                                FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                            }
                            return;
                        }
                        fileEntry = this.getFileEntry(fileKey, n, lastModifiedEntry);
                        if (fileEntry != null && fileEntry.getData() != null) {
                            entries = contentCache.get(fileKey.getCacheKey());
                            if (entries == null) {
                                entries = new HashMap<String, FileCacheEntry>(1);
                            }
                            entries.put(fileKey.getThumbnail(), fileEntry);
                            contentCache.put(fileKey.getCacheKey(), entries);
                            this.logAccess(fileKey, req, "ok");
                        }
                        break block45;
lbl56:
                        // 1 sources

                        if (lastModifiedEntry == null) {
                            lastModifiedEntry = new FileLastModifiedCacheEntry(fileEntry.getETag(), fileEntry.getLastModified());
                            lastModifiedCache.put(fileKey.getCacheKey(), lastModifiedEntry);
                        }
                        this.logAccess(fileKey, req, "ok-cached");
                        if (FileServlet.logger.isDebugEnabled()) {
                            FileServlet.logger.debug("Serving cached file entry {}", (Object)fileKey.toString());
                        }
                    }
                    if (fileEntry == null) ** GOTO lbl128
                    useRanges = true;
                    if (fileEntry.getBinary() instanceof BinaryRangesSupport) {
                        useRanges = ((BinaryRangesSupport)fileEntry.getBinary()).supportRanges();
                    }
                    v1 = ranges = useRanges != false ? RangeUtils.parseRange(req, res, fileEntry.getETag(), fileEntry.getLastModified(), fileEntry.getContentLength()) : null;
                    if (fileKey.getPath().indexOf(37, fileKey.getPath().lastIndexOf(47)) != -1) {
                        res.setHeader("Content-Disposition", "inline; filename=\"" + JCRContentUtils.unescapeLocalNodeName(StringUtils.substringAfterLast((String)fileKey.getPath(), (String)"/")) + "\"");
                    }
                    res.setDateHeader("Last-Modified", fileEntry.getLastModified());
                    res.setHeader("ETag", fileEntry.getETag());
                    is /* !! */  = null;
                    if (fileEntry.getData() != null) {
                        is /* !! */  = new ByteArrayInputStream(fileEntry.getData());
                        break block41;
                    }
                    if (fileEntry.getBinary() != null) {
                        is /* !! */  = fileEntry.getBinary().getStream();
                        break block41;
                    }
                    code = 404;
                    res.sendError(404);
                    if (FileServlet.logger.isDebugEnabled()) {
                        FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                    }
                    return;
                }
                if (ranges == null || ranges == RangeUtils.FULL) {
                    res.setContentType(fileEntry.getMimeType());
                    if (fileEntry.getContentLength() <= 0x7FFFFFFFL) {
                        res.setContentLength((int)fileEntry.getContentLength());
                    } else {
                        res.setHeader("Content-Length", Long.toString(fileEntry.getContentLength()));
                    }
                    os = res.getOutputStream();
                    IOUtils.copy((InputStream)is /* !! */ , (OutputStream)os);
                    os.flush();
                    os.close();
                } else {
                    res.setStatus(206);
                    if (ranges.size() == 1) {
                        res.setContentType(fileEntry.getMimeType());
                        range = ranges.get(0);
                        res.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                        length = range.end - range.start + 1L;
                        if (length < 0x7FFFFFFFL) {
                            res.setContentLength((int)length);
                        } else {
                            res.setHeader("Content-Length", "" + length);
                        }
                        os = res.getOutputStream();
                        RangeUtils.copy(is /* !! */ , os, range);
                        IOUtils.closeQuietly((InputStream)is /* !! */ );
                        IOUtils.closeQuietly((OutputStream)os);
                    } else {
                        res.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                        try {
                            res.setBufferSize(RangeUtils.getOutput());
                        }
                        catch (IllegalStateException range) {
                            // empty catch block
                        }
                        os = res.getOutputStream();
                        RangeUtils.copy(is /* !! */ , os, ranges.iterator(), fileEntry.getMimeType());
                        IOUtils.closeQuietly((InputStream)is /* !! */ );
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                }
                if (fileEntry.getData() == null && fileEntry.getBinary() != null) {
                    fileEntry.getBinary().dispose();
                    fileEntry.setBinary(null);
                }
                SpringContextSingleton.getInstance().publishEvent(new FileDownloadEvent((Object)this, req, fileEntry.getIdentifier(), fileKey.getPath(), fileEntry.getNodeTypes(), fileKey.getWorkspace()));
                break block42;
lbl128:
                // 1 sources

                code = 404;
                res.sendError(404);
                if (FileServlet.logger.isDebugEnabled()) {
                    FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                }
                return;
            }
            try {
                break block43;
lbl136:
                // 1 sources

                code = 404;
                res.sendError(404);
            }
            catch (RepositoryException e) {
                try {
                    FileServlet.logger.error("Cannot get file", (Throwable)e);
                    code = 500;
                    res.sendError(500);
                }
                catch (Throwable var19_24) {
                    if (FileServlet.logger.isDebugEnabled()) {
                        FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                    }
                    throw var19_24;
                }
                if (FileServlet.logger.isDebugEnabled()) {
                    FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
                } else {
                    ** GOTO lbl154
                }
            }
        }
        if (FileServlet.logger.isDebugEnabled()) {
            FileServlet.logger.debug("Served [{}] with status code [{}] in [{}ms]", new Object[]{req.getRequestURI() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), code, System.currentTimeMillis() - timer});
        }
    }

    protected String generateETag(String uuid, long lastModified) {
        return "\"" + StringUtils.replace((String)StringUtils.defaultIfEmpty((String)uuid, (String)"unknown"), (String)"\"", (String)"") + "-" + lastModified + "\"";
    }

    protected JCRNodeWrapper getContentNode(JCRNodeWrapper n, String thumbnail) throws RepositoryException {
        JCRNodeWrapper content;
        if (StringUtils.isNotEmpty((String)(thumbnail = Text.escapeIllegalJcrChars((String)thumbnail))) && n.hasNode(thumbnail)) {
            content = n.getNode(thumbnail);
            if (!content.isNodeType("nt:resource")) {
                content = null;
            }
        } else {
            try {
                content = n.getNode("jcr:content");
            }
            catch (PathNotFoundException e) {
                logger.warn("Cannot find jcr:content sub-node in the {} node.", (Object)n.getPath());
                content = null;
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileCacheEntry getFileEntry(FileKey fileKey, JCRNodeWrapper node, FileLastModifiedCacheEntry lastModifiedEntry) throws RepositoryException, IOException {
        FileCacheEntry fileEntry = null;
        JCRNodeWrapper content = this.getContentNode(node, fileKey.getThumbnail());
        if (content == null) {
            return null;
        }
        Binary binary = null;
        try {
            binary = content.getProperty("jcr:data").getBinary();
        }
        catch (PathNotFoundException e) {
            logger.warn("Unable to get jcr:data property for node {}", (Object)content.getPath());
            return null;
        }
        int contentLength = (int)binary.getSize();
        fileEntry = new FileCacheEntry(lastModifiedEntry.getETag(), content.getProperty("jcr:mimeType").getString(), contentLength, lastModifiedEntry.getLastModified(), node.getIdentifier(), node.getNodeTypes());
        if (contentLength <= this.cacheThreshold && this.canCache(node) && this.isVisibleForGuest(node)) {
            InputStream is = null;
            try {
                is = binary.getStream();
                fileEntry.setData(IOUtils.toByteArray((InputStream)is));
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                binary.dispose();
            }
        } else {
            fileEntry.setBinary(binary);
        }
        return fileEntry;
    }

    protected JCRNodeWrapper getNode(FileKey fileKey) {
        JCRNodeWrapper n = null;
        JCRSessionWrapper session = null;
        try {
            session = JCRSessionFactory.getInstance().getCurrentUserSession(fileKey.getWorkspace());
            if (fileKey.getVersionDate() != null) {
                session.setVersionDate(new Date(Long.valueOf(fileKey.getVersionDate())));
            }
            if (fileKey.getVersionLabel() != null) {
                session.setVersionLabel(fileKey.getVersionLabel());
            }
            if (!this.isValid(n = session.getNode(fileKey.getPath()))) {
                n = null;
            }
        }
        catch (RuntimeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (PathNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            if (e.getCause() != null && e.getCause() instanceof MalformedPathException) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            logger.error("Error accesing path: " + fileKey.getPath() + " for user " + (session != null ? session.getUserID() : null), (Throwable)e);
        }
        return n;
    }

    private boolean isValid(JCRNodeWrapper n) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (!"live".equals(n.getSession().getWorkspace().getName())) {
            return true;
        }
        return (!n.hasProperty("j:published") || n.getProperty("j:published").getBoolean()) && VisibilityService.getInstance().matchesConditions(n);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.characterEncoding = SettingsBean.getInstance().getCharacterEncoding();
        String value = config.getInitParameter("cache-threshold");
        if (value != null) {
            this.cacheThreshold = new Integer(value);
        }
        if ((value = config.getInitParameter("cache-for-logged-in-users")) != null) {
            this.cacheForLoggedUsers = Boolean.parseBoolean(value);
        }
        if ((value = config.getInitParameter("cache-from-external-providers")) != null) {
            this.cacheFromExternalProviders = Boolean.parseBoolean(value);
        }
        try {
            this.cacheManager = FileCacheManager.getInstance();
            this.cacheManager.getContentCache();
            this.cacheManager.getLastModifiedCache();
        }
        catch (JahiaRuntimeException e) {
            throw new ServletException(e.getCause());
        }
        if (SettingsBean.getInstance().isFileServletStatisticsEnabled()) {
            try {
                this.loggingService = (MetricsLoggingService)SpringContextSingleton.getBean("loggingService");
                this.sessionFactory = JCRSessionFactory.getInstance();
            }
            catch (Exception e) {
                logger.error("Unable to get the logging service instance. Metrics logging will be disabled.");
            }
        }
    }

    protected boolean isNotModified(FileKey fileKey, FileLastModifiedCacheEntry lastModifiedEntry, HttpServletRequest request, HttpServletResponse response) {
        if (lastModifiedEntry != null) {
            String eTag = request.getHeader("If-None-Match");
            if (eTag != null) {
                return eTag.equals(lastModifiedEntry.getETag());
            }
            long modifiedSince = request.getDateHeader("If-Modified-Since");
            if (modifiedSince > -1L && lastModifiedEntry.getLastModified() > 0L && lastModifiedEntry.getLastModified() / 1000L * 1000L <= modifiedSince) {
                return true;
            }
        }
        return false;
    }

    protected void logAccess(FileKey fileKey, HttpServletRequest req, String status) {
        if (this.loggingService == null || !this.loggingService.isEnabled()) {
            return;
        }
        HttpSession httpSession = req.getSession(false);
        String sessionID = httpSession != null ? httpSession.getId() : req.getRequestedSessionId();
        this.loggingService.logContentEvent(this.sessionFactory.getCurrentUser().getName(), req.getRemoteAddr(), sessionID, "", fileKey.getPath(), "", "fileAccessed", status);
    }

    protected FileKey parseKey(HttpServletRequest req) throws UnsupportedEncodingException {
        String workspace = null;
        String path = null;
        String p = req.getPathInfo();
        if (p != null && p.length() > 2) {
            int pathStart = p.indexOf("/", 1);
            String string = workspace = pathStart > 1 ? p.substring(1, pathStart) : null;
            if (workspace != null) {
                path = p.substring(pathStart);
                if ("{workspace}".equals(URLDecoder.decode(workspace, this.characterEncoding))) {
                    workspace = "default";
                }
                if (!JCRContentUtils.isValidWorkspace(workspace)) {
                    workspace = null;
                }
            }
        }
        return path != null && workspace != null ? new FileKey(workspace, JCRContentUtils.escapeNodePath(path), req.getParameter("v"), req.getParameter("l"), StringUtils.defaultIfEmpty((String)req.getParameter("t"), (String)"")) : null;
    }

    private boolean isVisibleForGuest(final JCRNodeWrapper n) throws RepositoryException {
        if (!n.getSession().getUserID().equals("guest")) {
            if (this.cacheForLoggedUsers) {
                try {
                    JCRTemplate.getInstance().doExecute("guest", null, n.getSession().getWorkspace().getName(), n.getSession().getLocale(), new JCRCallback<Node>(){

                        @Override
                        public Node doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            return session.getProviderSession(n.getProvider()).getNodeByIdentifier(n.getIdentifier());
                        }
                    });
                }
                catch (ItemNotFoundException e) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static interface BinaryRangesSupport {
        public boolean supportRanges();
    }

    public class FileDownloadEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -7003604984285879294L;
        HttpServletRequest request;
        String nodeId;
        String nodePath;
        List<String> nodeTypes;
        String workspace;

        protected FileDownloadEvent(Object source, HttpServletRequest request, String nodeId, String nodePath, List<String> nodeTypes, String workspace) {
            super(source);
            this.request = request;
            this.nodeId = nodeId;
            this.nodePath = nodePath;
            this.nodeTypes = nodeTypes;
            this.workspace = workspace;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public List<String> getNodeTypes() {
            return this.nodeTypes;
        }

        public String getWorkspace() {
            return this.workspace;
        }
    }
}

