/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.DynamicValueImpl;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.LexerLegacy;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaCndReaderLegacy {
    private static Logger logger = LoggerFactory.getLogger(JahiaCndReader.class);
    protected String systemId;
    protected String filename;
    protected NodeTypeRegistry registry;
    protected List<ExtendedNodeType> nodeTypesList = new LinkedList<ExtendedNodeType>();
    protected LexerLegacy lexer;
    protected String currentToken;

    public JahiaCndReaderLegacy(Reader r, String filename, String systemId, NodeTypeRegistry registry) throws ParseException, IOException {
        this.systemId = systemId;
        this.registry = registry;
        this.filename = filename;
        this.lexer = new LexerLegacy(r, filename);
    }

    public List<ExtendedNodeType> getNodeTypesList() {
        return this.nodeTypesList;
    }

    public void parse() throws ParseException, IOException, RepositoryException {
        this.nextToken();
        while (!this.currentTokenEquals("eof") && this.doNameSpace()) {
        }
        while (!this.currentTokenEquals("eof")) {
            ExtendedNodeType ntd = new ExtendedNodeType(this.registry, this.systemId);
            try {
                this.doNodeTypeName(ntd);
                this.doSuperTypes(ntd);
                this.doOptions(ntd);
                this.doItemDefs(ntd);
                this.registry.addNodeType(ntd.getNameObject(), ntd);
                this.nodeTypesList.add(ntd);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.nextToken();
                while (!this.currentTokenEquals('[') && !this.currentTokenEquals("eof")) {
                    this.nextToken();
                }
            }
        }
        for (ExtendedNodeType type : this.nodeTypesList) {
            try {
                type.validate();
            }
            catch (NoSuchNodeTypeException e) {
                throw new ParseException("Cannot validate supertypes for : " + type.getName(), e, 0, 0, this.filename);
            }
        }
    }

    private boolean doNameSpace() throws ParseException, IOException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        this.registry.getNamespaces().put(prefix, uri);
        this.nextToken();
        return true;
    }

    private void doNodeTypeName(ExtendedNodeType ntd) throws ParseException, IOException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Unexpected token '" + this.currentToken + "'");
        }
        this.nextToken();
        Name name = this.parseName(this.currentToken);
        ntd.setName(name);
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
    }

    private void doSuperTypes(ExtendedNodeType ntd) throws ParseException, IOException {
        ArrayList<String> supertypes = new ArrayList<String>();
        if (!this.currentTokenEquals('>')) {
            return;
        }
        do {
            this.nextToken();
            supertypes.add(this.currentToken);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        ntd.setDeclaredSupertypes(supertypes.toArray(new String[supertypes.size()]));
    }

    private void doOptions(ExtendedNodeType ntd) throws ParseException, IOException {
        if (this.currentTokenEquals(LexerLegacy.ABSTRACT)) {
            ntd.setAbstract(true);
            this.nextToken();
        }
        if (this.currentTokenEquals(LexerLegacy.ORDERABLE)) {
            ntd.setHasOrderableChildNodes(true);
            this.nextToken();
            if (this.currentTokenEquals(LexerLegacy.MIXIN)) {
                ntd.setMixin(true);
                this.nextToken();
            }
        } else if (this.currentTokenEquals(LexerLegacy.MIXIN)) {
            ntd.setMixin(true);
            this.nextToken();
            if (this.currentTokenEquals(LexerLegacy.ORDERABLE)) {
                ntd.setHasOrderableChildNodes(true);
                this.nextToken();
            }
        }
        if (this.currentTokenEquals(LexerLegacy.ABSTRACT)) {
            ntd.setAbstract(true);
            this.nextToken();
        }
        if (this.currentTokenEquals(LexerLegacy.VALIDATOR)) {
            this.nextToken();
            if (this.currentTokenEquals('=')) {
                this.nextToken();
                this.nextToken();
            } else {
                this.lexer.fail("Invalid validator");
            }
        }
    }

    private void doItemDefs(ExtendedNodeType ntd) throws ParseException, IOException, RepositoryException {
        while (true) {
            StringBuilder ctnListTypeName;
            ExtendedNodeType[] ctnTypes;
            ExtendedNodeDefinition listNodeDef;
            ExtendedNodeDefinition ndi;
            ExtendedPropertyDefinition pdi;
            if (this.currentTokenEquals('-')) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals('+')) {
                ndi = new ExtendedNodeDefinition(this.registry);
                this.nextToken();
                this.doChildNodeDefinition(ndi, ntd);
                ndi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_CONTAINERLIST)) {
                listNodeDef = new ExtendedNodeDefinition(this.registry);
                this.nextToken();
                this.doChildNodeDefinition(listNodeDef, ntd);
                ctnTypes = listNodeDef.getRequiredPrimaryTypes();
                ctnListTypeName = new StringBuilder();
                ctnListTypeName.append(ctnTypes[0].getNameObject().getPrefix()).append(":");
                for (ExtendedNodeType ctnType : ctnTypes) {
                    ctnListTypeName.append(ctnType.getNameObject().getLocalName());
                }
                if (listNodeDef.isMandatory()) {
                    ctnListTypeName.append("Mandatory");
                }
                ctnListTypeName.append("List");
                Object append = "";
                if (listNodeDef.getSelectorOptions().get("availableTypes") != null) {
                    append = (String)append + JCRContentUtils.replaceColon(listNodeDef.getSelectorOptions().get("availableTypes"));
                }
                if (listNodeDef.getSelectorOptions().get("addMixin") != null) {
                    append = (String)append + JCRContentUtils.replaceColon(listNodeDef.getSelectorOptions().get("addMixin"));
                }
                if (((String)append).length() > 0) {
                    ctnListTypeName.append(Integer.toHexString(((String)append).hashCode()));
                }
                listNodeDef.setRequiredPrimaryTypes(new String[]{ctnListTypeName.toString()});
                try {
                    this.registry.getNodeType(ctnListTypeName.toString());
                }
                catch (NoSuchNodeTypeException e) {
                    ExtendedNodeType listType = new ExtendedNodeType(this.registry, this.systemId);
                    listType.setName(this.parseName(ctnListTypeName.toString()));
                    listType.setDeclaredSupertypes(new String[]{"jnt:contentList"});
                    listType.setHasOrderableChildNodes(true);
                    ExtendedNodeDefinition def = new ExtendedNodeDefinition(this.registry);
                    def.setName(this.parseName("*"));
                    String[] names = new String[ctnTypes.length];
                    for (int i = 0; i < ctnTypes.length; ++i) {
                        names[i] = ctnTypes[i].getName();
                    }
                    def.setRequiredPrimaryTypes(names);
                    def.setAllowsSameNameSiblings(true);
                    def.setDeclaringNodeType(listType);
                    def.setMandatory(listNodeDef.isMandatory());
                    def.setSelectorOptions(listNodeDef.getSelectorOptions());
                    this.registry.addNodeType(listType.getNameObject(), listType);
                }
                listNodeDef.setAutoCreated(true);
                listNodeDef.setMandatory(true);
                listNodeDef.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_SINGLECONTAINER)) {
                listNodeDef = new ExtendedNodeDefinition(this.registry);
                this.nextToken();
                this.doChildNodeDefinition(listNodeDef, ntd);
                ctnTypes = listNodeDef.getRequiredPrimaryTypes();
                ctnListTypeName = new StringBuilder();
                ctnListTypeName.append(ctnTypes[0].getNameObject().getPrefix()).append(":");
                for (ExtendedNodeType ctnType : ctnTypes) {
                    ctnListTypeName.append(ctnType.getNameObject().getLocalName());
                }
                if (listNodeDef.isMandatory()) {
                    ctnListTypeName.append("Mandatory");
                }
                ctnListTypeName.append("Single");
                listNodeDef.setRequiredPrimaryTypes(new String[]{ctnListTypeName.toString()});
                try {
                    this.registry.getNodeType(ctnListTypeName.toString());
                }
                catch (NoSuchNodeTypeException e) {
                    ExtendedNodeType listType = new ExtendedNodeType(this.registry, this.systemId);
                    listType.setName(this.parseName(ctnListTypeName.toString()));
                    listType.setDeclaredSupertypes(new String[]{"jnt:contentList"});
                    listType.setHasOrderableChildNodes(true);
                    ExtendedNodeDefinition def = new ExtendedNodeDefinition(this.registry);
                    def.setName(this.parseName("*"));
                    String[] names = new String[ctnTypes.length];
                    for (int i = 0; i < ctnTypes.length; ++i) {
                        names[i] = ctnTypes[i].getName();
                    }
                    def.setRequiredPrimaryTypes(names);
                    def.setAllowsSameNameSiblings(false);
                    def.setDeclaringNodeType(listType);
                    def.setMandatory(listNodeDef.isMandatory());
                    this.registry.addNodeType(listType.getNameObject(), listType);
                }
                listNodeDef.setAutoCreated(true);
                listNodeDef.setMandatory(true);
                listNodeDef.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_SMALLTEXTFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(1);
                pdi.setSelector(1);
                pdi.setInternationalized(true);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_SHAREDSMALLTEXTFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(1);
                pdi.setSelector(1);
                pdi.setInternationalized(false);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_BIGTEXTFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(1);
                pdi.setSelector(2);
                pdi.setInternationalized(true);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_DATEFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(5);
                pdi.setSelector(3);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_PAGEFIELD)) {
                ndi = new ExtendedNodeDefinition(this.registry);
                ndi.setRequiredPrimaryTypes(new String[]{"jmix:link"});
                this.nextToken();
                this.doChildNodeDefinition(ndi, ntd);
                ndi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_FILEFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(1);
                pdi.setSelector(9);
                pdi.setInternationalized(true);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_PORTLETFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(9);
                pdi.setSelector(20);
                pdi.setInternationalized(false);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_INTEGERFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(3);
                pdi.setSelector(1);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_FLOATFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(4);
                pdi.setSelector(1);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_BOOLEANFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(6);
                pdi.setSelector(11);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (this.currentTokenEquals(LexerLegacy.JAHIA_CATEGORYFIELD)) {
                pdi = new ExtendedPropertyDefinition(this.registry);
                pdi.setRequiredType(1);
                pdi.setSelector(13);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                pdi.setDeclaringNodeType(ntd);
                continue;
            }
            if (!this.currentTokenEquals(LexerLegacy.JAHIA_COLORFIELD)) break;
            pdi = new ExtendedPropertyDefinition(this.registry);
            pdi.setRequiredType(1);
            pdi.setSelector(12);
            this.nextToken();
            this.doPropertyDefinition(pdi, ntd);
            pdi.setDeclaringNodeType(ntd);
        }
    }

    private void doPropertyDefinition(ExtendedPropertyDefinition pdi, ExtendedNodeType ntd) throws ParseException, IOException {
        Name name = this.parseName(this.currentToken);
        pdi.setName(name);
        this.nextToken();
        this.doPropertyType(pdi);
        this.doPropertyDefaultValue(pdi);
        this.doPropertyAttributes(pdi, ntd);
        this.doPropertyValueConstraints(pdi);
    }

    private void doPropertyType(ExtendedPropertyDefinition pdi) throws ParseException, IOException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        this.nextToken();
        if (pdi.getRequiredType() == 0) {
            if (this.currentTokenEquals(LexerLegacy.STRING)) {
                pdi.setRequiredType(1);
            } else if (this.currentTokenEquals(LexerLegacy.BINARY)) {
                pdi.setRequiredType(2);
            } else if (this.currentTokenEquals(LexerLegacy.LONG)) {
                pdi.setRequiredType(3);
            } else if (this.currentTokenEquals(LexerLegacy.DOUBLE)) {
                pdi.setRequiredType(4);
            } else if (this.currentTokenEquals(LexerLegacy.BOOLEAN)) {
                pdi.setRequiredType(6);
            } else if (this.currentTokenEquals(LexerLegacy.DATE)) {
                pdi.setRequiredType(5);
            } else if (this.currentTokenEquals(LexerLegacy.NAME)) {
                pdi.setRequiredType(7);
            } else if (this.currentTokenEquals(LexerLegacy.PATH)) {
                pdi.setRequiredType(8);
            } else if (this.currentTokenEquals(LexerLegacy.REFERENCE)) {
                pdi.setRequiredType(9);
            } else if (this.currentTokenEquals(LexerLegacy.WEAKREFERENCE)) {
                pdi.setRequiredType(10);
            } else if (this.currentTokenEquals(LexerLegacy.URI)) {
                pdi.setRequiredType(11);
            } else if (this.currentTokenEquals(LexerLegacy.DECIMAL)) {
                pdi.setRequiredType(12);
            } else if (this.currentTokenEquals(LexerLegacy.UNDEFINED)) {
                pdi.setRequiredType(0);
            } else {
                this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
            }
            this.nextToken();
            if (this.currentTokenEquals(')')) {
                this.nextToken();
            } else if (this.currentTokenEquals(',')) {
                this.nextToken();
                this.doPropertySelector(pdi);
            } else {
                this.lexer.fail("Missing ')' delimiter for end of property type");
            }
        } else {
            this.doPropertySelector(pdi);
        }
    }

    private void doPropertySelector(ExtendedPropertyDefinition pdi) throws ParseException, IOException {
        if (this.currentTokenEquals(LexerLegacy.SMALLTEXT)) {
            pdi.setSelector(1);
        } else if (this.currentTokenEquals(LexerLegacy.RICHTEXT)) {
            pdi.setSelector(2);
        } else if (this.currentTokenEquals(LexerLegacy.CHOICELIST)) {
            pdi.setSelector(14);
        } else if (this.currentTokenEquals(LexerLegacy.DATEPICKER)) {
            pdi.setSelector(4);
        } else if (this.currentTokenEquals(LexerLegacy.DATETIMEPICKER)) {
            pdi.setSelector(3);
        } else if (this.currentTokenEquals(LexerLegacy.CATEGORY)) {
            pdi.setSelector(13);
        } else if (this.currentTokenEquals(LexerLegacy.FILEPICKER)) {
            pdi.setSelector(9);
        } else if (this.currentTokenEquals(LexerLegacy.FILEUPLOAD)) {
            pdi.setSelector(10);
        } else if (this.currentTokenEquals(LexerLegacy.COLOR)) {
            pdi.setSelector(12);
        } else if (this.currentTokenEquals(LexerLegacy.CHECKBOX)) {
            pdi.setSelector(11);
        } else if (this.currentTokenEquals(LexerLegacy.PORTLETDEFINITION)) {
            pdi.setSelector(22);
        } else if (this.currentTokenEquals(LexerLegacy.PORTLET)) {
            pdi.setSelector(20);
        } else {
            this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (this.currentTokenEquals('[')) {
            this.doSelectorOptions(pdi);
        }
        if (this.currentTokenEquals(')')) {
            this.nextToken();
        } else {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
    }

    private void doPropertyAttributes(ExtendedPropertyDefinition pdi, ExtendedNodeType ntd) throws ParseException, IOException {
        while (this.currentTokenEquals(LexerLegacy.ATTRIBUTE)) {
            if (this.currentTokenEquals(LexerLegacy.PRIMARY)) {
                ntd.setPrimaryItemName(pdi.getName());
            } else if (this.currentTokenEquals(LexerLegacy.AUTOCREATED)) {
                pdi.setAutoCreated(true);
            } else if (this.currentTokenEquals(LexerLegacy.MANDATORY)) {
                pdi.setMandatory(true);
            } else if (this.currentTokenEquals(LexerLegacy.PROTECTED)) {
                pdi.setProtected(true);
            } else if (this.currentTokenEquals(LexerLegacy.MULTIPLE)) {
                pdi.setMultiple(true);
            } else if (this.currentTokenEquals(LexerLegacy.HIDDEN)) {
                pdi.setHidden(true);
            } else if (this.currentTokenEquals(LexerLegacy.INTERNATIONALIZED)) {
                pdi.setInternationalized(true);
            } else if (this.currentTokenEquals(LexerLegacy.INDEXED)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    if (this.currentTokenEquals(LexerLegacy.NO)) {
                        pdi.setIndex(0);
                    } else if (this.currentTokenEquals(LexerLegacy.TOKENIZED)) {
                        pdi.setIndex(1);
                    } else if (this.currentTokenEquals(LexerLegacy.UNTOKENIZED)) {
                        pdi.setIndex(2);
                    } else {
                        this.lexer.fail("Invalid value for indexed [ no | tokenized | untokenized ] " + this.currentToken);
                    }
                } else {
                    this.lexer.fail("Invalid value for indexed " + this.currentToken);
                }
            } else if (this.currentTokenEquals(LexerLegacy.SCOREBOOST)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    try {
                        pdi.setScoreboost(Double.parseDouble(this.currentToken));
                    }
                    catch (NumberFormatException e) {
                        this.lexer.fail("Invalid value for score boost " + this.currentToken);
                    }
                } else {
                    this.lexer.fail("Invalid value for score boost " + this.currentToken);
                }
            } else if (this.currentTokenEquals(LexerLegacy.ANALYZER)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    pdi.setAnalyzer(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for tokenizer " + this.currentToken);
                }
            } else if (this.currentTokenEquals(LexerLegacy.SORTABLE)) {
                pdi.setQueryOrderable(true);
            } else if (this.currentTokenEquals(LexerLegacy.FACETABLE)) {
                pdi.setFacetable(true);
            } else if (this.currentTokenEquals(LexerLegacy.FULLTEXTSEARCHABLE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    if (this.currentTokenEquals(LexerLegacy.NO)) {
                        pdi.setFullTextSearchable(Boolean.FALSE);
                    } else if (this.currentTokenEquals(LexerLegacy.YES)) {
                        pdi.setFullTextSearchable(Boolean.TRUE);
                    }
                }
            } else if (this.currentTokenEquals(LexerLegacy.COPY)) {
                pdi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(LexerLegacy.VERSION)) {
                pdi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(LexerLegacy.INITIALIZE)) {
                pdi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(LexerLegacy.COMPUTE)) {
                pdi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(LexerLegacy.IGNORE)) {
                pdi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(LexerLegacy.ABORT)) {
                pdi.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private void doPropertyDefaultValue(ExtendedPropertyDefinition pdi) throws ParseException, IOException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        List<Value> defaultValues = this.doValuesList(pdi, false);
        pdi.setDefaultValues(defaultValues.toArray(new Value[defaultValues.size()]));
    }

    private void doPropertyValueConstraints(ExtendedPropertyDefinition pdi) throws ParseException, IOException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        List<Value> constraints = this.doValuesList(pdi, true);
        pdi.setValueConstraints(constraints.toArray(new Value[constraints.size()]));
    }

    private List<Value> doValuesList(ExtendedPropertyDefinition pdi, boolean isConstraint) throws ParseException {
        ArrayList<Value> values = new ArrayList<Value>();
        do {
            this.nextToken();
            String v = this.currentToken;
            this.nextToken();
            if (this.currentTokenEquals('(')) {
                this.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                while (!this.currentTokenEquals(')')) {
                    params.add(this.currentToken);
                    this.nextToken();
                }
                this.nextToken();
                values.add(new DynamicValueImpl(v, params, pdi.getRequiredType(), isConstraint, pdi));
                continue;
            }
            values.add(new ValueImpl(v, pdi.getRequiredType(), isConstraint));
        } while (this.currentTokenEquals(','));
        return values;
    }

    private void doChildNodeDefinition(ExtendedNodeDefinition ndi, ExtendedNodeType ntd) throws ParseException, IOException {
        Name name = this.parseName(this.currentToken);
        ndi.setName(name);
        this.nextToken();
        this.doChildNodeRequiredTypes(ndi);
        this.doChildNodeDefaultType(ndi);
        this.doChildNodeAttributes(ndi, ntd);
    }

    private void doChildNodeRequiredTypes(ExtendedNodeDefinition ndi) throws ParseException, IOException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        if (ndi.getRequiredPrimaryTypeNames() == null) {
            ArrayList<String> types = new ArrayList<String>();
            do {
                this.nextToken();
                types.add(this.currentToken);
                this.nextToken();
            } while (this.currentTokenEquals(','));
            if (this.currentTokenEquals('[')) {
                this.doSelectorOptions(ndi);
            }
            if (this.currentTokenEquals(')')) {
                this.nextToken();
            } else {
                this.lexer.fail("Missing ')' delimiter for end of child node type");
            }
            ndi.setRequiredPrimaryTypes(types.toArray(new String[types.size()]));
        } else {
            this.nextToken();
            this.doChildNodeSelector(ndi);
        }
    }

    private void doChildNodeSelector(ExtendedNodeDefinition ndi) throws ParseException, IOException {
        if (this.currentTokenEquals(LexerLegacy.PAGE)) {
            ndi.setSelector(21);
        } else {
            this.lexer.fail("Unknown type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (this.currentTokenEquals('[')) {
            this.doSelectorOptions(ndi);
        }
        if (this.currentTokenEquals(')')) {
            this.nextToken();
        } else {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
    }

    private void doChildNodeDefaultType(ExtendedNodeDefinition ndi) throws ParseException, IOException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        ndi.setDefaultPrimaryType(this.currentToken);
        this.nextToken();
    }

    private void doChildNodeAttributes(ExtendedNodeDefinition ndi, ExtendedNodeType ntd) throws ParseException, IOException {
        while (this.currentTokenEquals(LexerLegacy.ATTRIBUTE)) {
            if (this.currentTokenEquals(LexerLegacy.PRIMARY)) {
                ntd.setPrimaryItemName(ndi.getName());
            } else if (this.currentTokenEquals(LexerLegacy.AUTOCREATED)) {
                ndi.setAutoCreated(true);
            } else if (this.currentTokenEquals(LexerLegacy.MANDATORY)) {
                ndi.setMandatory(true);
            } else if (this.currentTokenEquals(LexerLegacy.HIDDEN)) {
                ndi.setHidden(true);
            } else if (this.currentTokenEquals(LexerLegacy.PROTECTED)) {
                ndi.setProtected(true);
            } else if (this.currentTokenEquals(LexerLegacy.MULTIPLE)) {
                ndi.setAllowsSameNameSiblings(true);
            } else if (this.currentTokenEquals(LexerLegacy.FULLTEXTSEARCHABLE)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                }
            } else if (this.currentTokenEquals(LexerLegacy.COPY)) {
                ndi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(LexerLegacy.VERSION)) {
                ndi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(LexerLegacy.INITIALIZE)) {
                ndi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(LexerLegacy.COMPUTE)) {
                ndi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(LexerLegacy.IGNORE)) {
                ndi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(LexerLegacy.ABORT)) {
                ndi.setOnParentVersion(6);
            } else if (this.currentTokenEquals(LexerLegacy.WORKFLOW)) {
                this.nextToken();
                if (this.currentTokenEquals('=')) {
                    this.nextToken();
                    ndi.setWorkflow(this.currentToken);
                } else {
                    this.lexer.fail("Invalid value for workflow " + this.currentToken);
                }
            }
            this.nextToken();
        }
    }

    private void doSelectorOptions(ExtendedItemDefinition pdi) throws ParseException, IOException {
        this.nextToken();
        HashMap<String, String> options = new HashMap<String, String>();
        while (true) {
            String key = this.currentToken;
            String value = "";
            this.nextToken();
            if (this.currentTokenEquals('=')) {
                this.nextToken();
                value = this.currentToken;
                this.nextToken();
            }
            if (key.equals("addListMixin") || key.equals("addMixin") || key.equals("availableTypes")) {
                for (String s : Patterns.COMMA.split(value)) {
                    try {
                        this.registry.getNodeType(s);
                    }
                    catch (NoSuchNodeTypeException e) {
                        this.lexer.fail("Cannot find type : " + s);
                    }
                }
            }
            options.put(key, value);
            if (this.currentTokenEquals(']')) break;
            if (!this.currentTokenEquals(',')) {
                this.lexer.fail("Missing ']' delimiter");
            }
            this.nextToken();
        }
        this.nextToken();
        pdi.setSelectorOptions(options);
    }

    protected void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    protected boolean currentTokenEquals(String[] s) {
        for (String e : s) {
            if (!this.currentToken.equals(e)) continue;
            return true;
        }
        return false;
    }

    protected boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    protected boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }

    protected Name parseName(String name) throws ParseException {
        Name res = new Name(name, this.registry.getNamespaces());
        if (!StringUtils.isEmpty((String)res.getPrefix()) && res.getUri() == null) {
            this.lexer.fail("Cannot parse name");
        }
        return res;
    }
}

