/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class NodeTypeRegistry
implements NodeTypeManager {
    private static final Logger logger = LoggerFactory.getLogger(NodeTypeRegistry.class);
    private final Map<Name, ExtendedNodeType> nodetypes = new LinkedHashMap<Name, ExtendedNodeType>();
    private final BidiMap namespaces = new DualHashBidiMap();
    private final Map<String, List<Resource>> files = new ListOrderedMap();
    private final Map<ExtendedNodeType, List<ExtendedNodeType>> extensionsMixin = new HashMap<ExtendedNodeType, List<ExtendedNodeType>>();
    private final Map<ExtendedNodeType, Set<ExtendedNodeType>> mixinExtensions = new HashMap<ExtendedNodeType, Set<ExtendedNodeType>>();
    private final Map<String, Set<ExtendedItemDefinition>> typedItems = new HashMap<String, Set<ExtendedItemDefinition>>();
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Lock readLock = this.readWriteLock.readLock();
    private Lock writeLock = this.readWriteLock.writeLock();

    public static NodeTypeRegistry getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLabels() {
        this.writeLock.lock();
        try {
            for (ExtendedNodeType extendedNodeType : this.nodetypes.values()) {
                extendedNodeType.clearLabels();
            }
            for (Set set : this.typedItems.values()) {
                for (ExtendedItemDefinition item : set) {
                    item.clearLabels();
                    item.getDeclaringNodeType().clearLabels();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static Map<String, File> getSystemDefinitionsFiles() {
        LinkedHashMap<String, File> res = new LinkedHashMap<String, File>();
        String cnddir = SettingsBean.getInstance().getJahiaEtcDiskPath() + "/repository/nodetypes";
        File f = new File(cnddir);
        File[] files = f.listFiles();
        if (files != null) {
            TreeSet<File> cndfiles = new TreeSet<File>(Arrays.asList(files));
            for (File cndfile : cndfiles) {
                res.put("system-" + Patterns.DASH.split(cndfile.getName())[1], cndfile);
            }
        }
        return res;
    }

    @Deprecated
    public void addDefinitionsFile(Resource resource, String systemId, ModuleVersion version) throws IOException, ParseException, RepositoryException {
        this.addDefinitionsFile(Collections.singletonList(resource), systemId);
    }

    public void addDefinitionsFile(Resource resource, String systemId) throws IOException, ParseException, RepositoryException {
        this.addDefinitionsFile(Collections.singletonList(resource), systemId);
    }

    @Deprecated
    public void addDefinitionsFile(File file, String systemId, ModuleVersion version) throws ParseException, IOException, RepositoryException {
        this.addDefinitionsFile(file == null ? Collections.emptyList() : Collections.singletonList(new FileSystemResource(file)), systemId);
    }

    public void addDefinitionsFile(File file, String systemId) throws ParseException, IOException, RepositoryException {
        this.addDefinitionsFile(file == null ? Collections.emptyList() : Collections.singletonList(new FileSystemResource(file)), systemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitionsFile(List<? extends Resource> resources, String systemId) throws IOException, ParseException, RepositoryException {
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        for (Resource resource : resources) {
            logger.debug("Adding definitions file {} for {}", (Object)resource, (Object)systemId);
            InputStreamReader resourceReader = null;
            try {
                resourceReader = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                JahiaCndReader r = new JahiaCndReader(resourceReader, resource.toString(), systemId, this);
                r.parse();
                types.addAll(r.getNodeTypesList());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)resourceReader);
        }
        this.registerNodeTypes(types);
        if (!this.files.containsKey(systemId)) {
            this.files.put(systemId, new ArrayList());
        }
        for (Resource resource : resources) {
            if (this.files.get(systemId).contains(resource)) continue;
            this.files.get(systemId).add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNodeTypes(List<ExtendedNodeType> nodeTypesList) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException {
        this.writeLock.lock();
        try {
            ArrayList<ExtendedNodeType> previousTypes = new ArrayList<ExtendedNodeType>();
            for (ExtendedNodeType nodeType : nodeTypesList) {
                ExtendedNodeType previous = this.nodetypes.put(nodeType.getNameObject(), nodeType);
                if (previous == null) continue;
                previousTypes.add(previous);
                NodeTypeIterator subtypes = previous.getDeclaredSubtypes();
                while (subtypes.hasNext()) {
                    ExtendedNodeType subType = (ExtendedNodeType)subtypes.next();
                    if (StringUtils.equals((String)subType.getSystemId(), (String)previous.getSystemId())) continue;
                    nodeType.addSubType(subType);
                }
            }
            for (ExtendedNodeType type : nodeTypesList) {
                try {
                    type.validate();
                    if (type.getPrefix().equals("nt") || type.isMixin() || type.isNodeType("mix:referenceable")) continue;
                    int length = type.getDeclaredSupertypeNames().length;
                    String[] newTypes = new String[length + 1];
                    System.arraycopy(type.getDeclaredSupertypeNames(), 0, newTypes, 0, length);
                    newTypes[length] = "mix:referenceable";
                    type.setDeclaredSupertypes(newTypes);
                    type.validate();
                }
                catch (NoSuchNodeTypeException e) {
                    logger.error("Cannot validate type", (Throwable)e);
                    this.handleError(nodeTypesList, previousTypes);
                    throw e;
                }
            }
            for (ExtendedNodeType type : nodeTypesList) {
                try {
                    type.checkConflicts();
                }
                catch (InvalidNodeTypeDefinitionException e) {
                    logger.error("Cannot validate type", (Throwable)e);
                    this.handleError(nodeTypesList, previousTypes);
                    throw e;
                    return;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void handleError(List<ExtendedNodeType> nodeTypesList, List<ExtendedNodeType> previousTypes) {
        for (ExtendedNodeType addedType : nodeTypesList) {
            this.removeNodeType(addedType.getNameObject());
        }
        for (ExtendedNodeType previousType : previousTypes) {
            this.nodetypes.put(previousType.getNameObject(), previousType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtendedNodeType> getDefinitionsFromFile(Resource resource, String systemId) throws ParseException, IOException {
        String ext = resource.getURL().getPath().substring(resource.getURL().getPath().lastIndexOf(46));
        if (ext.equalsIgnoreCase(".cnd")) {
            List<ExtendedNodeType> list;
            InputStreamReader resourceReader = null;
            try {
                resourceReader = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                JahiaCndReader r = new JahiaCndReader(resourceReader, resource.getURL().getPath(), systemId, this);
                r.parse();
                list = r.getNodeTypesList();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)resourceReader);
            return list;
        }
        return Collections.emptyList();
    }

    public List<String> getSystemIds() {
        return new ArrayList<String>(this.files.keySet());
    }

    public List<Resource> getFiles(String systemId) {
        return this.files.get(systemId);
    }

    public ExtendedNodeType getNodeType(String name) throws NoSuchNodeTypeException {
        return this.getNodeType(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedNodeType getNodeType(String name, boolean throwExceptionIfMissing) throws NoSuchNodeTypeException {
        this.readLock.lock();
        try {
            ExtendedNodeType res;
            ExtendedNodeType extendedNodeType = res = StringUtils.isNotEmpty((String)name) ? this.nodetypes.get(new Name(name, (Map<String, String>)this.namespaces)) : null;
            if (res == null && throwExceptionIfMissing) {
                throw new NoSuchNodeTypeException("Unknown type : " + name);
            }
            ExtendedNodeType extendedNodeType2 = res;
            return extendedNodeType2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public JahiaNodeTypeIterator getAllNodeTypes() {
        this.readLock.lock();
        try {
            Collection<ExtendedNodeType> values = this.nodetypes.values();
            JahiaNodeTypeIterator jahiaNodeTypeIterator = new JahiaNodeTypeIterator(values.iterator(), values.size());
            return jahiaNodeTypeIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JahiaNodeTypeIterator getAllNodeTypes(List<String> systemIds) {
        if (systemIds == null || systemIds.isEmpty()) {
            return this.getAllNodeTypes();
        }
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        this.readLock.lock();
        try {
            for (ExtendedNodeType nt : this.nodetypes.values()) {
                if (!systemIds.contains(nt.getSystemId())) continue;
                res.add(nt);
            }
            JahiaNodeTypeIterator jahiaNodeTypeIterator = new JahiaNodeTypeIterator(res.iterator(), res.size());
            return jahiaNodeTypeIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public JahiaNodeTypeIterator getNodeTypes(String systemId) {
        return this.getAllNodeTypes(Collections.singletonList(systemId));
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        return this.getPrimaryNodeTypes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeIterator getPrimaryNodeTypes(List<String> systemIds) throws RepositoryException {
        boolean addAll = systemIds == null || systemIds.isEmpty();
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        this.readLock.lock();
        try {
            for (ExtendedNodeType nt : this.nodetypes.values()) {
                if (nt.isMixin() || !addAll && !systemIds.contains(nt.getSystemId())) continue;
                res.add(nt);
            }
            JahiaNodeTypeIterator jahiaNodeTypeIterator = new JahiaNodeTypeIterator(res.iterator(), res.size());
            return jahiaNodeTypeIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        return this.getMixinNodeTypes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeIterator getMixinNodeTypes(List<String> systemIds) throws RepositoryException {
        boolean addAll = systemIds == null || systemIds.isEmpty();
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        this.readLock.lock();
        try {
            for (ExtendedNodeType nt : this.nodetypes.values()) {
                if (!nt.isMixin() || !addAll && !systemIds.contains(nt.getSystemId())) continue;
                res.add(nt);
            }
            JahiaNodeTypeIterator jahiaNodeTypeIterator = new JahiaNodeTypeIterator(res.iterator(), res.size());
            return jahiaNodeTypeIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeType(Name name, ExtendedNodeType nodeType) throws NodeTypeExistsException {
        this.readLock.lock();
        try {
            String systemId;
            if (this.nodetypes.containsKey(name) && !(systemId = this.nodetypes.get(name).getSystemId()).equals(nodeType.getSystemId())) {
                throw new NodeTypeExistsException("Node type '" + name + "' already defined with a different systemId (existing: '" + systemId + "', provided: '" + nodeType.getSystemId() + "' with name: '" + nodeType.getName() + "')");
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.nodetypes.put(name, nodeType);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMixinExtension(ExtendedNodeType mixin, ExtendedNodeType baseType) {
        this.readLock.lock();
        try {
            if (!this.mixinExtensions.containsKey(baseType)) {
                this.readLock.unlock();
                this.writeLock.lock();
                this.mixinExtensions.put(baseType, new HashSet());
                this.writeLock.unlock();
                this.readLock.lock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.mixinExtensions.get(baseType).remove(mixin);
            this.mixinExtensions.get(baseType).add(mixin);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtendedNodeType> addMixinExtensions(ExtendedNodeType mixin, List<String> mixinExtendNames) throws NoSuchNodeTypeException {
        ArrayList<ExtendedNodeType> newMixinExtend = new ArrayList<ExtendedNodeType>();
        for (String s : mixinExtendNames) {
            ExtendedNodeType type = this.getNodeType(s);
            this.addMixinExtension(mixin, type);
            newMixinExtend.add(type);
        }
        this.readLock.lock();
        try {
            if (this.extensionsMixin.containsKey(mixin)) {
                HashSet extendedNodeTypes = new HashSet(this.extensionsMixin.get(mixin));
                extendedNodeTypes.removeAll(newMixinExtend);
                if (extendedNodeTypes.size() > 0) {
                    this.readLock.unlock();
                    for (ExtendedNodeType extendedNodeType : extendedNodeTypes) {
                        this.writeLock.lock();
                        this.mixinExtensions.get(extendedNodeType).remove(mixin);
                        this.writeLock.unlock();
                    }
                    this.readLock.lock();
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.extensionsMixin.put(mixin, newMixinExtend);
        }
        finally {
            this.writeLock.unlock();
        }
        return newMixinExtend;
    }

    public Map<ExtendedNodeType, Set<ExtendedNodeType>> getMixinExtensions() {
        return this.mixinExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedItem(ExtendedItemDefinition itemDef) {
        String type = itemDef.getItemType();
        this.readLock.lock();
        try {
            if (!this.typedItems.containsKey(type)) {
                this.readLock.unlock();
                this.writeLock.lock();
                this.typedItems.put(type, new HashSet());
                this.writeLock.unlock();
                this.readLock.lock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.typedItems.get(type).add(itemDef);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<String, Set<ExtendedItemDefinition>> getTypedItems() {
        return this.typedItems;
    }

    public void unregisterNodeType(Name name) {
        this.writeLock.lock();
        try {
            this.removeNodeType(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeNodeType(Name name) {
        ExtendedNodeType ent = this.nodetypes.remove(name);
        if (ent != null) {
            for (ExtendedNodeType type : ent.getDeclaredSupertypes()) {
                if (type == null) continue;
                type.removeSubType(ent);
            }
            for (ExtendedNodeType type : ent.getMixinExtends()) {
                if (type == null || !this.mixinExtensions.containsKey(type)) continue;
                this.mixinExtensions.get(type).remove(ent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNodeTypes(String systemId) {
        this.readLock.lock();
        try {
            for (Name n : new HashSet<Name>(this.nodetypes.keySet())) {
                ExtendedNodeType nt = this.nodetypes.get(n);
                if (!systemId.equals(nt.getSystemId())) continue;
                this.readLock.unlock();
                this.unregisterNodeType(n);
                this.readLock.lock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.files.remove(systemId);
    }

    public boolean hasNodeType(String name) {
        return this.nodetypes.get(new Name(name, (Map<String, String>)this.namespaces)) != null;
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNodeType(String name) throws ConstraintViolationException {
        Name n = new Name(name, (Map<String, String>)this.namespaces);
        this.readLock.lock();
        if (this.nodetypes.containsKey(n)) {
            try {
                for (ExtendedNodeType type : this.nodetypes.values()) {
                    if (type.getName().equals(name)) continue;
                    for (ExtendedNodeType nt : type.getSupertypes()) {
                        if (!nt.getName().equals(name)) continue;
                        throw new ConstraintViolationException("Cannot unregister node type " + name + " because " + type.getName() + " extends it.");
                    }
                    for (ExtendedNodeDefinition ntd : type.getChildNodeDefinitions()) {
                        if (!Sets.newHashSet((Object[])ntd.getRequiredPrimaryTypeNames()).contains(name)) continue;
                        throw new ConstraintViolationException("Cannot unregister node type " + name + " because a child node definition of " + type.getName() + " requires it.");
                    }
                    for (ExtendedNodeDefinition ntd : type.getUnstructuredChildNodeDefinitions().values()) {
                        if (!Sets.newHashSet((Object[])ntd.getRequiredPrimaryTypeNames()).contains(name)) continue;
                        throw new ConstraintViolationException("Cannot unregister node type " + name + " because a child node definition of " + type.getName() + " requires it.");
                    }
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                this.removeNodeType(n);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.readLock.unlock();
    }

    public void unregisterNodeTypes(String[] names) throws ConstraintViolationException {
        for (String name : names) {
            this.unregisterNodeType(name);
        }
    }

    public class JahiaNodeTypeIterator
    implements NodeTypeIterator,
    Iterable<ExtendedNodeType> {
        private long size;
        private long pos = 0L;
        private final Iterator<ExtendedNodeType> iterator;

        JahiaNodeTypeIterator(Iterator<ExtendedNodeType> it, long size) {
            this.iterator = it;
            this.size = size;
        }

        public NodeType nextNodeType() {
            ++this.pos;
            return this.iterator.next();
        }

        public void skip(long l) {
            if (this.pos + l + 1L > this.size) {
                throw new NoSuchElementException("Tried to skip past " + l + " elements, which with current pos (" + this.pos + ") brings us past total size=" + this.size);
            }
            int i = 0;
            while ((long)i < l) {
                this.next();
                ++i;
            }
        }

        public long getSize() {
            return this.size;
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            ++this.pos;
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
            --this.size;
        }

        @Override
        public Iterator<ExtendedNodeType> iterator() {
            return this;
        }
    }

    private static class Holder {
        static final NodeTypeRegistry INSTANCE = new NodeTypeRegistry();

        private Holder() {
        }
    }
}

