/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.rules.BackgroundAction;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.utils.LanguageCodeConverters;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionJob
extends BackgroundJob {
    public static final String NAME_PREFIX = "ACTION_JOB_";
    private static transient Logger logger = LoggerFactory.getLogger(ActionJob.class);
    public static final String JOB_ACTION_TO_EXECUTE = "actionToExecute";
    public static final String JOB_NODE_UUID = "node";
    public static final String JOB_WORKSPACE = "workspace";

    public static final String getJobGroup(String actionName) {
        return BackgroundJob.getGroupName(ActionJob.class) + "." + actionName;
    }

    public static final String getJobName(String actionName, String nodeIdentifier) {
        return actionName + "-" + nodeIdentifier;
    }

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        block5: {
            try {
                JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
                String actionName = map.getString(JOB_ACTION_TO_EXECUTE);
                BackgroundAction action = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getBackgroundActions().get(actionName);
                if (action != null) {
                    BackgroundAction backgroundAction = action;
                    JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
                    JCRSessionWrapper jcrSessionWrapper = sessionFactory.getCurrentUserSession(map.getString(JOB_WORKSPACE), map.getString("currentLocale") != null ? LanguageCodeConverters.getLocaleFromCode(map.getString("currentLocale")) : null);
                    try {
                        JCRNodeWrapper node = jcrSessionWrapper.getNodeByUUID(map.getString(JOB_NODE_UUID));
                        backgroundAction.executeBackgroundAction(node);
                        break block5;
                    }
                    catch (ItemNotFoundException e) {
                        logger.warn("The node with UUID {} cannot be found in the repository. Skip executing background action.", (Object)map.getString(JOB_NODE_UUID));
                        throw new JobExecutionException((Throwable)e);
                    }
                }
                throw new JobExecutionException("Background action with the name " + actionName + " is not found in the registry. Skip executing action.");
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
        }
    }
}

