/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ModifiedPropertyFact;
import org.jahia.services.content.rules.Updateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedPropertyFact
implements Updateable,
ModifiedPropertyFact {
    private static final Logger logger = LoggerFactory.getLogger(ChangedPropertyFact.class);
    private String path;
    private JCRPropertyWrapper property;
    private String nodePath;
    private String name;
    private Object value;
    private AddedNodeFact nodeWrapper;
    private String operationType;

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, JCRPropertyWrapper property) throws RepositoryException {
        this.nodeWrapper = nodeWrapper;
        this.property = property;
        this.path = property.getPath();
        this.operationType = nodeWrapper.getOperationType();
    }

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, String name, Object o, KnowledgeHelper drools) throws RepositoryException {
        this(nodeWrapper, name, o, drools, true);
    }

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, String name, Object o, KnowledgeHelper drools, boolean overrideIfExisting) throws RepositoryException {
        if (nodeWrapper == null) {
            return;
        }
        this.nodeWrapper = nodeWrapper;
        JCRNodeWrapper node = nodeWrapper.getNode();
        this.nodePath = nodeWrapper.getPath();
        this.name = name;
        this.value = o;
        if (node == null || AddedNodeFact.isLocked(node)) {
            logger.debug("Node is locked, delay property update to later");
            List list = (List)drools.getWorkingMemory().getGlobal("delayedUpdates");
            list.add(this);
        } else {
            this.setProperty(node, name, o, overrideIfExisting);
        }
        this.operationType = nodeWrapper.getOperationType();
    }

    @Override
    public void doUpdate(JCRSessionWrapper s, List<Updateable> delayedUpdates) throws RepositoryException {
        try {
            JCRNodeWrapper node = s.getNode(this.nodePath);
            if (AddedNodeFact.isLocked(node)) {
                logger.debug("Node is still locked, delay property update to later");
                delayedUpdates.add(this);
            } else {
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                this.setProperty(node, this.name, this.value, true);
            }
        }
        catch (PathNotFoundException e) {
            logger.warn("Node does not exist " + this.nodePath);
        }
    }

    private ExtendedPropertyDefinition getPropertyDefinition(Node node, String name) throws RepositoryException {
        HashMap<String, ExtendedPropertyDefinition> defs = new HashMap<String, ExtendedPropertyDefinition>();
        NodeTypeRegistry reg = NodeTypeRegistry.getInstance();
        ExtendedPropertyDefinition propDef = null;
        try {
            ExtendedNodeType nt = reg.getNodeType(node.getPrimaryNodeType().getName());
            defs.putAll(nt.getPropertyDefinitionsAsMap());
            NodeType[] p = node.getMixinNodeTypes();
            for (int i = 0; i < p.length; ++i) {
                defs.putAll(reg.getNodeType(p[i].getName()).getPropertyDefinitionsAsMap());
            }
            propDef = (ExtendedPropertyDefinition)defs.get(name);
        }
        catch (NoSuchNodeTypeException e) {
            logger.debug("Nodetype not supported", (Throwable)e);
        }
        return propDef;
    }

    /*
     * Exception decompiling
     */
    protected void setProperty(JCRNodeWrapper node, String name, Object objectValue, boolean overrideIfExisting) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Value createValue(Object objectValue, ExtendedPropertyDefinition propDef, ValueFactory factory) {
        if (objectValue instanceof String && propDef.getSelector() == 13) {
            try {
                return factory.createValue(Category.getCategoryPath((String)objectValue));
            }
            catch (Exception e) {
                logger.warn("Can't get category " + objectValue + ", cause " + e.getMessage());
                return null;
            }
        }
        return JCRContentUtils.createValue(objectValue, factory);
    }

    @Override
    public String getName() throws RepositoryException {
        if (this.property != null) {
            return this.property.getName();
        }
        return null;
    }

    public String getStringValue() throws RepositoryException {
        if (this.property != null) {
            if (this.property.getDefinition().isMultiple()) {
                return this.getStringValues().toString();
            }
            JCRValueWrapper v = this.property.getValue();
            if (v.getType() == 10 || v.getType() == 9) {
                JCRNodeWrapper node = v.getNode();
                if (node != null) {
                    return node.getPath();
                }
            } else {
                return v.getString();
            }
        }
        return null;
    }

    public List<String> getStringValues() throws RepositoryException {
        ArrayList<String> r = new ArrayList<String>();
        if (this.property != null && this.property.getDefinition().isMultiple()) {
            JCRValueWrapper[] vs;
            for (JCRValueWrapper v : vs = this.property.getValues()) {
                if (v.getType() == 10 || v.getType() == 9) {
                    JCRNodeWrapper node = v.getNode();
                    if (node == null) continue;
                    r.add(node.getPath());
                    continue;
                }
                r.add(v.getString());
            }
        } else {
            r.add(this.getStringValue());
        }
        return r;
    }

    public AddedNodeFact getNodeValue() throws RepositoryException {
        if (this.property != null) {
            if (this.property.getDefinition().isMultiple()) {
                return null;
            }
            JCRValueWrapper v = this.property.getValue();
            if (v.getType() == 10 || v.getType() == 9) {
                JCRNodeWrapper node = v.getNode();
                if (node != null) {
                    return new AddedNodeFact(node);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public Object getValues() throws RepositoryException {
        if (this.property != null) {
            return this.property.getValues();
        }
        return null;
    }

    public Object getValue() throws RepositoryException {
        if (this.property != null) {
            return this.property.getValue();
        }
        return null;
    }

    public int getType() throws RepositoryException {
        if (this.property != null) {
            return this.property.getType();
        }
        return 0;
    }

    public String getLanguage() throws RepositoryException {
        if (this.property != null) {
            return this.property.getLocale();
        }
        return null;
    }

    @Override
    public AddedNodeFact getNode() {
        return this.nodeWrapper;
    }

    JCRPropertyWrapper getProperty() {
        return this.property;
    }

    public String toString() {
        return this.path;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public List<String> getInstalledModules() {
        return this.nodeWrapper.getInstalledModules();
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        return this.getNode().getWorkspace();
    }

    @Override
    public JCRSessionWrapper getSession() throws RepositoryException {
        return this.getNode().getSession();
    }

    @Override
    public String getNodeIdentifier() throws RepositoryException {
        return this.getNode().getIdentifier();
    }

    @Override
    public String getNodeType() throws RepositoryException {
        return this.getNode().getNodeType();
    }
}

