/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;
import org.jahia.settings.SettingsBean;
import org.kie.api.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageService {
    private static final Logger logger = LoggerFactory.getLogger(ImageService.class);
    private JahiaImageService imageService;
    private static File contentTempFolder;

    public void setImageService(JahiaImageService imageService) {
        this.imageService = imageService;
    }

    private ImageService() {
    }

    public static ImageService getInstance() {
        return Holder.INSTANCE;
    }

    private Image getImageWrapper(final AddedNodeFact imageNode, KnowledgeHelper drools) throws Exception {
        Iterator it = drools.getWorkingMemory().iterateObjects(new ObjectFilter(){

            public boolean accept(Object o) {
                if (o instanceof Image) {
                    try {
                        return ((Image)o).getPath().equals(imageNode.getPath());
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                return false;
            }
        });
        if (it.hasNext()) {
            return (Image)it.next();
        }
        Image iw = this.imageService.getImage(imageNode.getNode());
        if (iw == null) {
            return null;
        }
        drools.insertLogical((Object)iw);
        return iw;
    }

    public void addThumbnail(AddedNodeFact imageNode, String name, int size, KnowledgeHelper drools) throws Exception {
        this.addThumbnail(imageNode, name, size, false, drools);
    }

    public void addThumbnail(AddedNodeFact imageNode, String name, int size, boolean square, KnowledgeHelper drools) throws Exception {
        long timer = System.currentTimeMillis();
        if (imageNode.getNode().hasNode(name)) {
            JCRNodeWrapper node = imageNode.getNode().getNode(name);
            Calendar thumbDate = node.getProperty("jcr:lastModified").getDate();
            Calendar contentDate = imageNode.getNode().getNode("jcr:content").getProperty("jcr:lastModified").getDate();
            if (contentDate.after(thumbDate)) {
                AddedNodeFact thumbNode = new AddedNodeFact(node);
                File f = this.getThumbFile(imageNode, size, square, drools);
                if (f == null) {
                    return;
                }
                drools.insert((Object)new ChangedPropertyFact(thumbNode, "jcr:data", f, drools));
                drools.insert((Object)new ChangedPropertyFact(thumbNode, "jcr:lastModified", new GregorianCalendar(), drools));
            }
        } else {
            File f = this.getThumbFile(imageNode, size, square, drools);
            if (f == null) {
                return;
            }
            AddedNodeFact thumbNode = new AddedNodeFact(imageNode, name, "jnt:resource", drools);
            if (thumbNode.getNode() != null) {
                drools.insert((Object)thumbNode);
                drools.insert((Object)new ChangedPropertyFact(thumbNode, "jcr:data", f, drools));
                drools.insert((Object)new ChangedPropertyFact(thumbNode, "jcr:mimeType", imageNode.getMimeType(), drools));
                drools.insert((Object)new ChangedPropertyFact(thumbNode, "jcr:lastModified", new GregorianCalendar(), drools));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}px thumbnail for node {} created in {} ms", new Object[]{size, imageNode.getNode().getPath(), System.currentTimeMillis() - timer});
        }
    }

    public void addThumbnail(ChangedPropertyFact propertyWrapper, String name, int size, KnowledgeHelper drools) throws Exception {
        JCRPropertyWrapper property = propertyWrapper.getProperty();
        JCRSessionWrapper session = property.getSession();
        JCRNodeWrapper node = session.getNodeByIdentifier(property.getString());
        this.addThumbnail(new AddedNodeFact(node), name, size, drools);
    }

    public void addSquareThumbnail(ChangedPropertyFact propertyWrapper, String name, int size, KnowledgeHelper drools) throws Exception {
        JCRPropertyWrapper property = propertyWrapper.getProperty();
        JCRSessionWrapper session = property.getSession();
        JCRNodeWrapper node = session.getNodeByIdentifier(property.getString());
        this.addThumbnail(new AddedNodeFact(node), name, size, true, drools);
    }

    protected boolean isSmallerThan(JCRNodeWrapper node, int size) {
        long width = 0L;
        long height = 0L;
        try {
            width = node.getProperty("j:width").getLong();
            height = node.getProperty("j:height").getLong();
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Error reading j:width/j:height properties on node " + node.getPath(), (Throwable)e);
            }
            logger.warn("Error reading j:width/j:height properties on node " + node.getPath() + ". Casue: " + e.getMessage());
        }
        return width > 0L && height > 0L && width <= (long)size && height <= (long)size;
    }

    protected File getThumbFile(AddedNodeFact imageNode, int size, boolean square, KnowledgeHelper drools) throws Exception {
        String fileExtension = FilenameUtils.getExtension((String)imageNode.getName());
        if (!square && this.isSmallerThan(imageNode.getNode(), size)) {
            File f = File.createTempFile("thumb", StringUtils.isNotEmpty((String)fileExtension) ? "." + fileExtension : null, contentTempFolder);
            JCRContentUtils.downloadFileContent(imageNode.getNode(), f);
            f.deleteOnExit();
            return f;
        }
        Image iw = this.getImageWrapper(imageNode, drools);
        if (iw == null) {
            return null;
        }
        File f = File.createTempFile("thumb", StringUtils.isNotEmpty((String)fileExtension) ? "." + fileExtension : null, contentTempFolder);
        if (this.imageService.createThumb(iw, f, size, square)) {
            f.deleteOnExit();
            return f;
        }
        f.deleteOnExit();
        return null;
    }

    public void setHeight(AddedNodeFact imageNode, String propertyName, KnowledgeHelper drools) throws Exception {
        Image iw = this.getImageWrapper(imageNode, drools);
        if (iw == null) {
            return;
        }
        int height = this.imageService.getHeight(iw);
        if (height == -1) {
            return;
        }
        drools.insert((Object)new ChangedPropertyFact(imageNode, propertyName, height, drools));
    }

    public void setWidth(AddedNodeFact imageNode, String propertyName, KnowledgeHelper drools) throws Exception {
        Image iw = this.getImageWrapper(imageNode, drools);
        if (iw == null) {
            return;
        }
        int width = this.imageService.getWidth(iw);
        if (width == -1) {
            return;
        }
        drools.insert((Object)new ChangedPropertyFact(imageNode, propertyName, width, drools));
    }

    public void disposeImageForNode(final AddedNodeFact imageNode, KnowledgeHelper drools) throws Exception {
        Iterator it = drools.getWorkingMemory().iterateObjects(new ObjectFilter(){

            public boolean accept(Object o) {
                if (o instanceof Image) {
                    try {
                        return ((Image)o).getPath().equals(imageNode.getPath());
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                return false;
            }
        });
        while (it.hasNext()) {
            Image img = (Image)it.next();
            drools.retract((Object)img);
            img.dispose();
            img = null;
        }
    }

    private static class Holder {
        static final ImageService INSTANCE = new ImageService();

        private Holder() {
        }

        static {
            contentTempFolder = new File(SettingsBean.getInstance().getTmpContentDiskPath());
            if (!contentTempFolder.exists()) {
                contentTempFolder.mkdirs();
            }
        }
    }
}

