/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.events;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.PrivilegeRecord;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.events.FilteredEventIterator;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.properties.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalEventReader {
    private static final String LAST_PROCESSED_JOURNAL_REVISION_PROPERTY = "lastProcessedJournalRevision";
    private static final String LAST_PROCESSED_JOURNAL_REVISION_FOLDER = "journal-event-reader";
    private static final String LAST_PROCESSED_JOURNAL_REVISION_FILE = "org.jahia.utils.journal-event-reader.properties";
    private static final Logger logger = LoggerFactory.getLogger(JournalEventReader.class);
    private SettingsBean settingsBean;
    private String lastProcessedRevisionFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChangeLogRecord> getChangeLogRecords(long revision, final String workspace) {
        ClusterNode cn = SpringJackrabbitRepository.getInstance().getClusterNode();
        if (cn == null) {
            return Collections.emptyList();
        }
        logger.info("Getting journal change log records starting with revision {} for workspace {}", (Object)revision, (Object)workspace);
        Journal journal = cn.getJournal();
        final LinkedList<ChangeLogRecord> changeLogRecords = new LinkedList<ChangeLogRecord>();
        ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();
        try (RecordIterator records = null;){
            records = journal.getRecords(revision);
            while (records.hasNext()) {
                Record record = records.nextRecord();
                ClusterRecord r = null;
                try {
                    r = deserializer.deserialize(record);
                }
                catch (JournalException e) {
                    logger.error("Unable to read revision '" + record.getRevision() + "'.", (Throwable)e);
                }
                if (r == null) continue;
                r.process(new ClusterRecordProcessor(){

                    public void process(ChangeLogRecord record) {
                        String eventW = record.getWorkspace();
                        if (eventW != null ? eventW.equals(workspace) : workspace == null) {
                            changeLogRecords.add(record);
                        }
                    }

                    public void process(LockRecord record) {
                    }

                    public void process(NamespaceRecord record) {
                    }

                    public void process(NodeTypeRecord record) {
                    }

                    public void process(PrivilegeRecord record) {
                    }

                    public void process(WorkspaceRecord record) {
                    }
                });
            }
            logger.info("Found {} journal change log records for workspace {}", (Object)changeLogRecords.size(), (Object)workspace);
        }
        return changeLogRecords;
    }

    private EventIterator getEventIterator(SessionImpl session, ChangeLogRecord record, int eventTypes) {
        return new FilteredEventIterator(session, record.getEvents().iterator(), record.getTimestamp(), record.getUserData(), eventTypes);
    }

    private long readStartRevision(String key) {
        long startRevision = 0L;
        String value = new PropertiesManager(this.lastProcessedRevisionFilePath).getProperty(this.getPropertyKey(key));
        if (StringUtils.isNotEmpty((String)value)) {
            startRevision = Long.parseLong(value.trim());
        }
        return startRevision;
    }

    private String getPropertyKey(String key) {
        return "lastProcessedJournalRevision." + key;
    }

    private boolean isEnabled() {
        return this.settingsBean.isClusterActivated() && this.settingsBean.isProcessingServer();
    }

    public void rememberLastProcessedJournalRevision(String key) {
        if (!this.isEnabled()) {
            return;
        }
        ClusterNode cn = SpringJackrabbitRepository.getInstance().getClusterNode();
        if (cn != null) {
            String revision = String.valueOf(cn.getRevision());
            PropertiesManager propManager = new PropertiesManager(this.lastProcessedRevisionFilePath);
            String propertyKey = this.getPropertyKey(key);
            if (!StringUtils.equals((String)propManager.getProperty(propertyKey), (String)revision)) {
                propManager.setProperty(propertyKey, String.valueOf(revision));
                propManager.storeProperties();
                logger.info("Remembered last processed journal revision as {}", (Object)revision);
            }
        }
    }

    public void replayMissedEvents(final DefaultEventListener listener, String key) {
        if (!this.isEnabled()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        final long startRevision = this.readStartRevision(key);
        if (startRevision <= 0L) {
            return;
        }
        logger.info("Checking for missed JCR events to be replayed for listener {} starting from revision {}", (Object)listener, (Object)startRevision);
        try {
            Integer processedRecords = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Integer>(){

                @Override
                public Integer doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    return JournalEventReader.this.replayMissedEvents(startRevision, listener, session);
                }
            });
            if (processedRecords != null && processedRecords > 0) {
                logger.info("Done replaying {} missed JCR journal revisions for listener {} in {} ms", new Object[]{processedRecords, listener, System.currentTimeMillis() - startTime});
            } else {
                logger.info("Done checking missed JCR events for listener {} in {} ms. No records to replay were found.", (Object)listener, (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            logger.error("Error replaying missed JCR events by listener " + listener, (Throwable)e);
        }
    }

    private int replayMissedEvents(long startRevision, DefaultEventListener listener, JCRSessionWrapper session) throws RepositoryException {
        List<ChangeLogRecord> changeLogRecords = this.getChangeLogRecords(startRevision, StringUtils.defaultString((String)listener.getWorkspace(), (String)"default"));
        if (changeLogRecords.isEmpty()) {
            return 0;
        }
        SessionImpl jrSession = (SessionImpl)session.getRootNode().getRealNode().getSession();
        int processedRecords = 0;
        for (ChangeLogRecord r : changeLogRecords) {
            EventIterator evtIterator = this.getEventIterator(jrSession, r, listener.getEventTypes());
            ++processedRecords;
            try {
                listener.onEvent(evtIterator);
                logger.info("Processed {} event(s) (revision: {}) by listener {}", new Object[]{evtIterator.getSize(), r.getRevision(), listener});
            }
            catch (Exception e) {
                logger.error("Error replaying JCR events (revision: " + r.getRevision() + ") by listener " + listener, (Throwable)e);
            }
        }
        return processedRecords;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
        this.lastProcessedRevisionFilePath = new File(new File(settingsBean.getJahiaVarDiskPath(), LAST_PROCESSED_JOURNAL_REVISION_FOLDER), LAST_PROCESSED_JOURNAL_REVISION_FILE).getPath();
    }
}

