/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.image.AbstractImageService;
import org.jahia.services.image.Image;
import org.jahia.services.image.ImageJImage;
import org.jahia.services.image.JahiaImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageJImageService
extends AbstractImageService {
    private static final Logger logger = LoggerFactory.getLogger(ImageJImageService.class);

    private ImageJImageService() {
    }

    public void init() {
    }

    public static ImageJImageService getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage(JCRNodeWrapper node) throws IOException, RepositoryException {
        int fileType;
        ImagePlus ip;
        BufferedOutputStream os;
        File tmp;
        block7: {
            Image image;
            tmp = null;
            os = null;
            try {
                String fileExtension = FilenameUtils.getExtension((String)node.getName());
                fileExtension = fileExtension != null && !"".equals(fileExtension) ? fileExtension + "." + fileExtension : null;
                tmp = File.createTempFile("image", fileExtension);
                JCRNodeWrapper contentNode = node.getNode("jcr:content");
                os = new BufferedOutputStream(new FileOutputStream(tmp));
                InputStream is = contentNode.getProperty("jcr:data").getBinary().getStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly((InputStream)is);
                }
                ip = null;
                Opener op = new Opener();
                fileType = op.getFileType(tmp.getPath());
                ip = op.openImage(tmp.getPath());
                if (ip != null) break block7;
                logger.error("Couldn't open file " + tmp.getPath() + " for node " + node.getPath() + " with ImageJ !");
                image = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                FileUtils.deleteQuietly(tmp);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            FileUtils.deleteQuietly((File)tmp);
            return image;
        }
        ImageJImage imageJImage = new ImageJImage(node.getPath(), ip, fileType);
        IOUtils.closeQuietly((OutputStream)os);
        FileUtils.deleteQuietly((File)tmp);
        return imageJImage;
    }

    @Override
    public int getHeight(Image i) {
        ImagePlus ip = ((ImageJImage)i).getImagePlus();
        if (ip != null) {
            return ip.getHeight();
        }
        return -1;
    }

    @Override
    public int getWidth(Image i) {
        ImagePlus ip = ((ImageJImage)i).getImagePlus();
        if (ip != null) {
            return ip.getWidth();
        }
        return -1;
    }

    @Override
    public boolean cropImage(Image i, File outputFile, int top, int left, int width, int height) throws IOException {
        ImageJImage imageJImage = (ImageJImage)i;
        ImagePlus ip = imageJImage.getImagePlus();
        ImageProcessor processor = ip.getProcessor();
        processor.setRoi(left, top, width, height);
        processor = processor.crop();
        ip.setProcessor(null, processor);
        return ImageJImageService.save(imageJImage.getImageType(), ip, outputFile);
    }

    @Override
    public boolean rotateImage(Image i, File outputFile, boolean clockwise) throws IOException {
        ImageJImage imageJImage = (ImageJImage)i;
        ImagePlus ip = imageJImage.getImagePlus();
        ImageProcessor processor = ip.getProcessor();
        processor = clockwise ? processor.rotateRight() : processor.rotateLeft();
        ip.setProcessor(null, processor);
        return ImageJImageService.save(imageJImage.getImageType(), ip, outputFile);
    }

    @Override
    public boolean resizeImage(Image i, File outputFile, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        ImageJImage imageJImage = (ImageJImage)i;
        ImagePlus ip = imageJImage.getImagePlus();
        this.resizeImage(ip, width, height, resizeType);
        return ImageJImageService.save(imageJImage.getImageType(), ip, outputFile);
    }

    @Override
    public BufferedImage resizeImage(BufferedImage image, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        ImagePlus ip = new ImagePlus(null, (java.awt.Image)image);
        this.resizeImage(ip, width, height, resizeType);
        return ip.getBufferedImage();
    }

    protected void resizeImage(ImagePlus ip, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        ImageProcessor processor = ip.getProcessor();
        int originalWidth = ip.getWidth();
        int originalHeight = ip.getHeight();
        AbstractImageService.ResizeCoords resizeCoords = this.getResizeCoords(resizeType, originalWidth, originalHeight, width, height);
        if (JahiaImageService.ResizeType.SCALE_TO_FILL.equals((Object)resizeType)) {
            processor.setInterpolationMethod(2);
            processor = processor.resize(width, height, true);
        } else if (JahiaImageService.ResizeType.ADJUST_SIZE.equals((Object)resizeType)) {
            width = resizeCoords.getTargetWidth();
            height = resizeCoords.getTargetHeight();
            processor.setInterpolationMethod(2);
            processor = processor.resize(width, height, true);
        } else if (JahiaImageService.ResizeType.ASPECT_FILL.equals((Object)resizeType)) {
            processor.setRoi(resizeCoords.getSourceStartPosX(), resizeCoords.getSourceStartPosY(), resizeCoords.getSourceWidth(), resizeCoords.getSourceHeight());
            processor = processor.crop();
            processor.setInterpolationMethod(2);
            processor = processor.resize(resizeCoords.getTargetWidth(), resizeCoords.getTargetHeight(), true);
        } else if (JahiaImageService.ResizeType.ASPECT_FIT.equals((Object)resizeType)) {
            processor.setInterpolationMethod(2);
            processor = processor.resize(resizeCoords.getTargetWidth(), resizeCoords.getTargetHeight(), true);
            ImageProcessor newProcessor = processor.createProcessor(width, height);
            newProcessor.copyBits(processor, resizeCoords.getTargetStartPosX(), resizeCoords.getTargetStartPosY(), 3);
            processor = newProcessor;
        }
        ip.setProcessor(null, processor);
    }

    protected static boolean save(int type, ImagePlus ip, File outputFile) {
        switch (type) {
            case 1: {
                return new FileSaver(ip).saveAsTiff(outputFile.getPath());
            }
            case 6: {
                return new FileSaver(ip).saveAsGif(outputFile.getPath());
            }
            case 5: {
                return new FileSaver(ip).saveAsJpeg(outputFile.getPath());
            }
            case 12: {
                return new FileSaver(ip).saveAsText(outputFile.getPath());
            }
            case 7: {
                return new FileSaver(ip).saveAsLut(outputFile.getPath());
            }
            case 9: {
                return new FileSaver(ip).saveAsZip(outputFile.getPath());
            }
            case 8: {
                return new FileSaver(ip).saveAsBmp(outputFile.getPath());
            }
            case 13: {
                ImagePlus tempImage = WindowManager.getTempCurrentImage();
                WindowManager.setTempCurrentImage((ImagePlus)ip);
                PlugIn p = null;
                try {
                    p = (PlugIn)Class.forName("ij.plugin.PNG_Writer").newInstance();
                    p.run(outputFile.getPath());
                }
                catch (InstantiationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                WindowManager.setTempCurrentImage((ImagePlus)tempImage);
                return true;
            }
            case 4: {
                return new FileSaver(ip).saveAsPgm(outputFile.getPath());
            }
        }
        return false;
    }

    private static class Holder {
        static final ImageJImageService INSTANCE = new ImageJImageService();

        private Holder() {
        }
    }
}

