/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.utils.i18n.ResourceBundleMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsMapping {
    private static Logger logger = LoggerFactory.getLogger(LegacyImportHandler.class);
    String WORD = "([\\w:#-]+)";
    String WORD_WITH_DOTS = "([\\w:#-.]+)";
    String WORD_WITH_DOTS_AND_SLASHES = "([\\w:#-.//]+)";
    String WORD_WITH_DOTS_SPACES_AND_BRACKETS = "([\\w:#-.\\(\\)\\s//]+)";
    String WS = "\\s*";
    String WS_OR_COMMA = "[\\s,]*";
    String NODETYPE = "\\[" + this.WORD + "\\]";
    String EQ = this.WS + "=" + this.WS;
    String NODETYPE_MAPPING = this.NODETYPE + this.EQ + this.WORD;
    String NODE = this.WORD_WITH_DOTS_AND_SLASHES + this.WS + "(?:\\(" + this.WS + this.WORD + this.WS + "\\))?";
    String NODE_MAPPING = this.WS + "\\+" + this.WS + this.WORD + this.EQ + "(" + this.WORD + "\\|)?" + this.NODE;
    String PROPERTY_MAPPING = this.WS + "-" + this.WS + this.WORD + this.EQ + "(" + this.WORD + "\\|)?" + this.WORD_WITH_DOTS_AND_SLASHES;
    String VALUE_MAPPING = this.WS + this.WORD_WITH_DOTS_SPACES_AND_BRACKETS + this.EQ + this.WORD_WITH_DOTS_SPACES_AND_BRACKETS;
    String PROPS = "(?:\\[((?:" + this.WS_OR_COMMA + "(" + this.WORD + "\\|)?" + this.WORD_WITH_DOTS_AND_SLASHES + this.EQ + this.WORD_WITH_DOTS + this.WS + ")*)\\])";
    String ADD_NODE = "\\{" + this.WS + "addNode" + this.WS + this.NODE + this.WS + this.PROPS + "?" + this.WS + "\\}";
    String ADD_MIXIN = "\\{" + this.WS + "addMixin" + this.WS + this.WORD + this.WS + "\\}";
    String SET_PROPERTY = "\\{" + this.WS + "setProperty" + this.WS + this.PROPS + "?" + this.WS + "\\}";
    Pattern NODETYPE_PATTERN = Pattern.compile(this.NODETYPE_MAPPING);
    Pattern NODE_PATTERN = Pattern.compile(this.NODE_MAPPING);
    Pattern PROPERTY_PATTERN = Pattern.compile(this.PROPERTY_MAPPING);
    Pattern VALUE_PATTERN = Pattern.compile(this.VALUE_MAPPING);
    Pattern ADD_NODE_PATTERN = Pattern.compile(this.ADD_NODE);
    Pattern ADD_MIXIN_PATTERN = Pattern.compile(this.ADD_MIXIN);
    Pattern SET_PROPERTY_PATTERN = Pattern.compile(this.SET_PROPERTY);
    private Map<String, TypeMapping> types = new HashMap<String, TypeMapping>();
    private Map<String, PropertyMapping> metadataProperties = (Map)SpringContextSingleton.getBean("ImportDefinitionsMappingMetadata");

    public void load(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        TypeMapping typeMapping = null;
        NodeMapping nodeMapping = null;
        PropertyMapping propMapping = null;
        Mapping currentMapping = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
            Matcher matcher = this.NODETYPE_PATTERN.matcher(line);
            if (matcher.matches()) {
                typeMapping = new TypeMapping(matcher.group(1), matcher.group(2));
                currentMapping = typeMapping;
                this.types.put(typeMapping.originalName, typeMapping);
                continue;
            }
            matcher = this.NODE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String originalName = matcher.group(1);
                String nodeName = (matcher.group(2) != null ? matcher.group(2) : "") + matcher.group(4);
                String nodeType = matcher.group(5);
                nodeMapping = new NodeMapping(originalName, nodeName, nodeType);
                typeMapping.addNodeMapping(originalName, nodeMapping);
                currentMapping = nodeMapping;
                continue;
            }
            matcher = this.PROPERTY_PATTERN.matcher(line);
            if (matcher.matches()) {
                String mixinType = matcher.group(3);
                propMapping = new PropertyMapping(matcher.group(1), (!StringUtils.isEmpty((String)mixinType) ? mixinType + "|" : "") + matcher.group(4));
                typeMapping.addPropertyMapping(propMapping.originalName, propMapping);
                currentMapping = propMapping;
                continue;
            }
            matcher = this.VALUE_PATTERN.matcher(line);
            if (matcher.matches()) {
                ValueMapping vm = new ValueMapping(StringUtils.trim((String)matcher.group(1)), StringUtils.trim((String)matcher.group(2)));
                propMapping.addValueMapping(vm.originalName, vm);
                continue;
            }
            matcher = this.ADD_NODE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String nodeName = matcher.group(1);
                String nodeType = matcher.group(2);
                Map<String, String> properties = this.createPropertyValueMap(matcher.group(3));
                currentMapping.addAction(new AddNode(nodeName, nodeType, properties));
                continue;
            }
            matcher = this.ADD_MIXIN_PATTERN.matcher(line);
            if (matcher.matches()) {
                currentMapping.addAction(new AddMixin(matcher.group(1)));
                continue;
            }
            matcher = this.SET_PROPERTY_PATTERN.matcher(line);
            if (matcher.matches()) {
                currentMapping.addAction(new SetProperties(this.createPropertyValueMap(matcher.group(1))));
                continue;
            }
            logger.error("Syntax error!! The following line does not match any valid syntax pattern for content mappings: " + line);
        }
    }

    private Map<String, String> createPropertyValueMap(String commaSeperatedPropValues) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (commaSeperatedPropValues != null) {
            for (String propAndValue : StringUtils.split((String)commaSeperatedPropValues, (String)",")) {
                properties.put(StringUtils.substringBefore((String)propAndValue, (String)"=").trim(), StringUtils.substringAfter((String)propAndValue, (String)"=").trim());
            }
        }
        return properties;
    }

    public String getMappedType(ExtendedNodeType type) {
        TypeMapping s = this.types.get(type.getName());
        if (s == null) {
            if (type.isNodeType("jnt:box")) {
                return "jnt:contentList";
            }
            return type.getName();
        }
        if ("jnt:box".equals(s.getNewName())) {
            return "jnt:contentList";
        }
        return s.getNewName();
    }

    public List<String> getMappedNodesForType(ExtendedNodeType type, boolean oldName) {
        TypeMapping s = this.types.get(type.getName());
        if (s == null) {
            return Collections.emptyList();
        }
        return oldName ? new ArrayList<String>(s.nodes.keySet()) : s.getNodeNames();
    }

    public String getMappedItem(ExtendedNodeType type, String name) {
        Mapping n = this.getItemMapping(type, name);
        if (n == null) {
            ExtendedNodeType superType;
            ExtendedNodeType[] extendedNodeTypeArray = type.getSupertypes();
            int n2 = extendedNodeTypeArray.length;
            for (int i = 0; i < n2 && (n = this.getItemMapping(superType = extendedNodeTypeArray[i], name)) == null; ++i) {
            }
        }
        if (n == null) {
            return name;
        }
        return n.getNewName();
    }

    private Mapping getItemMapping(ExtendedNodeType type, String name) {
        TypeMapping s = this.types.get(type.getName());
        Mapping n = null;
        if (s != null && (n = (Mapping)s.nodes.get(name)) == null) {
            n = s.properties.get(name);
        }
        return n;
    }

    public String getMappedNode(ExtendedNodeType type, String name) {
        NodeMapping n = this.getNodeMapping(type, name);
        if (n == null) {
            ExtendedNodeType superType;
            ExtendedNodeType[] extendedNodeTypeArray = type.getSupertypes();
            int n2 = extendedNodeTypeArray.length;
            for (int i = 0; i < n2 && (n = this.getNodeMapping(superType = extendedNodeTypeArray[i], name)) == null; ++i) {
            }
        }
        if (n == null) {
            return name;
        }
        return n.getNewName();
    }

    private NodeMapping getNodeMapping(ExtendedNodeType type, String name) {
        TypeMapping s = this.types.get(type.getName());
        NodeMapping n = null;
        if (s != null) {
            n = s.nodes.get(name);
        }
        return n;
    }

    public String getMappedProperty(ExtendedNodeType type, String name) {
        PropertyMapping n = this.getPropertyMapping(type, name);
        if (n == null) {
            ExtendedNodeType superType;
            ExtendedNodeType[] extendedNodeTypeArray = type.getSupertypes();
            int n2 = extendedNodeTypeArray.length;
            for (int i = 0; i < n2 && (n = this.getPropertyMapping(superType = extendedNodeTypeArray[i], name)) == null; ++i) {
            }
        }
        if (n == null) {
            return name;
        }
        return n.getNewName();
    }

    private PropertyMapping getPropertyMapping(ExtendedNodeType type, String name) {
        TypeMapping s = this.types.get(type.getName());
        PropertyMapping n = null;
        if (s != null) {
            n = s.properties.get(name);
        }
        return n;
    }

    public String getMappedMetadataProperty(String name) {
        PropertyMapping n = this.metadataProperties.get(name);
        return n != null ? n.getNewName() : name;
    }

    public String getMappedPropertyValue(ExtendedNodeType type, String name, String value) {
        ResourceBundleMarker rbm;
        PropertyMapping n = this.getPropertyMapping(type, name);
        if (n == null) {
            ExtendedNodeType superType;
            ExtendedNodeType[] extendedNodeTypeArray = type.getSupertypes();
            int n2 = extendedNodeTypeArray.length;
            for (int i = 0; i < n2 && (n = this.getPropertyMapping(superType = extendedNodeTypeArray[i], name)) == null; ++i) {
            }
        }
        if (n == null) {
            return value;
        }
        ValueMapping v = n.values.get(value);
        if (v == null && (rbm = ResourceBundleMarker.parseMarkerValue(value)) != null) {
            v = n.values.get("resourceKey(" + rbm.getResourceKey() + ")");
        }
        if (v == null) {
            return value;
        }
        return v.getNewName();
    }

    public List<Action> getActions(ExtendedNodeType type) {
        TypeMapping s = this.types.get(type.getName());
        if (s == null) {
            return Collections.emptyList();
        }
        return s.getActions();
    }

    public List<Action> getActions(ExtendedNodeType type, String name) {
        TypeMapping s = this.types.get(type.getName());
        if (s == null) {
            return Collections.emptyList();
        }
        Mapping n = s.properties.get(name);
        if (n == null) {
            n = s.nodes.get(name);
        }
        if (n == null) {
            return Collections.emptyList();
        }
        return n.getActions();
    }

    public List<Action> getActions(ExtendedNodeType type, String name, String value) {
        TypeMapping s = this.types.get(type.getName());
        if (s == null) {
            return Collections.emptyList();
        }
        PropertyMapping n = s.properties.get(name);
        if (n == null) {
            return Collections.emptyList();
        }
        ValueMapping v = n.values.get(value);
        if (v == null) {
            return Collections.emptyList();
        }
        return v.getActions();
    }

    class ValueMapping
    extends Mapping {
        ValueMapping(String originalValue, String newValue) {
            this.originalName = originalValue;
            this.newName = newValue;
        }
    }

    public static class PropertyMapping
    extends Mapping {
        Map<String, ValueMapping> values = new HashMap<String, ValueMapping>();

        public PropertyMapping(String originalName, String newName) {
            this.originalName = originalName;
            this.newName = newName;
        }

        public ValueMapping addValueMapping(String originalName, ValueMapping mapping) {
            ValueMapping result = this.values.put(originalName, mapping);
            return result;
        }
    }

    class NodeMapping
    extends Mapping {
        String newType;

        NodeMapping(String originalName, String newName, String newType) {
            this.originalName = originalName;
            this.newName = newName;
            this.newType = newType;
        }

        public String getNewType() {
            return this.newType;
        }

        @Override
        public String getNewName() {
            return (this.newType != null ? this.newType + "|" : "") + this.newName;
        }
    }

    class TypeMapping
    extends Mapping {
        Map<String, NodeMapping> nodes = new LinkedHashMap<String, NodeMapping>();
        List<String> nodeNames = new ArrayList<String>();
        Map<String, PropertyMapping> properties = new HashMap<String, PropertyMapping>();

        TypeMapping(String originalType, String newType) {
            this.originalName = originalType;
            this.newName = newType;
        }

        public NodeMapping addNodeMapping(String originalName, NodeMapping mapping) {
            NodeMapping result = this.nodes.put(originalName, mapping);
            this.nodeNames.add(StringUtils.contains((String)mapping.getNewName(), (String)"/") ? StringUtils.substringAfterLast((String)mapping.getNewName(), (String)"/") : mapping.getNewName());
            return result;
        }

        public PropertyMapping addPropertyMapping(String originalName, PropertyMapping mapping) {
            PropertyMapping result = this.properties.put(originalName, mapping);
            return result;
        }

        public List<String> getNodeNames() {
            return this.nodeNames;
        }
    }

    public static class Mapping {
        List<Action> actions = new ArrayList<Action>();
        String originalName;
        String newName;

        public boolean addAction(Action action) {
            boolean result = this.actions.add(action);
            return result;
        }

        public List<Action> getActions() {
            return this.actions;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getNewName() {
            return this.newName;
        }
    }

    class SetProperties
    extends Action {
        Map<String, String> properties;

        SetProperties(Map<String, String> properties) {
            this.properties = new HashMap<String, String>();
            this.properties = properties;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    class AddMixin
    extends Action {
        String nodeType;

        AddMixin(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeType() {
            return this.nodeType;
        }
    }

    class AddNode
    extends Action {
        String name;
        String nodeType;
        Map<String, String> properties;

        AddNode(String name, String nodeType, Map<String, String> properties) {
            this.properties = new HashMap<String, String>();
            this.name = name;
            this.nodeType = nodeType;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    class Action {
        Action() {
        }
    }
}

