/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.interceptor.TemplateModuleInterceptor;
import org.jahia.services.content.nodetypes.JahiaCndReaderLegacy;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.deamons.filewatcher.JahiaFileWatcherService;
import org.jahia.services.importexport.AttributeProcessor;
import org.jahia.services.importexport.CategoriesImportHandler;
import org.jahia.services.importexport.DataWriter;
import org.jahia.services.importexport.DefinitionsMapping;
import org.jahia.services.importexport.DocumentViewExporter;
import org.jahia.services.importexport.DocumentViewImportHandler;
import org.jahia.services.importexport.ExportContext;
import org.jahia.services.importexport.FilesAclImportHandler;
import org.jahia.services.importexport.ImportExportService;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.services.importexport.LegacyPidMappingTool;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.PostImportPatcher;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.importexport.UsersImportHandler;
import org.jahia.services.importexport.XMLContentTransformer;
import org.jahia.services.importexport.XMLFormatDetectionHandler;
import org.jahia.services.importexport.validation.DocumentViewValidationHandler;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.SitesValidator;
import org.jahia.services.importexport.validation.SitesValidatorResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.importexport.validation.ValidationResults;
import org.jahia.services.render.RenderContext;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DateUtils;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.jahia.utils.Url;
import org.jahia.utils.xml.JahiaSAXParserFactory;
import org.jahia.utils.zip.DirectoryZipInputStream;
import org.jahia.utils.zip.DirectoryZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportExportBaseService
extends JahiaService
implements ImportExportService,
Observer {
    private static Logger logger = LoggerFactory.getLogger(ImportExportBaseService.class);
    private static final Set<String> KNOWN_IMPORT_CONTENT_TYPES = ImmutableSet.of((Object)"application/zip", (Object)"application/xml", (Object)"text/xml");
    private static final String FILESACL_XML = "filesacl.xml";
    public static final String REPOSITORY_XML = "repository.xml";
    public static final String LIVE_REPOSITORY_XML = "live-repository.xml";
    private static final String CATEGORIES_XML = "categories.xml";
    private static final String SITE_PERMISSIONS_XML = "sitePermissions.xml";
    public static final String USERS_XML = "users.xml";
    public static final String USERS_ZIP = "users.zip";
    public static final String SERVER_PERMISSIONS_XML = "serverPermissions.xml";
    public static final String SITE_PROPERTIES = "site.properties";
    public static final String EXPORT_PROPERTIES = "export.properties";
    private static final String DEFINITIONS_CND = "definitions.cnd";
    private static final String DEFINITIONS_MAP = "definitions.map";
    public static final String MOUNTS_ZIP = "mounts.zip";
    public static final String REFERENCES_ZIP = "references.zip";
    public static final String ROLES_ZIP = "roles.zip";
    public static final String STATIC_MOUNT_POINT_ATTR = "j:staticMountPointProviderKey";
    public static final String DYNAMIC_MOUNT_POINT_ATTR = "j:dynamicMountPointProviderPath";
    private JahiaSitesService sitesService;
    private JahiaFileWatcherService fileWatcherService;
    private JCRStoreService jcrStoreService;
    private CategoryService categoryService;
    private long observerInterval = 10000L;
    private static FileCleaningTracker fileCleaningTracker = new FileCleaningTracker();
    private boolean expandImportedFilesOnDisk;
    private String expandImportedFilesOnDiskPath;
    private List<AttributeProcessor> attributeProcessors;
    private TemplatePackageRegistry templatePackageRegistry;
    private static final HashSet<String> siteExportNodeTypesToIgnore = Sets.newHashSet((Object[])new String[]{"jnt:templatesFolder", "jnt:externalUser", "jnt:workflowTask"});
    private static final HashSet<String> defaultExportNodeTypesToIgnore = Sets.newHashSet((Object[])new String[]{"jnt:virtualsite", "jnt:workflowTask"});
    private List<XMLContentTransformer> xmlContentTransformers;
    private Map<String, Templates> xsltTemplates = new ConcurrentHashMap<String, Templates>(2);
    private LegacyPidMappingTool legacyPidMappingTool = null;
    private PostImportPatcher postImportPatcher = null;

    private ImportExportBaseService() {
    }

    public static ImportExportBaseService getInstance() {
        return Holder.INSTANCE;
    }

    public static String detectImportContentType(String declaredContentType, String fileName) {
        String contentType = declaredContentType;
        if (!KNOWN_IMPORT_CONTENT_TYPES.contains(contentType) && !KNOWN_IMPORT_CONTENT_TYPES.contains(contentType = JCRContentUtils.getMimeType(fileName))) {
            if (StringUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                contentType = "application/xml";
            } else if (StringUtils.endsWithIgnoreCase((String)fileName, (String)".zip")) {
                contentType = "application/zip";
            } else {
                logger.error("Unable to detect the content type for file {}. It is neither a ZIP file nor an XML. Skipping import.", (Object)fileName);
            }
        }
        return contentType;
    }

    @Override
    public void start() {
        try {
            new ImportFileObserver(SettingsBean.getInstance().getJahiaImportsDiskPath(), false, this.observerInterval, true);
        }
        catch (JahiaException je) {
            logger.error("exception with FilesObserver", (Throwable)je);
        }
    }

    public void setExpandImportedFilesOnDisk(boolean expandImportedFilesOnDisk) {
        this.expandImportedFilesOnDisk = expandImportedFilesOnDisk;
    }

    public void setExpandImportedFilesOnDiskPath(String expandImportedFilesOnDiskPath) {
        this.expandImportedFilesOnDiskPath = expandImportedFilesOnDiskPath;
    }

    public List<AttributeProcessor> getAttributeProcessors() {
        return this.attributeProcessors;
    }

    public void setAttributeProcessors(List<AttributeProcessor> attributeProcessors) {
        this.attributeProcessors = attributeProcessors;
    }

    @Override
    public void stop() {
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public void setFileWatcherService(JahiaFileWatcherService fileWatcherService) {
        this.fileWatcherService = fileWatcherService;
    }

    @Override
    public void exportAll(OutputStream outputStream, Map<String, Object> params) throws JahiaException, RepositoryException, IOException, SAXException, TransformerException {
        this.exportSites(outputStream, params, this.sitesService.getSitesNodeList());
    }

    private long estimateNodesToExport(Set<JCRNodeWrapper> sortedNodes, JCRSessionWrapper session, Set<String> nodeTypesToIgnore) throws RepositoryException {
        long result = 0L;
        ArrayList<String> extraPathsToExport = new ArrayList<String>();
        for (JCRNodeWrapper nodesToExport : sortedNodes) {
            if (nodesToExport instanceof JCRSiteNode) {
                Set<String> languages = ((JCRSiteNode)nodesToExport).getLanguages();
                List<String> sitePaths = Collections.singletonList(nodesToExport.getPath());
                result += this.estimateSubnodesNumber(sitePaths, session, nodeTypesToIgnore, null);
                if (languages == null || languages.size() <= 0) continue;
                for (String language : languages) {
                    result += this.estimateSubnodesNumber(sitePaths, session, nodeTypesToIgnore, language);
                }
                continue;
            }
            extraPathsToExport.add(nodesToExport.getPath());
        }
        return result += this.estimateSubnodesNumber(extraPathsToExport, session, nodeTypesToIgnore, null);
    }

    private long estimateSubnodesNumber(List<String> paths, JCRSessionWrapper session, Set<String> nodeTypesToIgnore, String locale) throws RepositoryException {
        if (paths == null || paths.size() == 0) {
            return 0L;
        }
        QueryManagerWrapper queryManagerWrapper = session.getWorkspace().getQueryManager();
        StringBuilder statement = new StringBuilder("SELECT count AS [rep:count(skipChecks=1)] FROM [").append(locale != null ? "jnt:translation" : "nt:base").append("] WHERE (");
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            if (i > 0) {
                statement.append(" OR ");
            }
            statement.append("isdescendantnode(['").append(path).append("'])");
        }
        statement.append(")");
        if (locale == null && nodeTypesToIgnore != null && nodeTypesToIgnore.size() > 0) {
            statement.append("AND NOT (");
            Iterator<String> nodeTypesToIgnoreIterator = nodeTypesToIgnore.iterator();
            while (nodeTypesToIgnoreIterator.hasNext()) {
                statement.append("[jcr:primaryType] = '").append((Object)nodeTypesToIgnoreIterator.next()).append("'");
                if (!nodeTypesToIgnoreIterator.hasNext()) continue;
                statement.append(" OR ");
            }
            statement.append(")");
        }
        if (locale != null) {
            statement.append(" AND [jcr:language] = '").append(locale).append("'");
        }
        return queryManagerWrapper.createQuery(statement.toString(), "JCR-SQL2").execute().getRows().nextRow().getValue("count").getLong();
    }

    @Override
    public void exportSites(OutputStream outputStream, Map<String, Object> params, List<JCRSiteNode> sites) throws RepositoryException, IOException, SAXException, TransformerException {
        JCRNodeWrapper mounts;
        ZipOutputStream zzout;
        logger.info("Sites " + sites + " export started");
        long startSitesExportTime = System.currentTimeMillis();
        String serverDirectory = (String)params.get("serverDirectory");
        ZipOutputStream zout = this.getZipOutputStream(outputStream, serverDirectory);
        ZipEntry anEntry = new ZipEntry(EXPORT_PROPERTIES);
        zout.putNextEntry(anEntry);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(zout));
        bw.write("JahiaRelease = " + Jahia.getReleaseNumber() + "\n");
        bw.write("Patch = " + Jahia.getPatchNumber() + "\n");
        bw.write("BuildNumber = " + Jahia.getBuildNumber() + "\n");
        bw.write("ExportDate = " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()) + "\n");
        bw.flush();
        HashSet<String> externalReferences = new HashSet<String>();
        for (JCRSiteNode jahiaSite : sites) {
            long startSiteExportTime = System.currentTimeMillis();
            logger.info("Exporting site internal nodes " + jahiaSite.getName() + " content started");
            if (serverDirectory == null) {
                anEntry = new ZipEntry(jahiaSite.getSiteKey() + ".zip");
                zout.putNextEntry(anEntry);
                this.exportSite(jahiaSite, zout, externalReferences, params, null);
            } else {
                this.exportSite(jahiaSite, zout, externalReferences, params, serverDirectory + "/" + jahiaSite.getSiteKey());
            }
            logger.info("Exporting site internal nodes {} ended in {} seconds", (Object)jahiaSite.getName(), (Object)this.getDuration(startSiteExportTime));
        }
        JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession();
        if (params.containsKey("includeUsers")) {
            if (serverDirectory == null) {
                zout.putNextEntry(new ZipEntry(USERS_ZIP));
                zzout = this.getZipOutputStream(zout, null);
            } else {
                zzout = this.getZipOutputStream(zout, serverDirectory + "/users");
            }
            try {
                logger.info("Exporting Users Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(session.getNode("/users")), zzout, defaultExportNodeTypesToIgnore, externalReferences, params, true);
                logger.info("Exporting Users Ended");
            }
            catch (IOException e) {
                logger.warn("Cannot export due to some IO exception :" + e.getMessage());
            }
            catch (Exception e) {
                logger.error("Cannot export Users", (Throwable)e);
            }
            zzout.finish();
        }
        if (params.containsKey("includeRoles")) {
            if (serverDirectory == null) {
                zout.putNextEntry(new ZipEntry(ROLES_ZIP));
                zzout = this.getZipOutputStream(zout, null);
            } else {
                zzout = this.getZipOutputStream(zout, serverDirectory + "/roles");
            }
            try {
                logger.info("Exporting Roles Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(session.getNode("/roles")), zzout, defaultExportNodeTypesToIgnore, externalReferences, params, true);
                logger.info("Exporting Roles Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export roles", (Throwable)e);
            }
            zzout.finish();
        }
        if (params.containsKey("includeMounts") && session.nodeExists("/mounts") && (mounts = session.getNode("/mounts")).hasNodes()) {
            zout.putNextEntry(new ZipEntry(MOUNTS_ZIP));
            ZipOutputStream zzout2 = new ZipOutputStream(zout);
            try {
                logger.info("Exporting Mount points Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(mounts), zzout2, defaultExportNodeTypesToIgnore, externalReferences, params, true);
                logger.info("Exporting Mount points Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export mount points", (Throwable)e);
            }
            zzout2.finish();
        }
        HashSet<JCRNodeWrapper> refs = new HashSet<JCRNodeWrapper>();
        for (String reference : externalReferences) {
            JCRNodeWrapper node = session.getNodeByUUID(reference);
            if (defaultExportNodeTypesToIgnore.contains(node.getPrimaryNodeTypeName())) continue;
            refs.add(node);
        }
        if (!refs.isEmpty()) {
            zout.putNextEntry(new ZipEntry(REFERENCES_ZIP));
            ZipOutputStream zzout2 = this.getZipOutputStream(zout, serverDirectory + "/" + REFERENCES_ZIP);
            try {
                logger.info("Exporting References Started");
                this.exportNodesWithBinaries(session.getRootNode(), refs, zzout2, defaultExportNodeTypesToIgnore, externalReferences, params, true);
                logger.info("Exporting References Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export References", (Throwable)e);
            }
            zzout2.finish();
        }
        zout.finish();
        logger.info("Total Sites {} export ended in {} seconds", sites, (Object)this.getDuration(startSitesExportTime));
    }

    private ZipOutputStream getZipOutputStream(OutputStream outputStream, String serverDirectory) {
        ZipOutputStream zout = null;
        if (serverDirectory != null) {
            File serverDirectoryFile = new File(serverDirectory);
            if (serverDirectoryFile.getParentFile().exists()) {
                if (!serverDirectoryFile.exists()) {
                    if (!serverDirectoryFile.mkdir()) {
                        serverDirectoryFile = null;
                    }
                } else if (!serverDirectoryFile.isDirectory()) {
                    serverDirectoryFile = null;
                }
            } else {
                serverDirectoryFile = null;
            }
            if (serverDirectoryFile != null) {
                zout = new DirectoryZipOutputStream(serverDirectoryFile, outputStream);
            }
        }
        if (zout == null) {
            zout = new ZipOutputStream(outputStream);
        }
        return zout;
    }

    private void exportSite(JCRSiteNode site, OutputStream out, Set<String> externalReferences, Map<String, Object> params, String serverDirectory) throws RepositoryException, SAXException, IOException, TransformerException {
        ZipOutputStream zout = this.getZipOutputStream(out, serverDirectory);
        zout.putNextEntry(new ZipEntry(SITE_PROPERTIES));
        this.exportSiteInfos(zout, site);
        JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession();
        JCRNodeWrapper node = session.getNode("/sites/" + site.getSiteKey());
        Set<JCRNodeWrapper> nodes = Collections.singleton(node);
        this.exportNodesWithBinaries(session.getRootNode(), nodes, zout, siteExportNodeTypesToIgnore, externalReferences, params, true);
        zout.finish();
    }

    @Override
    public void exportZip(JCRNodeWrapper node, JCRNodeWrapper exportRoot, OutputStream out, Map<String, Object> params) throws RepositoryException, SAXException, IOException, TransformerException {
        ZipOutputStream zout = this.getZipOutputStream(out, (String)params.get("serverDirectory"));
        HashSet<JCRNodeWrapper> nodes = new HashSet<JCRNodeWrapper>();
        nodes.add(node);
        this.exportNodesWithBinaries(exportRoot == null ? node : exportRoot, nodes, zout, new HashSet<String>(), null, params, false);
        zout.finish();
    }

    @Override
    public void exportNode(JCRNodeWrapper node, JCRNodeWrapper exportRoot, OutputStream out, Map<String, Object> params) throws RepositoryException, SAXException, IOException, TransformerException {
        TreeSet<JCRNodeWrapper> nodes = new TreeSet<JCRNodeWrapper>(new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        nodes.add(node);
        this.exportNodes(exportRoot == null ? node : exportRoot, nodes, out, new HashSet<String>(), null, params, false);
    }

    private void exportNodesWithBinaries(JCRNodeWrapper rootNode, Set<JCRNodeWrapper> nodes, ZipOutputStream zout, Set<String> typesToIgnore, Set<String> externalReferences, Map<String, Object> params, boolean logProgress) throws SAXException, IOException, RepositoryException, TransformerException {
        TreeSet<JCRNodeWrapper> liveSortedNodes = new TreeSet<JCRNodeWrapper>(new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        if (params.containsKey("includeLive")) {
            JCRSessionWrapper liveSession = this.jcrStoreService.getSessionFactory().getCurrentUserSession("live");
            JCRNodeWrapper liveRootNode = null;
            try {
                liveRootNode = liveSession.getNodeByIdentifier(rootNode.getIdentifier());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (liveRootNode != null) {
                for (JCRNodeWrapper node : nodes) {
                    try {
                        liveSortedNodes.add(liveSession.getNodeByIdentifier(node.getIdentifier()));
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                }
                if (!liveSortedNodes.isEmpty()) {
                    zout.putNextEntry(new ZipEntry(LIVE_REPOSITORY_XML));
                    logger.info("Exporting live workspace for nodes {} ...", nodes);
                    this.exportNodes(liveRootNode, liveSortedNodes, zout, typesToIgnore, externalReferences, params, logProgress);
                    zout.closeEntry();
                    this.exportNodesBinary(liveRootNode, liveSortedNodes, zout, typesToIgnore, "/live-content");
                    logger.info("Live workspace exported for nodes {}", nodes);
                }
            }
        }
        TreeSet<JCRNodeWrapper> sortedNodes = new TreeSet<JCRNodeWrapper>(new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        sortedNodes.addAll(nodes);
        for (JCRNodeWrapper liveSortedNode : liveSortedNodes) {
            try {
                sortedNodes.add(rootNode.getSession().getNodeByIdentifier(liveSortedNode.getIdentifier()));
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        zout.putNextEntry(new ZipEntry(REPOSITORY_XML));
        logger.info("Exporting default workspace for nodes {} ...", nodes);
        this.exportNodes(rootNode, sortedNodes, zout, typesToIgnore, externalReferences, params, logProgress);
        zout.closeEntry();
        this.exportNodesBinary(rootNode, sortedNodes, zout, typesToIgnore, "/content");
        logger.info("Default workspace exported for nodes {}", nodes);
    }

    private void exportNodes(JCRNodeWrapper rootNode, TreeSet<JCRNodeWrapper> sortedNodes, OutputStream outputStream, Set<String> typesToIgnore, Set<String> externalReferences, Map<String, Object> params, boolean logProgress) throws IOException, RepositoryException, SAXException, TransformerException {
        DocumentViewExporter exporter;
        long startSitesExportTime = System.currentTimeMillis();
        ExportContext exportContext = null;
        if (logProgress) {
            long estimatedNodes = this.estimateNodesToExport(sortedNodes, rootNode.getSession(), typesToIgnore);
            logger.info("Approximate number of nodes to export: {}, estimated in: {} seconds", (Object)estimatedNodes, (Object)this.getDuration(startSitesExportTime));
            exportContext = new ExportContext(estimatedNodes);
        }
        String xsl = (String)params.get("xsl_path");
        boolean skipBinary = !Boolean.FALSE.equals(params.get("skipBinary"));
        boolean noRecurse = Boolean.TRUE.equals(params.get("noRecurse"));
        OutputStream tmpOut = outputStream;
        if (xsl != null) {
            String filename = Patterns.SPACE.matcher(rootNode.getName()).replaceAll("_");
            File tempFile = File.createTempFile("exportTemplates-" + filename, ".xml");
            tmpOut = new DeferredFileOutputStream(0xA00000, tempFile);
        }
        DataWriter dw = new DataWriter(new OutputStreamWriter(tmpOut, "UTF-8"));
        if (Boolean.TRUE.equals(params.get("systemView"))) {
            exporter = new SystemViewExporter((Session)rootNode.getSession(), (ContentHandler)dw, !noRecurse, !skipBinary);
            exporter.export(rootNode);
        } else {
            exporter = new DocumentViewExporter(rootNode.getSession(), dw, skipBinary, noRecurse);
            exporter.setExportContext(exportContext);
            exporter.addObserver(this);
            if (externalReferences != null) {
                exporter.setExternalReferences(externalReferences);
            }
            typesToIgnore.add("rep:system");
            if (params.containsKey("includeLive")) {
                ArrayList<String> l = new ArrayList<String>(exporter.getPropertiestoIgnore());
                l.remove("jcr:uuid");
                exporter.setPropertiestoIgnore(l);
                if (rootNode.getSession().getWorkspace().getName().equals("default")) {
                    exporter.setPublicationStatusSession(this.jcrStoreService.getSessionFactory().getCurrentUserSession("live"));
                }
            }
            exporter.setTypesToIgnore(typesToIgnore);
            exporter.export(rootNode, sortedNodes);
            sortedNodes.addAll(exporter.getNodesList());
        }
        if (exportContext != null) {
            logger.info("Exported {} nodes in {} seconds", (Object)exportContext.getExportIndex(), (Object)this.getDuration(startSitesExportTime));
        }
        dw.flush();
        if (xsl != null) {
            DeferredFileOutputStream stream = (DeferredFileOutputStream)tmpOut;
            InputStream inputStream = new BufferedInputStream(new FileInputStream(stream.getFile()));
            fileCleaningTracker.track(stream.getFile(), (Object)inputStream);
            if (stream.isInMemory()) {
                ((InputStream)inputStream).close();
                inputStream = new ByteArrayInputStream(stream.getData());
            }
            Transformer transformer = this.getTransformer(xsl);
            long startXmlCleanup = System.currentTimeMillis();
            if (logProgress) {
                logger.info("Starting cleanup transformation ...");
                transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
                logger.info("Cleanup transformation finished in {} seconds", (Object)this.getDuration(startXmlCleanup));
            } else {
                transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
            }
        }
    }

    private Transformer getTransformer(String xsl) throws TransformerConfigurationException {
        Templates templates = this.xsltTemplates.get(xsl);
        if (templates == null) {
            templates = new TransformerFactoryImpl().newTemplates((Source)new StreamSource(new File(xsl)));
            this.xsltTemplates.put(xsl, templates);
        }
        return templates.newTransformer();
    }

    private void exportNodesBinary(JCRNodeWrapper root, SortedSet<JCRNodeWrapper> nodes, ZipOutputStream zout, Set<String> typesToIgnore, String basepath) throws IOException, RepositoryException {
        long startExportingNodesBinary = System.currentTimeMillis();
        logger.info("Exporting binary nodes ...");
        byte[] buffer = new byte[4096];
        for (JCRNodeWrapper file : nodes) {
            this.exportNodeBinary(root, file, zout, typesToIgnore, buffer, basepath, new HashSet<String>());
        }
        logger.info("Binary nodes exported in {} seconds", (Object)this.getDuration(startExportingNodesBinary));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exportNodeBinary(JCRNodeWrapper root, JCRNodeWrapper node, ZipOutputStream zout, Set<String> typesToIgnore, byte[] buffer, String basepath, Set<String> exportedFiles) throws IOException, RepositoryException {
        block11: {
            if (typesToIgnore.contains(node.getPrimaryNodeTypeName()) || !node.getProvider().canExportNode(node)) break block11;
            JCRNodeIteratorWrapper ni = node.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper child = (JCRNodeWrapper)ni.nextNode();
                if (!child.getProvider().canExportNode(child)) continue;
                if (child.isNodeType("nt:resource") && !exportedFiles.contains(child.getPath())) {
                    InputStream is;
                    block10: {
                        exportedFiles.add(child.getPath());
                        is = null;
                        try {
                            int bytesIn;
                            JCRPropertyWrapper property = child.getProperty("jcr:data");
                            if (!child.getProvider().canExportProperty(property) || (is = property.getBinary().getStream()) == null) break block10;
                            String path = node.getPath();
                            path = root.getPath().equals("/") ? basepath + path : basepath + path.substring(root.getParent().getPath().length());
                            String name = JCRContentUtils.replaceColon(child.getName());
                            if (child.getName().equals("jcr:content")) {
                                name = node.getName();
                            }
                            path = path + "/" + name;
                            zout.putNextEntry(new ZipEntry(path.substring(1)));
                            while ((bytesIn = is.read(buffer)) != -1) {
                                zout.write(buffer, 0, bytesIn);
                            }
                        }
                        catch (RepositoryException ex) {
                            logger.warn("Cannot export " + child.getPath(), (Throwable)ex);
                            IOUtils.closeQuietly((InputStream)is);
                        }
                        catch (AssertionError ex2) {
                            logger.warn("Cannot export " + child.getPath(), (Throwable)((Object)ex2));
                            {
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(is);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((InputStream)is);
                        }
                    }
                    IOUtils.closeQuietly(is);
                }
                this.exportNodeBinary(root, child, zout, typesToIgnore, buffer, basepath, exportedFiles);
            }
        }
    }

    private void exportSiteInfos(OutputStream out, JCRSiteNode s) throws IOException {
        OrderedProperties p = new OrderedProperties();
        p.setProperty("sitetitle", s.getTitle());
        p.setProperty("siteservername", s.getServerName());
        p.setProperty("siteservernamealiases", StringUtils.join(s.getServerNameAliases(), (String)", "));
        p.setProperty("sitekey", s.getSiteKey());
        p.setProperty("description", s.getDescr());
        p.setProperty("templatePackageName", s.getTemplateFolder());
        p.setProperty("mixLanguage", Boolean.toString(s.isMixLanguagesActive()));
        p.setProperty("defaultLanguage", s.getDefaultLanguage());
        int i = 1;
        for (String string : s.getInstalledModules()) {
            p.setProperty("installedModules." + i++, string);
        }
        Set<String> v = s.getLanguages();
        for (String sls : v) {
            p.setProperty("language." + sls + ".activated", s.getInactiveLiveLanguages().contains(sls) ? "false" : "true");
            p.setProperty("language." + sls + ".mandatory", "" + s.getMandatoryLanguages().contains(sls));
        }
        for (String sls : s.getInactiveLanguages()) {
            p.setProperty("language." + sls + ".disabledCompletely", "true");
        }
        try {
            JahiaSite jahiaSite = this.sitesService.getDefaultSite(s.getSession());
            if (jahiaSite != null && jahiaSite.getSiteKey().equals(s.getName())) {
                p.setProperty("defaultSite", "true");
            }
        }
        catch (RepositoryException repositoryException) {
            logger.error(repositoryException.getMessage(), (Throwable)repositoryException);
        }
        p.store(out, "");
    }

    @Override
    public void importSiteZip(JCRNodeWrapper nodeWrapper) throws RepositoryException, IOException, JahiaException {
        String uri = nodeWrapper.getPath();
        JCRNodeWrapper contentNode = nodeWrapper.getNode("jcr:content");
        ZipInputStream zis = new ZipInputStream(contentNode.getProperty("jcr:data").getBinary().getStream());
        this.importSiteZip(zis, uri, null, nodeWrapper.getSession());
    }

    @Override
    public void importSiteZip(Resource file) throws RepositoryException, IOException, JahiaException {
        this.importSiteZip(file, null);
    }

    @Override
    public void importSiteZip(Resource file, JCRSessionWrapper session) throws RepositoryException, IOException {
        ZipInputStream zis = new ZipInputStream(file.getInputStream());
        this.importSiteZip(zis, null, file, session);
    }

    private void importSiteZip(ZipInputStream zis2, final String uri, final Resource fileImport, JCRSessionWrapper session) throws IOException {
        ZipEntry z;
        final Properties infos = new Properties();
        while ((z = zis2.getNextEntry()) != null) {
            boolean serverNameEx;
            boolean siteKeyEx;
            block12: {
                if (!SITE_PROPERTIES.equals(z.getName())) continue;
                infos.load(zis2);
                zis2.closeEntry();
                siteKeyEx = false;
                serverNameEx = false;
                try {
                    siteKeyEx = "".equals(infos.get("sitekey")) || this.sitesService.siteExists((String)infos.get("sitekey"), session);
                    String serverName = (String)infos.get("siteservername");
                    String serverNameAliases = (String)infos.get("siteservernamealiases");
                    boolean bl = serverNameEx = "".equals(serverName) || !Url.isLocalhost(serverName) && this.sitesService.getSiteByServerName(serverName, session) != null;
                    if (serverNameEx || !StringUtils.isNotEmpty((String)serverNameAliases)) break block12;
                    for (String alias : StringUtils.split((String)serverNameAliases, (String)", ")) {
                        if (Url.isLocalhost(alias) || this.sitesService.getSiteByServerName(alias, session) == null) continue;
                        serverNameEx = true;
                        break;
                    }
                }
                catch (RepositoryException e) {
                    logger.error("Error when getting site", (Throwable)e);
                }
            }
            if (siteKeyEx || serverNameEx) continue;
            String tpl = (String)infos.get("templatePackageName");
            if ("".equals(tpl)) {
                tpl = null;
            }
            try {
                Locale locale = null;
                if (infos.getProperty("defaultLanguage") != null) {
                    locale = LanguageCodeConverters.languageCodeToLocale(infos.getProperty("defaultLanguage"));
                } else {
                    for (Object e : infos.keySet()) {
                        String s = (String)e;
                        if (!s.startsWith("language.") || !s.endsWith(".rank")) continue;
                        String code = s.substring(s.indexOf(46) + 1, s.lastIndexOf(46));
                        String rank = infos.getProperty(s);
                        if (!rank.equals("1")) continue;
                        locale = LanguageCodeConverters.languageCodeToLocale(code);
                    }
                }
                final Locale finalLocale = locale;
                final String string = tpl;
                try {
                    JCRObservationManager.doWithOperationType(session, 13, new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            try {
                                SiteCreationInfo siteCreationInfo = SiteCreationInfo.builder().siteKey(infos.getProperty("sitekey")).serverName(infos.getProperty("siteservername")).serverNameAliases(infos.getProperty("siteservernamealiases")).title(infos.getProperty("sitetitle")).description(infos.getProperty("description")).templateSet(string).modulesToDeploy(null).locale(finalLocale != null ? finalLocale.toString() : null).siteAdmin(JCRSessionFactory.getInstance().getCurrentUser()).firstImport(fileImport != null ? "fileImport" : "importRepositoryFile").fileImport(fileImport).fileImportName(uri).originatingJahiaRelease(infos.getProperty("originatingJahiaRelease")).build();
                                JahiaSite site = ImportExportBaseService.this.sitesService.addSite(siteCreationInfo, session);
                                ImportExportBaseService.this.importSiteProperties(site, infos, session);
                            }
                            catch (JahiaException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                            catch (IOException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
                catch (RepositoryException e) {
                    if (e.getCause() == null || !(e.getCause() instanceof JahiaException) && !(e.getCause() instanceof IOException)) continue;
                    throw (Exception)e.getCause();
                }
            }
            catch (Exception e) {
                logger.error("Cannot create site " + infos.get("sitetitle"), (Throwable)e);
            }
        }
    }

    @Override
    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos) throws RepositoryException, IOException {
        this.importSiteZip(file, site, infos, null, null);
    }

    @Override
    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath) throws RepositoryException, IOException {
        this.importSiteZip(file, site, infos, legacyMappingFilePath, legacyDefinitionsFilePath, this.jcrStoreService.getSessionFactory().getCurrentUserSession(null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session) throws RepositoryException, IOException {
        ArrayList<String> fileList;
        List<String[]> userProps;
        List<String[]> catProps;
        boolean legacyImport;
        UsersImportHandler usersImportHandler;
        CategoriesImportHandler categoriesImportHandler;
        long timerSite;
        block98: {
            String name;
            Object zipentry;
            ZipInputStream zis;
            timerSite = System.currentTimeMillis();
            logger.info("Start import for site {}", (Object)(site != null ? site.getSiteKey() : ""));
            categoriesImportHandler = new CategoriesImportHandler();
            usersImportHandler = new UsersImportHandler(site, session);
            legacyImport = false;
            catProps = null;
            userProps = null;
            HashMap<String, Long> sizes = new HashMap<String, Long>();
            fileList = new ArrayList<String>();
            logger.info("Start analyzing import file {}", (Object)file);
            long timer = System.currentTimeMillis();
            this.getFileList(file, sizes, fileList);
            logger.info("Done analyzing import file {} in {}", (Object)file, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
            Map<String, String> pathMapping = session.getPathMapping();
            for (JahiaTemplatesPackage pkg : this.templatePackageRegistry.getRegisteredModules().values()) {
                String key = "/modules/" + pkg.getId() + "/";
                if (pathMapping.containsKey(key)) continue;
                pathMapping.put(key, "/modules/" + pkg.getId() + "/" + pkg.getVersion() + "/");
            }
            if (sizes.containsKey(USERS_XML)) {
                zis = this.getZipInputStream(file);
                try {
                    while ((zipentry = zis.getNextEntry()) != null) {
                        name = ((ZipEntry)zipentry).getName();
                        if (name.equals(USERS_XML)) {
                            userProps = this.importUsers(zis, usersImportHandler);
                            break;
                        }
                        zis.closeEntry();
                    }
                }
                finally {
                    this.closeInputStream(zis);
                }
            }
            zipentry = sizes.entrySet().iterator();
            while (zipentry.hasNext()) {
                Map.Entry entry = (Map.Entry)zipentry.next();
                if (!((String)entry.getKey()).startsWith("export_")) continue;
                legacyImport = true;
                break;
            }
            if (sizes.containsKey(SITE_PROPERTIES)) {
                zis = this.getZipInputStream(file);
                try {
                    while ((zipentry = zis.getNextEntry()) != null) {
                        name = ((ZipEntry)zipentry).getName();
                        if (name.equals(SITE_PROPERTIES)) {
                            this.importSiteProperties(zis, site, session);
                            break;
                        }
                        zis.closeEntry();
                    }
                }
                finally {
                    this.closeInputStream(zis);
                }
            }
            if (sizes.containsKey(REPOSITORY_XML)) {
                zis = this.getZipInputStream(file);
                try {
                    while ((zipentry = zis.getNextEntry()) != null) {
                        name = ((ZipEntry)zipentry).getName();
                        if (name.equals(REPOSITORY_XML)) {
                            timer = System.currentTimeMillis();
                            logger.info("Start importing repository.xml");
                            DocumentViewValidationHandler h = new DocumentViewValidationHandler();
                            h.setSession(session);
                            ArrayList<ImportValidator> validators = new ArrayList<ImportValidator>();
                            SitesValidator sitesValidator = new SitesValidator();
                            validators.add(sitesValidator);
                            h.setValidators(validators);
                            this.handleImport(zis, h, name);
                            Map<String, Properties> sites = ((SitesValidatorResult)sitesValidator.getResult()).getSitesProperties();
                            for (String s : sites.keySet()) {
                                if (s.equals("systemsite") || site.getSiteKey().equals("systemsite")) continue;
                                pathMapping.put("/sites/" + s + "/", "/sites/" + site.getSiteKey() + "/");
                                break;
                            }
                            if (!sizes.containsKey(SITE_PROPERTIES)) {
                                // empty if block
                            }
                            logger.info("Done importing repository.xml in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
                            break;
                        }
                        zis.closeEntry();
                    }
                }
                finally {
                    this.closeInputStream(zis);
                }
                this.importZip(null, file, 0, session, Sets.newHashSet((Object[])new String[]{USERS_XML, CATEGORIES_XML}), true);
            } else {
                pathMapping.put("/", "/sites/" + site.getSiteKey() + "/files/");
            }
            NodeTypeRegistry reg = NodeTypeRegistry.getInstance();
            DefinitionsMapping mapping = null;
            if (!sizes.containsKey(REPOSITORY_XML) || sizes.containsKey(SITE_PROPERTIES) || sizes.containsKey(CATEGORIES_XML) || sizes.containsKey(SITE_PERMISSIONS_XML) || sizes.containsKey(DEFINITIONS_CND) || sizes.containsKey(DEFINITIONS_MAP)) {
                zis = this.getZipInputStream(file);
                try {
                    while (true) {
                        block95: {
                            ZipEntry zipentry2;
                            if ((zipentry2 = zis.getNextEntry()) == null) {
                                break;
                            }
                            String name2 = zipentry2.getName();
                            if (name2.indexOf(92) > -1) {
                                name2 = name2.replace('\\', '/');
                            }
                            if (name2.indexOf(47) > -1) {
                                if (!sizes.containsKey(REPOSITORY_XML) && !sizes.containsKey(FILESACL_XML)) {
                                    Matcher m;
                                    name2 = "/" + name2;
                                    if (name2.startsWith("/content/sites")) {
                                        name2 = pathMapping.get("/") + StringUtils.stripStart((String)name2.replaceFirst("/content/sites/[^/]+/files/", ""), (String)"/");
                                    } else if (name2.startsWith("/users")) {
                                        m = Pattern.compile("/users/([^/]+)(/.*)?").matcher(name2);
                                        if (m.matches()) {
                                            name2 = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
                                            name2 = name2 + "/files" + (m.group(2) != null ? m.group(2) : "");
                                        }
                                    } else if (name2.startsWith("/content/users")) {
                                        m = Pattern.compile("/content/users/([^/]+)(/.*)?").matcher(name2);
                                        if (m.matches()) {
                                            name2 = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
                                            name2 = name2 + (m.group(2) != null ? m.group(2) : "");
                                        }
                                    } else {
                                        name2 = pathMapping.get("/") + StringUtils.stripStart((String)name2, (String)"/");
                                    }
                                    if (!zipentry2.isDirectory()) {
                                        try {
                                            String filename = name2.substring(name2.lastIndexOf(47) + 1);
                                            this.ensureFile(session, name2, zis, JCRContentUtils.getMimeType(filename), site);
                                        }
                                        catch (Exception e) {
                                            logger.error("Cannot upload file " + zipentry2.getName(), (Throwable)e);
                                        }
                                    } else {
                                        this.ensureDir(session, name2, site);
                                    }
                                }
                            } else if (name2.equals(CATEGORIES_XML)) {
                                catProps = this.importCategoriesAndGetUuidProps(zis, categoriesImportHandler);
                            } else if (name2.equals(DEFINITIONS_CND)) {
                                reg = new NodeTypeRegistry();
                                try {
                                    for (Map.Entry<String, File> entry : NodeTypeRegistry.getSystemDefinitionsFiles().entrySet()) {
                                        reg.addDefinitionsFile(entry.getValue(), entry.getKey());
                                    }
                                    if (legacyImport) {
                                        JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(new InputStreamReader((InputStream)zis, Charsets.UTF_8), zipentry2.getName(), file.getURL().getPath(), reg);
                                        r.parse();
                                        break block95;
                                    }
                                    reg.addDefinitionsFile((Resource)new InputStreamResource((InputStream)zis, zipentry2.getName()), file.getURL().getPath());
                                }
                                catch (RepositoryException | ParseException e) {
                                    logger.error(e.getMessage(), e);
                                }
                            } else if (name2.equals(DEFINITIONS_MAP)) {
                                mapping = new DefinitionsMapping();
                                mapping.load(zis);
                            }
                        }
                        zis.closeEntry();
                    }
                }
                finally {
                    this.closeInputStream(zis);
                }
            }
            if (!legacyImport) break block98;
            long timerLegacy = System.currentTimeMillis();
            String originatingJahiaRelease = (String)infos.get("originatingJahiaRelease");
            logger.info("Start legacy import, source version is " + originatingJahiaRelease);
            if (legacyMappingFilePath != null) {
                mapping = new DefinitionsMapping();
                InputStream fileInputStream = legacyMappingFilePath.getInputStream();
                try {
                    mapping.load(fileInputStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fileInputStream);
                }
            }
            if (legacyDefinitionsFilePath != null) {
                reg = new NodeTypeRegistry();
                if ("6.1".equals(originatingJahiaRelease)) {
                    logger.info("Loading the built in 6.1 definitions before processing the provided custom ones");
                    List<String> builtInLegacyDefs = Arrays.asList("01-system-nodetypes.cnd", "02-jahiacore-nodetypes.cnd", "03-files-nodetypes.cnd", "04-jahiacontent-nodetypes.cnd", "05-standard-types.cnd", "10-extension-nodetypes.cnd", "11-preferences-nodetypes.cnd");
                    Iterator<String> iterator = builtInLegacyDefs.iterator();
                    while (iterator.hasNext()) {
                        String builtInLegacyDefsFile = iterator.next();
                        InputStreamReader inputStreamReader = null;
                        try {
                            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/jahia/migration/legacyDefinitions/jahia6/" + builtInLegacyDefsFile);
                            if (inputStream != null) {
                                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                                JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(inputStreamReader, builtInLegacyDefsFile, file.getURL().getPath(), reg);
                                r.parse();
                            } else {
                                logger.error("Couldn't load " + builtInLegacyDefsFile);
                            }
                            IOUtils.closeQuietly((Reader)inputStreamReader);
                        }
                        catch (ParseException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            IOUtils.closeQuietly(inputStreamReader);
                        }
                    }
                } else {
                    try {
                        for (Map.Entry<String, File> entry : NodeTypeRegistry.getSystemDefinitionsFiles().entrySet()) {
                            reg.addDefinitionsFile(entry.getValue(), entry.getKey());
                        }
                    }
                    catch (ParseException e) {
                        logger.error("Cannot parse definitions : " + e.getMessage(), (Throwable)e);
                    }
                }
                InputStreamReader streamReader = null;
                try {
                    streamReader = new InputStreamReader(legacyDefinitionsFilePath.getInputStream(), "UTF-8");
                    JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(streamReader, legacyDefinitionsFilePath.getFilename(), file.getURL().getPath(), reg);
                    r.parse();
                }
                catch (ParseException e) {
                    try {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(streamReader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)streamReader);
                }
                IOUtils.closeQuietly((Reader)streamReader);
            }
            JCRNodeWrapper siteFolder = session.getNode("/sites/" + site.getSiteKey());
            zis = new NoCloseZipInputStream(new BufferedInputStream(file.getInputStream()));
            try {
                ZipEntry zipentry3;
                int legacyImportHandlerCtnId = 1;
                while ((zipentry3 = zis.getNextEntry()) != null) {
                    String name3 = zipentry3.getName();
                    if (name3.equals(FILESACL_XML)) {
                        logger.info("Importing file filesacl.xml");
                        this.importFilesAcl(site, file, zis, mapping, fileList);
                    } else if (name3.startsWith("export")) {
                        logger.info("Importing file " + name3);
                        String languageCode = name3.indexOf("_") != -1 ? name3.substring(7, name3.lastIndexOf(".")) : site.getLanguagesAsLocales().iterator().next().toString();
                        zipentry3.getSize();
                        LegacyImportHandler importHandler = new LegacyImportHandler(session, siteFolder, reg, mapping, LanguageCodeConverters.languageCodeToLocale(languageCode), infos != null ? originatingJahiaRelease : null, this.legacyPidMappingTool, legacyImportHandlerCtnId);
                        LinkedHashMap<String, List<String>> references = new LinkedHashMap<String, List<String>>();
                        importHandler.setReferences(references);
                        InputStream documentInput = zis;
                        if (this.xmlContentTransformers != null && this.xmlContentTransformers.size() > 0) {
                            documentInput = new ZipInputStream(file.getInputStream());
                            while (!name3.equals(documentInput.getNextEntry().getName())) {
                            }
                            byte[] buffer = new byte[2048];
                            File tmpDirectoryForSite = new File(new File(System.getProperty("java.io.tmpdir"), "jahia-migration"), FastDateFormat.getInstance((String)"yyyy_MM_dd-HH_mm_ss_SSS").format(timerSite) + "_" + site.getSiteKey());
                            tmpDirectoryForSite.mkdirs();
                            File document = new File(tmpDirectoryForSite, "export_" + languageCode + "_00_extracted.xml");
                            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(document), 2048);
                            int count = 0;
                            while ((count = ((InputStream)documentInput).read(buffer, 0, 2048)) > 0) {
                                ((OutputStream)output).write(buffer, 0, count);
                            }
                            ((OutputStream)output).flush();
                            ((OutputStream)output).close();
                            ((InputStream)documentInput).close();
                            for (XMLContentTransformer xct : this.xmlContentTransformers) {
                                document = xct.transform(document, tmpDirectoryForSite);
                            }
                            documentInput = new FileInputStream(document);
                        }
                        this.handleImport(documentInput, importHandler, name3);
                        legacyImportHandlerCtnId = importHandler.getCtnId();
                        ReferencesHelper.resolveCrossReferences(session, references);
                        siteFolder.getSession().save(13);
                    }
                    zis.closeEntry();
                }
                ReferencesHelper.resolveReferencesKeeper(session);
                siteFolder.getSession().save(13);
            }
            finally {
                this.closeInputStream(zis);
            }
            logger.info("Done legacy import in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerLegacy));
        }
        categoriesImportHandler.setUuidProps(catProps);
        usersImportHandler.setUuidProps(userProps);
        session.save(13);
        this.cleanFilesList(fileList);
        if (legacyImport && this.postImportPatcher != null) {
            long timerPIP = System.currentTimeMillis();
            logger.info("Executing post import patches");
            this.postImportPatcher.executePatches(site);
            logger.info("Executed post import patches in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerPIP));
        }
        logger.info("Done importing site {} in {}", (Object)(site != null ? site.getSiteKey() : ""), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerSite));
    }

    private void cleanFilesList(List<String> fileList) {
        if (this.expandImportedFilesOnDisk) {
            long timer = System.currentTimeMillis();
            logger.info("Start cleaning {} files", (Object)fileList.size());
            for (String fileName : fileList) {
                try {
                    File toBeDeleted = new File(this.expandImportedFilesOnDiskPath + fileName);
                    if (!toBeDeleted.exists()) continue;
                    if (toBeDeleted.isDirectory()) {
                        FileUtils.deleteDirectory((File)toBeDeleted);
                        continue;
                    }
                    toBeDeleted.delete();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            logger.info("Done file cleanup in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
        }
    }

    public JCRNodeWrapper ensureDir(JCRSessionWrapper session, String path, JahiaSite site) throws RepositoryException {
        JCRNodeWrapper dir;
        block11: {
            try {
                dir = session.getNode(path);
                String current = path;
                while (current.lastIndexOf(47) > 0) {
                    JCRNodeWrapper currentNode = session.getNode(current);
                    if ("jnt:virtualsite".equals(currentNode.getPrimaryNodeTypeName())) {
                        if (!currentNode.getName().equals(site.getSiteKey())) {
                            String newName = current.substring(0, current.lastIndexOf(47)) + "/" + site.getSiteKey();
                            session.getPathMapping().put(current, newName);
                            path = path.replace(current, newName);
                            return this.ensureDir(session, path, site);
                        }
                        break;
                    }
                    int endIndex = current.lastIndexOf(47);
                    current = current.substring(0, endIndex);
                }
            }
            catch (PathNotFoundException pnfe) {
                int endIndex = path.lastIndexOf(47);
                if (endIndex == -1) {
                    logger.warn("Cannot create folder " + path);
                    return null;
                }
                JCRNodeWrapper parentDir = this.ensureDir(session, path.substring(0, endIndex), site);
                if (parentDir == null) {
                    return null;
                }
                if (parentDir.isNodeType("jnt:virtualsitesFolder")) {
                    dir = parentDir.getNode(site.getSiteKey());
                }
                try {
                    String dirName = path.substring(path.lastIndexOf(47) + 1);
                    if (!StringUtils.isEmpty((String)dirName)) {
                        session.checkout(parentDir);
                        JCRNodeWrapper createdDir = parentDir.createCollection(dirName);
                        createdDir.saveSession();
                    }
                }
                catch (RepositoryException e) {
                    logger.error("RepositoryException", (Throwable)e);
                }
                dir = session.getNode(path);
                if (!logger.isDebugEnabled()) break block11;
                logger.debug("Folder created {}", (Object)path);
            }
        }
        return dir;
    }

    public void ensureFile(JCRSessionWrapper session, String path, InputStream inputStream, String type, JahiaSite destSite) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        try {
            JCRNodeWrapper parentDir = this.ensureDir(session, path.substring(0, path.lastIndexOf(47)), destSite);
            if (parentDir == null) {
                return;
            }
            if (!parentDir.hasNode(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Add file to {}", (Object)parentDir.getPath());
                }
                try {
                    if (!parentDir.isCheckedOut()) {
                        session.checkout(parentDir);
                    }
                    JCRNodeWrapper res = parentDir.uploadFile(name, inputStream, type);
                    if (logger.isDebugEnabled()) {
                        logger.debug("File added -> {}", (Object)res);
                    }
                    res.saveSession();
                }
                catch (RepositoryException e) {
                    logger.error("RepositoryException", (Throwable)e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Try to add file {} - already exists", (Object)path);
            }
        }
        catch (RepositoryException e) {
            logger.debug("Cannot add file", (Throwable)e);
        }
    }

    private void importSiteProperties(InputStream is, JahiaSite site, JCRSessionWrapper session) throws IOException {
        if (site.getSiteKey().equals("systemsite")) {
            return;
        }
        logger.info("Loading properties for site {}", (Object)site.getSiteKey());
        long timer = System.currentTimeMillis();
        Properties p = new Properties();
        p.load(is);
        this.importSiteProperties(site, p, session);
        logger.info("Done loading properties for site {} in {}", (Object)site.getSiteKey(), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFilesAcl(JahiaSite site, Resource file, InputStream is, DefinitionsMapping mapping, List<String> fileList) {
        HashMap<String, File> filePath = new HashMap<String, File>();
        File temp = null;
        try {
            Path tempPath = Files.createTempDirectory("migration", new FileAttribute[0]);
            temp = tempPath.toFile();
            ZipInputStream zis = this.getZipInputStream(file);
            try {
                ZipEntry zipentry;
                while ((zipentry = zis.getNextEntry()) != null) {
                    String fileName = zipentry.getName();
                    if (!zipentry.isDirectory()) {
                        fileName = fileName.replace('\\', '/');
                        File newFile = new File(temp, fileName);
                        newFile.getParentFile().mkdirs();
                        FileUtils.copyInputStreamToFile((InputStream)zis, (File)newFile);
                        filePath.put("/" + fileName, newFile);
                    }
                    zis.closeEntry();
                }
            }
            finally {
                this.closeInputStream(zis);
            }
            this.handleImport(is, new FilesAclImportHandler(site, mapping, file, fileList, filePath), file.getFilename());
        }
        catch (IOException e) {
            try {
                logger.error("Cannot extract zip", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(temp);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)temp);
        }
        FileUtils.deleteQuietly((File)temp);
    }

    private void importSiteProperties(JahiaSite site, Properties p, JCRSessionWrapper session) {
        Set<Object> keys = p.keySet();
        HashSet<String> languages = new HashSet<String>();
        HashSet<String> inactiveLanguages = new HashSet<String>();
        HashSet<String> inactiveLiveLanguages = new HashSet<String>();
        HashSet<String> mandatoryLanguages = new HashSet<String>();
        List<String> installedModules = site.getInstalledModules();
        try {
            installedModules = this.sitesService.getSiteByKey(site.getSiteKey(), session).getInstalledModules();
        }
        catch (RepositoryException e) {
            logger.error("Cannot get installed modules ", (Throwable)e);
        }
        String templateSet = site.getTemplateFolder();
        JahiaTemplateManagerService templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        try {
            if (!installedModules.contains(templateSet)) {
                templateManagerService.installModule(templateManagerService.getAnyDeployedTemplatePackage(templateSet), "/sites/" + site.getSiteKey(), session);
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot deploy module " + templateSet, (Throwable)e);
        }
        String defaultLanguage = null;
        String lowestRankLanguage = null;
        int currentRank = 0;
        ArrayList<JahiaTemplatesPackage> modules = new ArrayList<JahiaTemplatesPackage>();
        for (Object key : keys) {
            String property = (String)key;
            String value = p.getProperty(property);
            StringTokenizer st = new StringTokenizer(property, ".");
            String firstKey = st.nextToken();
            try {
                if (firstKey.equals("language")) {
                    String lang = st.nextToken();
                    if (languages.contains(lang)) continue;
                    languages.add(lang);
                    if (!Boolean.valueOf(p.getProperty("language." + lang + ".activated", "true")).booleanValue()) {
                        inactiveLiveLanguages.add(lang);
                    }
                    if (Boolean.valueOf(p.getProperty("language." + lang + ".disabledCompletely", "false")).booleanValue()) {
                        inactiveLanguages.add(lang);
                        languages.remove(lang);
                    }
                    if (Boolean.valueOf(p.getProperty("language." + lang + ".mandatory", "false")).booleanValue()) {
                        mandatoryLanguages.add(lang);
                    }
                    if (inactiveLanguages.contains(lang) || !StringUtils.isEmpty((String)lowestRankLanguage) && !p.containsKey("language." + lang + ".rank")) continue;
                    int langRank = NumberUtils.toInt((String)p.getProperty("language." + lang + ".rank"));
                    if (currentRank != 0 && langRank >= currentRank) continue;
                    currentRank = langRank;
                    lowestRankLanguage = lang;
                    continue;
                }
                if (firstKey.equals("defaultLanguage")) {
                    defaultLanguage = value;
                    continue;
                }
                if (firstKey.equals("mixLanguage")) {
                    site.setMixLanguagesActive(Boolean.parseBoolean(value));
                    continue;
                }
                if (firstKey.equals("allowsUnlistedLanguages")) {
                    site.setAllowsUnlistedLanguages(Boolean.parseBoolean(value));
                    continue;
                }
                if (firstKey.equals("description")) {
                    site.setDescription(value);
                    continue;
                }
                if (firstKey.startsWith("defaultSite") && "true".equals(value) && this.sitesService.getDefaultSite(session) == null) {
                    this.sitesService.setDefaultSite(site, session);
                    continue;
                }
                if (!firstKey.equals("installedModules") || installedModules.contains(value) || templateSet.equals(value)) continue;
                JahiaTemplatesPackage pkg = templateManagerService.getAnyDeployedTemplatePackage(value);
                if (pkg != null) {
                    modules.add(pkg);
                    continue;
                }
                logger.info("unable to find module {} in deployed modules", (Object)value);
            }
            catch (RepositoryException e) {
                logger.error("Cannot set site property  " + firstKey, (Throwable)e);
            }
        }
        ListOrderedSet siteLangs = ListOrderedSet.decorate(new LinkedList(languages));
        if (!siteLangs.isEmpty()) {
            site.setLanguages((Set<String>)siteLangs);
            site.setInactiveLanguages(inactiveLanguages);
            site.setInactiveLiveLanguages(inactiveLiveLanguages);
            site.setMandatoryLanguages(mandatoryLanguages);
            if (defaultLanguage == null) {
                defaultLanguage = StringUtils.isEmpty(lowestRankLanguage) ? (String)siteLangs.iterator().next() : lowestRankLanguage;
            }
            site.setDefaultLanguage(defaultLanguage);
        } else {
            logger.error("Unable to find site languages in the provided site.properties descriptor. Skip importing site settings.");
        }
        try {
            templateManagerService.installModules(modules, "/sites/" + site.getSiteKey(), session);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error("Cannot deploy module " + modules, (Throwable)e);
        }
    }

    private List<String[]> importCategoriesAndGetUuidProps(InputStream is, CategoriesImportHandler importHandler) {
        this.handleImport(is, importHandler, null);
        return importHandler.getUuidProps();
    }

    @Override
    public void importCategories(Category rootCategory, InputStream is) {
        CategoriesImportHandler importHandler = new CategoriesImportHandler();
        importHandler.setRootCategory(rootCategory);
        this.importCategoriesAndGetUuidProps(is, importHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String[]> importUsers(final File file) throws IOException, RepositoryException {
        final BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            List<String[]> list = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<List<String[]>>(){

                @Override
                public List<String[]> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    List l = ImportExportBaseService.this.importUsers(is, new UsersImportHandler(session), file.getName());
                    session.save();
                    return l;
                }
            });
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private List<String[]> importUsers(InputStream is, UsersImportHandler importHandler) {
        return this.importUsers(is, importHandler, USERS_XML);
    }

    private List<String[]> importUsers(InputStream is, UsersImportHandler importHandler, String fileName) {
        long timer = System.currentTimeMillis();
        logger.info("Start importing users");
        this.handleImport(is, importHandler, fileName);
        logger.info("Done importing users in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
        return importHandler.getUuidProps();
    }

    private void handleImport(InputStream is, DefaultHandler h, String fileName) {
        try {
            DocumentViewImportHandler dh;
            SAXParser parser = JahiaSAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, h);
            if (h instanceof DocumentViewImportHandler && (dh = (DocumentViewImportHandler)h).getMissingDependencies().size() > 0) {
                for (String s : dh.getMissingDependencies()) {
                    logger.error("Dependency not declared : " + s + " (set debug on DocumentViewImportHandler for more details)");
                }
            }
        }
        catch (SAXParseException e) {
            logger.error("Cannot import - File contains invalid XML", (Throwable)e);
            throw new RuntimeException("Cannot import " + (fileName != null ? fileName : "") + " file as it contains invalid XML", e);
        }
        catch (Exception e) {
            logger.error("Cannot import", (Throwable)e);
            throw new RuntimeException("Cannot import " + (fileName != null ? fileName : "") + " file", e);
        }
    }

    public int detectXmlFormat(InputStream is) {
        XMLFormatDetectionHandler handler = new XMLFormatDetectionHandler();
        try {
            SAXParser parser = JahiaSAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.getType();
    }

    @Override
    public void importXML(String parentNodePath, InputStream content, int rootBehavior) throws IOException, RepositoryException, JahiaException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        this.importXML(parentNodePath, content, rootBehavior, references, session);
        ReferencesHelper.resolveCrossReferences(session, references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importXML(String parentNodePath, InputStream content, int rootBehavior, Map<String, List<String>> references, JCRSessionWrapper session) throws IOException, RepositoryException, JahiaException {
        File tempFile = null;
        try {
            int format;
            tempFile = File.createTempFile("import-xml-", ".xml");
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)content, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));
            try {
                format = this.detectXmlFormat(inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            switch (format) {
                case 2: {
                    BufferedInputStream is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(tempFile));
                        session.importXML(parentNodePath, is, 0, rootBehavior, null, references);
                        session.save(13);
                    }
                    catch (IOException e) {
                        try {
                            throw new RepositoryException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    return;
                }
                case 4: {
                    this.importUsers(tempFile);
                    return;
                }
                case 5: {
                    Category cat = this.categoryService.getCategoryByPath(parentNodePath);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile));
                    try {
                        this.importCategories(cat, is);
                        return;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
            }
            return;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehavior) throws IOException, RepositoryException {
        JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession(null, null, null);
        this.importZip(parentNodePath, file, rootBehavior, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationResults validateImportFile(JCRSessionWrapper session, InputStream is, String contentType, List<String> installedModules) {
        DocumentViewValidationHandler documentViewValidationHandler = (DocumentViewValidationHandler)SpringContextSingleton.getBean("DocumentViewValidationHandler");
        if (installedModules != null && !installedModules.isEmpty()) {
            documentViewValidationHandler.initDependencies(installedModules.get(0), installedModules.size() > 1 ? installedModules.subList(1, installedModules.size()) : null);
        }
        documentViewValidationHandler.setSession(session);
        if (contentType.equals("application/zip")) {
            NoCloseZipInputStream zis = new NoCloseZipInputStream(new BufferedInputStream(is));
            try {
                ZipEntry zipentry = zis.getNextEntry();
                while (zipentry != null) {
                    String name = zipentry.getName();
                    if (name.endsWith("xml")) {
                        this.handleImport(zis, documentViewValidationHandler, name);
                    }
                    zipentry = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                logger.error("Cannot import", (Throwable)e);
            }
            finally {
                try {
                    zis.reallyClose();
                }
                catch (IOException e) {
                    logger.error("Cannot import", (Throwable)e);
                }
            }
        } else {
            try {
                this.handleImport(is, documentViewValidationHandler, null);
            }
            catch (Exception e) {
                ValidationResults results = new ValidationResults();
                results.addResult(new ValidationResult.FailedValidationResult(e));
                ValidationResults validationResults = results;
                return validationResults;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return documentViewValidationHandler.getResults();
    }

    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehaviour, JCRSessionWrapper session) throws IOException, RepositoryException {
        this.importZip(parentNodePath, file, rootBehaviour, session, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehaviour, JCRSessionWrapper session, Set<String> filesToIgnore, boolean useReferenceKeeper) throws IOException, RepositoryException {
        Object props;
        DocumentViewImportHandler documentViewImportHandler;
        String name;
        ZipEntry zipentry;
        ZipInputStream zis;
        long timer = System.currentTimeMillis();
        if (filesToIgnore == null) {
            filesToIgnore = Collections.emptySet();
        }
        logger.info("Start importing file {} into path {} ", (Object)file, (Object)(parentNodePath != null ? parentNodePath : "/"));
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        ArrayList<String> fileList = new ArrayList<String>();
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        this.getFileList(file, sizes, fileList);
        Map<String, String> pathMapping = session.getPathMapping();
        for (JahiaTemplatesPackage pkg : this.templatePackageRegistry.getRegisteredModules().values()) {
            String key = "/modules/" + pkg.getId() + "/";
            if (pathMapping.containsKey(key)) continue;
            pathMapping.put(key, "/modules/" + pkg.getId() + "/" + pkg.getVersion() + "/");
        }
        boolean importLive = sizes.containsKey(LIVE_REPOSITORY_XML);
        List<String> liveUuids = null;
        if (importLive) {
            zis = this.getZipInputStream(file);
            try {
                while ((zipentry = zis.getNextEntry()) != null) {
                    name = zipentry.getName();
                    if (name.equals(LIVE_REPOSITORY_XML) && !filesToIgnore.contains(name)) {
                        long timerLive = System.currentTimeMillis();
                        logger.info("Start importing live-repository.xml");
                        documentViewImportHandler = new DocumentViewImportHandler(session, parentNodePath, file, fileList);
                        documentViewImportHandler.setReferences(references);
                        documentViewImportHandler.setRootBehavior(rootBehaviour);
                        documentViewImportHandler.setBaseFilesPath("/live-content");
                        documentViewImportHandler.setAttributeProcessors(this.attributeProcessors);
                        props = new HashSet<String>(documentViewImportHandler.getPropertiesToSkip());
                        props.remove("j:lastPublished");
                        props.remove("j:lastPublishedBy");
                        props.remove("j:published");
                        documentViewImportHandler.setPropertiesToSkip((Set<String>)props);
                        this.handleImport(zis, documentViewImportHandler, LIVE_REPOSITORY_XML);
                        logger.debug("Saving JCR session for live-repository.xml");
                        session.save(13);
                        if (rootBehaviour == 2) {
                            rootBehaviour = 1;
                        }
                        logger.debug("Resolving cross-references for live-repository.xml");
                        ReferencesHelper.resolveCrossReferences(session, references, useReferenceKeeper, true);
                        logger.debug("Saving JCR session for live-repository.xml");
                        session.save(13);
                        liveUuids = documentViewImportHandler.getUuids();
                        logger.debug("Publishing...");
                        final JCRPublicationService publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
                        final List<String> toPublish = documentViewImportHandler.getUuids();
                        JCRObservationManager.doWithOperationType(null, 13, new JCRCallback<Object>(){

                            @Override
                            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                                publicationService.publish(toPublish, "default", "live", false, false, null);
                                return null;
                            }
                        });
                        logger.debug("publishing done");
                        String label = "published_at_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(GregorianCalendar.getInstance().getTime());
                        JCRVersionService.getInstance().addVersionLabel(toPublish, label, "live");
                        logger.info("Done importing live-repository.xml in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerLive));
                        break;
                    }
                    zis.closeEntry();
                }
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Cannot import", (Throwable)e);
            }
            finally {
                this.closeInputStream(zis);
            }
        }
        zis = this.getZipInputStream(file);
        try {
            while ((zipentry = zis.getNextEntry()) != null) {
                name = zipentry.getName();
                if (name.equals(REPOSITORY_XML) && !filesToIgnore.contains(name)) {
                    long timerDefault = System.currentTimeMillis();
                    logger.info("Start importing repository.xml");
                    documentViewImportHandler = new DocumentViewImportHandler(session, parentNodePath, file, fileList);
                    if (importLive) {
                        props = new HashSet<String>(documentViewImportHandler.getPropertiesToSkip());
                        props.remove("j:lastPublished");
                        props.remove("j:lastPublishedBy");
                        props.remove("j:published");
                        documentViewImportHandler.setPropertiesToSkip((Set<String>)props);
                        documentViewImportHandler.setEnforceUuid(true);
                        documentViewImportHandler.setUuidBehavior(4);
                        documentViewImportHandler.setReplaceMultipleValues(true);
                        documentViewImportHandler.setRemoveMixins(true);
                    }
                    documentViewImportHandler.setReferences(references);
                    documentViewImportHandler.setRootBehavior(rootBehaviour);
                    documentViewImportHandler.setAttributeProcessors(this.attributeProcessors);
                    this.handleImport(zis, documentViewImportHandler, REPOSITORY_XML);
                    if (importLive && liveUuids != null) {
                        liveUuids.removeAll(documentViewImportHandler.getUuids());
                        Collections.reverse(liveUuids);
                        for (String uuid : liveUuids) {
                            try {
                                JCRNodeWrapper nodeToRemove = session.getNodeByIdentifier(uuid);
                                nodeToRemove.remove();
                            }
                            catch (InvalidItemStateException | ItemNotFoundException ex) {
                                logger.debug("Node to remove has already been removed", ex);
                            }
                        }
                    }
                    logger.debug("Saving JCR session for repository.xml");
                    session.save(13);
                    logger.info("Done importing repository.xml in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerDefault));
                } else if (!(!name.endsWith(".xml") || name.equals(REPOSITORY_XML) || name.equals(LIVE_REPOSITORY_XML) || filesToIgnore.contains(name) || name.contains("/"))) {
                    long timerOther = System.currentTimeMillis();
                    logger.info("Start importing {}", (Object)name);
                    String thisPath = (parentNodePath != null ? parentNodePath + (parentNodePath.endsWith("/") ? "" : "/") : "") + StringUtils.substringBefore((String)name, (String)".xml");
                    this.importXML(thisPath, zis, rootBehaviour, references, session);
                    logger.info("Done importing {} in {}", (Object)name, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerOther));
                }
                zis.closeEntry();
                RenderContext r = TemplateModuleInterceptor.renderContextThreadLocal.get();
                TemplateModuleInterceptor.renderContextThreadLocal.remove();
                ReferencesHelper.resolveCrossReferences(session, references, useReferenceKeeper);
                TemplateModuleInterceptor.renderContextThreadLocal.set(r);
                session.save(13);
            }
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Cannot import", (Throwable)e);
        }
        finally {
            this.closeInputStream(zis);
        }
        if (importLive) {
            zis = this.getZipInputStream(file);
            try {
                while ((zipentry = zis.getNextEntry()) != null) {
                    name = zipentry.getName();
                    if (name.equals(LIVE_REPOSITORY_XML) && this.jcrStoreService.getSessionFactory().getCurrentUser() != null) {
                        long timerUGC = System.currentTimeMillis();
                        logger.info("Start importing user generated content");
                        JCRSessionWrapper liveSession = this.jcrStoreService.getSessionFactory().getCurrentUserSession("live", null, null);
                        DocumentViewImportHandler documentViewImportHandler2 = new DocumentViewImportHandler(liveSession, parentNodePath, file, fileList);
                        documentViewImportHandler2.setImportUserGeneratedContent(true);
                        documentViewImportHandler2.setRootBehavior(rootBehaviour);
                        documentViewImportHandler2.setBaseFilesPath("/live-content");
                        documentViewImportHandler2.setAttributeProcessors(this.attributeProcessors);
                        liveSession.getPathMapping().putAll(pathMapping);
                        this.handleImport(zis, documentViewImportHandler2, LIVE_REPOSITORY_XML);
                        logger.debug("Saving JCR session for UGC");
                        liveSession.save(13);
                        logger.info("Done importing user generated content in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerUGC));
                        break;
                    }
                    zis.closeEntry();
                }
            }
            catch (Exception e) {
                logger.error("Cannot import", (Throwable)e);
            }
            finally {
                this.closeInputStream(zis);
            }
        }
        this.cleanFilesList(fileList);
        logger.info("Done importing file {} in {}", (Object)file, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileList(Resource file, Map<String, Long> sizes, List<String> fileList) throws IOException {
        ZipInputStream zis = this.getZipInputStream(file);
        try {
            ZipEntry zipentry;
            while ((zipentry = zis.getNextEntry()) != null) {
                String name = zipentry.getName().replace('\\', '/');
                if (this.expandImportedFilesOnDisk) {
                    File file1 = new File(this.expandImportedFilesOnDiskPath + File.separator + name);
                    if (zipentry.isDirectory()) {
                        file1.mkdirs();
                    } else {
                        long timer = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Expanding {} into {}", (Object)zipentry.getName(), (Object)file1);
                        }
                        file1.getParentFile().mkdirs();
                        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file1), 65536);){
                            IOUtils.copyLarge((InputStream)zis, (OutputStream)output);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Expanded {} in {}", (Object)zipentry.getName(), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
                            }
                        }
                    }
                }
                if (name.endsWith(".xml")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(zis));
                    try {
                        long i = 0L;
                        while (br.readLine() != null) {
                            ++i;
                        }
                        sizes.put(name, i);
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)br);
                    }
                } else {
                    sizes.put(name, zipentry.getSize());
                }
                if (name.contains("/")) {
                    fileList.add("/" + name);
                }
                zis.closeEntry();
            }
        }
        finally {
            this.closeInputStream(zis);
        }
    }

    private void closeInputStream(ZipInputStream zis) throws IOException {
        if (zis instanceof NoCloseZipInputStream) {
            ((NoCloseZipInputStream)zis).reallyClose();
        } else {
            zis.close();
        }
    }

    private ZipInputStream getZipInputStream(Resource file) throws IOException {
        ZipInputStream zis = !file.isReadable() && file instanceof FileSystemResource ? new DirectoryZipInputStream(file.getFile()) : new NoCloseZipInputStream(new BufferedInputStream(file.getInputStream()));
        return zis;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setXmlContentTransformers(List<XMLContentTransformer> xmlContentTransformers) {
        this.xmlContentTransformers = xmlContentTransformers;
    }

    public void setLegacyPidMappingTool(LegacyPidMappingTool legacyPidMappingTool) {
        this.legacyPidMappingTool = legacyPidMappingTool;
    }

    public void setPostImportPatcher(PostImportPatcher postImportPatcher) {
        this.postImportPatcher = postImportPatcher;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry templatePackageRegistry) {
        this.templatePackageRegistry = templatePackageRegistry;
    }

    private String getDuration(long start) {
        return DateUtils.formatDurationWords(System.currentTimeMillis() - start);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ExportContext && o instanceof DocumentViewExporter) {
            ExportContext exportContext = (ExportContext)arg;
            DocumentViewExporter documentViewExporter = (DocumentViewExporter)o;
            exportContext.setExportIndex(exportContext.getExportIndex() + 1);
            logger.debug("Index: " + exportContext.getExportIndex() + ", Exporting  : " + exportContext.getActualPath());
            long currentStep = (long)(exportContext.getExportIndex() * 10) / exportContext.getNodesToExport();
            if (currentStep > exportContext.getStep() && exportContext.getStep() < 9L) {
                exportContext.setStep(currentStep);
                logger.info("Export " + exportContext.getStep() * 10L + "%");
                documentViewExporter.setExportContext(exportContext);
            }
        }
    }

    private class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = -2418536708883832686L;
        Vector<Object> keys = new Vector();

        private OrderedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public Enumeration<Object> keys() {
            return this.keys.elements();
        }
    }

    class ImportFileObserver
    implements Observer {
        public ImportFileObserver(String path, boolean checkDate, long interval, boolean fileOnly) throws JahiaException {
            if (ImportExportBaseService.this.fileWatcherService != null) {
                try {
                    ImportExportBaseService.this.fileWatcherService.addFileWatcher(path, path, checkDate, interval, fileOnly);
                    ImportExportBaseService.this.fileWatcherService.registerObserver(path, this);
                    ImportExportBaseService.this.fileWatcherService.startFileWatcher(path);
                }
                catch (JahiaException e) {
                    logger.error("init:: ", (Throwable)e);
                    throw new JahiaInitializationException("ImportObserver::init failed ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Observable observable, Object args) {
            Object object = args;
            synchronized (object) {
                final List files = (List)args;
                if (!files.isEmpty()) {
                    try {
                        JahiaUser user = JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser();
                        JCRSessionFactory.getInstance().setCurrentUser(user);
                        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, null, null, new JCRCallback<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                                JCRNodeWrapper dest = session.getNode("/imports");
                                for (File file : files) {
                                    try {
                                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                                        try {
                                            dest.uploadFile(file.getName(), is, JCRContentUtils.getMimeType(file.getName()));
                                        }
                                        finally {
                                            IOUtils.closeQuietly((InputStream)is);
                                        }
                                    }
                                    catch (Exception t) {
                                        logger.error("file observer error : ", (Throwable)t);
                                    }
                                }
                                session.save();
                                return null;
                            }
                        });
                    }
                    catch (RepositoryException e) {
                        logger.error("error", (Throwable)e);
                    }
                    finally {
                        JCRSessionFactory.getInstance().setCurrentUser(null);
                    }
                    for (File file : files) {
                        file.delete();
                    }
                }
            }
        }
    }

    private static class Holder {
        static final ImportExportBaseService INSTANCE = new ImportExportBaseService();

        private Holder() {
        }
    }
}

