/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.rules.Service;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SiteImportJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    public static final String NODEPATH = "nodepath";

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(jobDataMap.getString(NODEPATH));
        JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        String uri = node.getPath();
        String name = node.getName();
        StringTokenizer st = new StringTokenizer(name, "_");
        String type = st.nextToken();
        if (type.equals("siteImport")) {
            try {
                logger.info("Import site " + uri);
                if (!user.isRoot()) {
                    return;
                }
                ImportExportBaseService.getInstance().importSiteZip(node);
            }
            catch (Exception e) {
                logger.error("Error during import of file " + uri, (Throwable)e);
                ServicesRegistry.getInstance().getCacheService().flushAllCaches();
            }
        } else if (name.endsWith(".zip")) {
            try {
                this.processFileImport(this.prepareFileImports(node, node.getName()), user);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (ServletException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (JahiaException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (name.endsWith(".xml")) {
            JCRSessionWrapper session = node.getSession();
            try {
                session.importXML("/", node.getFileContent().downloadFile(), 0, 0);
                session.save();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<Object, Object>> prepareFileImports(JCRNodeWrapper node, String name) {
        try {
            ZipEntry z;
            Properties exportProps = new Properties();
            JCRNodeWrapper contentNode = node.getNode("jcr:content");
            ZipInputStream zis = new ZipInputStream(contentNode.getProperty("jcr:data").getBinary().getStream());
            HashMap<File, String> imports = new HashMap<File, String>();
            ArrayList<File> importList = new ArrayList<File>();
            while ((z = zis.getNextEntry()) != null) {
                File i = File.createTempFile("import", ".zip");
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(i));
                try {
                    IOUtils.copy((InputStream)zis, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                }
                String n = z.getName();
                if (n.equals("export.properties")) {
                    Object is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(i), 1024);
                        exportProps.load((InputStream)is);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        FileUtils.deleteQuietly((File)i);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    FileUtils.deleteQuietly((File)i);
                    continue;
                }
                if (n.equals("classes.jar")) {
                    FileUtils.deleteQuietly((File)i);
                    continue;
                }
                if (n.equals("site.properties") || n.startsWith("export_") && n.endsWith(".xml")) {
                    FileUtils.deleteQuietly((File)i);
                    for (File file : imports.keySet()) {
                        FileUtils.deleteQuietly((File)file);
                    }
                    imports.clear();
                    importList.clear();
                    File tempFile = File.createTempFile("import", ".zip");
                    InputStream is = contentNode.getProperty("jcr:data").getBinary().getStream();
                    BufferedOutputStream tos = new BufferedOutputStream(new FileOutputStream(tempFile));
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)tos);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly((OutputStream)tos);
                    }
                    imports.put(tempFile, name);
                    importList.add(tempFile);
                    break;
                }
                imports.put(i, n);
                importList.add(i);
            }
            ArrayList<Map<Object, Object>> importsInfos = new ArrayList<Map<Object, Object>>();
            Map<Object, Object> users = null;
            Map<Object, Object> serverPermissions = null;
            for (File i : importList) {
                String fileName = (String)imports.get(i);
                Map<Object, Object> value = this.prepareSiteImport(i, (String)imports.get(i));
                if (value == null) continue;
                if ("users.xml".equals(fileName) || "users.zip".equals(fileName)) {
                    users = value;
                    continue;
                }
                if ("serverPermissions.xml".equals(fileName)) {
                    serverPermissions = value;
                    continue;
                }
                importsInfos.add(value);
            }
            if (serverPermissions != null) {
                importsInfos.add(0, serverPermissions);
            }
            if (users != null) {
                importsInfos.add(0, users);
            }
            return importsInfos;
        }
        catch (IOException e) {
            logger.error("Cannot read import file :" + e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Map<Object, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> prepareSiteImport(File i, String filename) throws IOException {
        HashMap<Object, Object> importInfos = new HashMap<Object, Object>();
        importInfos.put("importFile", i);
        importInfos.put("importFileName", filename);
        importInfos.put("selected", Boolean.TRUE);
        if (filename.endsWith(".xml")) {
            importInfos.put("type", "xml");
        } else {
            ZipInputStream zis2 = new ZipInputStream(new BufferedInputStream(new FileInputStream(i)));
            boolean isSite = false;
            boolean isLegacySite = false;
            try {
                ZipEntry z;
                while ((z = zis2.getNextEntry()) != null) {
                    if ("site.properties".equals(z.getName())) {
                        Properties p = new Properties();
                        p.load(zis2);
                        zis2.closeEntry();
                        importInfos.putAll(p);
                        importInfos.put("templates", importInfos.containsKey("templatePackageName") ? importInfos.get("templatePackageName") : "");
                        importInfos.put("oldsitekey", importInfos.get("sitekey"));
                        isSite = true;
                        continue;
                    }
                    if (!z.getName().startsWith("export_")) continue;
                    isLegacySite = true;
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zis2);
            }
            importInfos.put("isSite", isSite);
            if (isSite || isLegacySite) {
                importInfos.put("type", "site");
                if (!importInfos.containsKey("sitekey")) {
                    importInfos.put("sitekey", "");
                    importInfos.put("siteservername", "");
                    importInfos.put("sitetitle", "");
                    importInfos.put("description", "");
                    importInfos.put("mixLanguage", "false");
                    importInfos.put("templates", "");
                    importInfos.put("siteKeyExists", Boolean.TRUE);
                    importInfos.put("siteServerNameExists", Boolean.TRUE);
                } else {
                    try {
                        JahiaSitesService sitesService = ServicesRegistry.getInstance().getJahiaSitesService();
                        importInfos.put("siteKeyExists", sitesService.getSiteByKey((String)importInfos.get("sitekey")) != null || "".equals(importInfos.get("sitekey")));
                        importInfos.put("siteServerNameExists", sitesService.getSite((String)importInfos.get("siteservername")) != null || "".equals(importInfos.get("siteservername")));
                    }
                    catch (JahiaException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                importInfos.put("type", "files");
            }
        }
        return importInfos;
    }

    private void processFileImport(List<Map<Object, Object>> importsInfos, JahiaUser user) throws IOException, RepositoryException, ServletException, JahiaException {
        File file;
        for (Map<Object, Object> infos : importsInfos) {
            file = (File)infos.get("importFile");
            if (!infos.get("importFileName").equals("users.xml")) continue;
            ImportExportBaseService.getInstance().importUsers(file);
            break;
        }
        for (Map<Object, Object> infos : importsInfos) {
            file = (File)infos.get("importFile");
            if (file != null && infos.get("type").equals("files")) {
                try {
                    ImportExportBaseService.getInstance().importSiteZip((Resource)new FileSystemResource(file), null, infos);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (infos.get("type").equals("xml") && (infos.get("importFileName").equals("serverPermissions.xml") || infos.get("importFileName").equals("users.xml")) || !infos.get("type").equals("site")) continue;
            String tpl = (String)infos.get("templates");
            if ("".equals(tpl)) {
                tpl = null;
            }
            try {
                SiteCreationInfo siteCreationInfo = SiteCreationInfo.builder().siteKey((String)infos.get("sitekey")).serverName((String)infos.get("siteservername")).serverNameAliases((String)infos.get("siteservernamealiases")).title((String)infos.get("sitetitle")).description("").templateSet(tpl).modulesToDeploy(null).locale(infos.containsKey("defaultLanguage") ? (String)infos.get("defaultLanguage") : SettingsBean.getInstance().getDefaultLanguageCode()).siteAdmin(user).firstImport("fileImport").fileImport((Resource)(file == null ? null : new FileSystemResource(file))).fileImportName((String)infos.get("importFileName")).originatingJahiaRelease((String)infos.get("originatingJahiaRelease")).build();
                ServicesRegistry.getInstance().getJahiaSitesService().addSite(siteCreationInfo);
            }
            catch (Exception e) {
                logger.error("Cannot create site " + infos.get("sitetitle"), (Throwable)e);
            }
        }
    }
}

