/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidModuleException;
import org.jahia.services.modulemanager.InvalidModuleKeyException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.OperationResult;
import org.jahia.services.modulemanager.persistence.BundlePersister;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.persistence.PersistentBundleInfoBuilder;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ModuleManagerImpl
implements ModuleManager,
ReadOnlyModeCapable {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private BundleService bundleService;
    private BundlePersister persister;
    private JahiaTemplateManagerService templateManagerService;
    private volatile boolean readOnly;

    private static BundleInfo toBundleInfo(PersistentBundle persistentBundle) {
        return new BundleInfo(persistentBundle.getGroupId(), persistentBundle.getSymbolicName(), persistentBundle.getVersion());
    }

    private BundleInfo findTargetBundle(String bundleKey, String symbolicName, String version) {
        Bundle[] allBundles;
        BundleInfo targetInfo = null;
        ArrayList<Bundle> matches = new ArrayList<Bundle>();
        for (Bundle b : allBundles = FrameworkService.getBundleContext().getBundles()) {
            if (!symbolicName.equals(b.getSymbolicName()) || version != null && !version.equals(b.getVersion().toString()) || b.getState() == 1) continue;
            matches.add(b);
        }
        if (matches.size() > 1) {
            logger.warn("Found multiple bundles matching the key {}. Unable to uniquely identify target bundle", (Object)bundleKey);
        } else if (!matches.isEmpty()) {
            Bundle target = (Bundle)matches.get(0);
            targetInfo = new BundleInfo(BundleUtils.getModuleGroupId(target), target.getSymbolicName(), target.getVersion().toString());
        }
        return targetInfo;
    }

    private BundleInfo getBundleInfoGuessIfNeeded(String bundleKey) {
        BundleInfo info = null;
        if (bundleKey.indexOf(47) != -1 && (info = BundleInfo.fromKey(bundleKey)).getGroupId() != null && info.getSymbolicName() != null && info.getVersion() != null) {
            return info;
        }
        return this.findTargetBundle(bundleKey, info != null ? info.getSymbolicName() : bundleKey, info != null ? info.getVersion() : null);
    }

    private static BundleInfo getBundleInfo(String bundleKey) {
        try {
            return BundleInfo.fromKey(bundleKey);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModuleKeyException(bundleKey);
        }
    }

    private OperationResult doInstall(Collection<PersistentBundle> infos, String target, boolean start) throws ModuleManagementException {
        ArrayList<BundleInfo> bundleInfos = new ArrayList<BundleInfo>(infos.size());
        for (PersistentBundle info : infos) {
            this.bundleService.install(info.getLocation(), target, false);
            bundleInfos.add(ModuleManagerImpl.toBundleInfo(info));
        }
        if (start) {
            for (PersistentBundle info : infos) {
                this.stopPreviousVersions(info, target);
            }
            for (PersistentBundle info : infos) {
                this.bundleService.start(info, target);
            }
            this.refreshOtherVersions(bundleInfos, target);
        }
        return OperationResult.success(bundleInfos);
    }

    @Override
    public OperationResult install(Resource bundleResource, String target) throws ModuleManagementException {
        return this.install(bundleResource, target, false);
    }

    @Override
    public OperationResult install(Resource bundleResource, String target, boolean start) throws ModuleManagementException {
        return this.install(Collections.singleton(bundleResource), target, start);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperationResult install(Collection<Resource> bundleResources, String target, boolean start) throws ModuleManagementException {
        long startTime = System.currentTimeMillis();
        logger.info("Performing installation of bundles {} on target {}", bundleResources, (Object)target);
        OperationResult result = null;
        Exception error = null;
        try {
            this.assertWritable();
            ArrayList<PersistentBundle> bundleInfos = new ArrayList<PersistentBundle>(bundleResources.size());
            Iterator<Resource> iterator = bundleResources.iterator();
            while (iterator.hasNext()) {
                Resource bundleResource;
                boolean requiresPersisting = !((bundleResource = iterator.next()) instanceof UrlResource) || !bundleResource.getURL().getProtocol().equals("dx");
                PersistentBundle bundleInfo = PersistentBundleInfoBuilder.build(bundleResource, requiresPersisting, requiresPersisting);
                if (bundleInfo == null) {
                    throw new InvalidModuleException();
                }
                if (requiresPersisting) {
                    this.persister.store(bundleInfo);
                }
                bundleInfos.add(bundleInfo);
            }
            result = this.doInstall(bundleInfos, target, start);
        }
        catch (ModuleManagementException e) {
            try {
                error = e;
                throw e;
                catch (Exception e2) {
                    error = e2;
                    throw new ModuleManagementException(e2);
                }
            }
            catch (Throwable throwable) {
                long timeTaken = System.currentTimeMillis() - startTime;
                if (error == null) {
                    logger.info("Installation completed for bundles {} on target {} in {} ms. Operation result: {}", new Object[]{bundleResources, target, timeTaken, result});
                    throw throwable;
                }
                logger.info("Installation failed for bundles {} on target {} (took {} ms). Operation error: {}", new Object[]{bundleResources, target, timeTaken, error});
                throw throwable;
            }
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        if (error == null) {
            logger.info("Installation completed for bundles {} on target {} in {} ms. Operation result: {}", new Object[]{bundleResources, target, timeTaken, result});
            return result;
        }
        logger.info("Installation failed for bundles {} on target {} (took {} ms). Operation error: {}", new Object[]{bundleResources, target, timeTaken, error});
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationResult performOperation(String bundleKey, String target, BundleOperation operation) {
        Exception error;
        OperationResult result;
        long startTime;
        block9: {
            if (StringUtils.isEmpty((CharSequence)bundleKey)) {
                throw new IllegalArgumentException("Bundle '" + bundleKey + "' key in invalid");
            }
            startTime = System.currentTimeMillis();
            logger.info("Performing {} operation for bundle {} on target {}", new Object[]{operation.getName(), bundleKey, target});
            result = null;
            BundleInfo info = null;
            error = null;
            try {
                if (operation.changesModuleState()) {
                    this.assertWritable();
                }
                if ((info = this.getBundleInfoGuessIfNeeded(bundleKey)) == null) {
                    throw new ModuleNotFoundException(bundleKey);
                }
                operation.perform(info, target);
                result = OperationResult.success(info);
                if (error != null) break block9;
            }
            catch (ModuleManagementException e) {
                try {
                    error = e;
                    throw e;
                    catch (Exception e2) {
                        error = e2;
                        throw new ModuleManagementException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (error == null) {
                        logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
                        throw throwable;
                    }
                    logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
                    throw throwable;
                }
            }
            logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
            return result;
        }
        logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
        return result;
    }

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public void setPersister(BundlePersister persister) {
        this.persister = persister;
    }

    @Override
    public OperationResult start(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Start";
            }

            @Override
            public boolean changesModuleState() {
                return true;
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.stopPreviousVersions(info, target);
                ModuleManagerImpl.this.bundleService.start(info, target);
                ModuleManagerImpl.this.refreshOtherVersions(Collections.singleton(info), target);
            }
        });
    }

    @Override
    public OperationResult stop(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Stop";
            }

            @Override
            public boolean changesModuleState() {
                return true;
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.stop(info, target);
            }
        });
    }

    private void stopPreviousVersions(BundleInfo info, String target) {
        Bundle activeBundle;
        JahiaTemplatesPackage activePackage = this.templateManagerService.getTemplatePackageRegistry().lookupById(info.getSymbolicName());
        Bundle bundle = activeBundle = activePackage != null ? activePackage.getBundle() : null;
        if (activeBundle != null && activeBundle.getState() == 32) {
            BundleInfo otherInfo = BundleInfo.fromBundle(activeBundle);
            this.stopExistingVersion(info, otherInfo, target);
        }
        for (Map.Entry<Bundle, ModuleState> entry : this.templateManagerService.getModuleStates().entrySet()) {
            Bundle bundle2 = entry.getKey();
            if (bundle2 == activeBundle || bundle2.getState() != 32 || !bundle2.getSymbolicName().equals(info.getSymbolicName()) || bundle2.getVersion().toString().equals(info.getVersion())) continue;
            BundleInfo otherInfo = BundleInfo.fromBundle(bundle2);
            this.stopExistingVersion(info, otherInfo, target);
        }
    }

    private void stopExistingVersion(BundleInfo info, BundleInfo otherInfo, String target) {
        String key = info.getKey();
        String otherKey = otherInfo.getKey();
        try {
            logger.info("Stopping existing version of the module {} before starting {}...", (Object)otherKey, (Object)key);
            this.bundleService.stop(otherInfo, target);
            logger.info("...done stopping existing version of the module {} before starting {}", (Object)otherKey, (Object)key);
        }
        catch (Exception e) {
            logger.warn("Unable to stop existing version of the module " + otherKey + " before starting " + key, (Throwable)e);
        }
    }

    @Override
    public OperationResult uninstall(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Uninstall";
            }

            @Override
            public boolean changesModuleState() {
                return true;
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.uninstall(info, target);
            }
        });
    }

    @Override
    public OperationResult refresh(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Refresh";
            }

            @Override
            public boolean changesModuleState() {
                return false;
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.refresh(info, target);
            }
        });
    }

    private void refreshOtherVersions(Collection<BundleInfo> theseVersionInfos, String target) {
        LinkedList<Bundle> otherVersions = new LinkedList<Bundle>();
        for (BundleInfo bundleInfo : theseVersionInfos) {
            otherVersions.addAll(this.getOtherVersionsToRefresh(bundleInfo));
        }
        if (otherVersions.isEmpty()) {
            return;
        }
        ArrayList<BundleInfo> otherVersionInfos = new ArrayList<BundleInfo>(otherVersions.size());
        for (Bundle otherVersion : otherVersions) {
            otherVersionInfos.add(BundleInfo.fromBundle(otherVersion));
        }
        logger.info("Refreshing bundles {} as their other versions are currently active...", otherVersionInfos);
        try {
            this.bundleService.refresh(otherVersionInfos, target);
        }
        catch (Exception exception) {
            logger.error("Error refreshing bundles", (Throwable)exception);
        }
    }

    @Override
    public Map<String, BundleService.BundleInformation> getInfo(String bundleKey, String target) throws ModuleManagementException {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getInfo(bundleInfo, target);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(Collection<String> bundleKeys, String target) throws ModuleManagementException {
        LinkedHashSet<BundleInfo> bundleInfos = new LinkedHashSet<BundleInfo>(bundleKeys.size());
        for (String bundleKey : bundleKeys) {
            BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
            bundleInfos.add(bundleInfo);
        }
        return this.bundleService.getInfos(bundleInfos, target);
    }

    @Override
    public BundleState getLocalState(String bundleKey) throws ModuleManagementException {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getLocalState(bundleInfo);
    }

    @Override
    public BundleService.BundleInformation getLocalInfo(String bundleKey) throws ModuleManagementException {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getLocalInfo(bundleInfo);
    }

    private List<Bundle> getOtherVersionsToRefresh(BundleInfo thisVersionInfo) {
        LinkedList<Bundle> result = new LinkedList<Bundle>();
        Map allModuleVersions = this.templateManagerService.getTemplatePackageRegistry().getAllModuleVersions().get(thisVersionInfo.getSymbolicName());
        if (allModuleVersions != null && allModuleVersions.size() > 1) {
            FrameworkWiring frameworkWiring = BundleLifecycleUtils.getFrameworkWiring();
            for (JahiaTemplatesPackage pkg : allModuleVersions.values()) {
                Bundle otherVersion = pkg.getBundle();
                if (otherVersion == null || otherVersion.getState() != 4 || otherVersion.getVersion().toString().equals(thisVersionInfo.getVersion())) continue;
                Collection dependencies = frameworkWiring.getDependencyClosure(Collections.singleton(otherVersion));
                boolean doRefresh = true;
                for (Bundle dependency : dependencies) {
                    if (!dependency.getSymbolicName().equals(thisVersionInfo.getSymbolicName()) || !dependency.getVersion().toString().equals(thisVersionInfo.getVersion())) continue;
                    doRefresh = false;
                    break;
                }
                if (!doRefresh) continue;
                result.add(otherVersion);
            }
        }
        return result;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        this.readOnly = enable;
    }

    @Override
    public int getReadOnlyModePriority() {
        return 900;
    }

    private void assertWritable() {
        if (this.readOnly) {
            throw new ReadOnlyModeException("The Module Manager is in read only mode: no operations that change module state are available");
        }
    }

    private static interface BundleOperation {
        public String getName();

        public boolean changesModuleState();

        public void perform(BundleInfo var1, String var2) throws ModuleManagementException;
    }
}

