/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.modulemanager.Constants;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.jahia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class PersistentBundleInfoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PersistentBundleInfoBuilder.class);

    public static PersistentBundle build(Resource resource) throws IOException {
        return PersistentBundleInfoBuilder.build(resource, true, true);
    }

    public static PersistentBundle build(Resource resource, boolean calculateChecksum, boolean checkTransformationRequired) throws IOException {
        String groupId = null;
        String symbolicName = null;
        String version = null;
        String displayName = null;
        try (JarInputStream jarIs = new JarInputStream(resource.getInputStream());){
            Manifest mf = jarIs.getManifest();
            if (mf != null) {
                Attributes attrs = mf.getMainAttributes();
                groupId = attrs.getValue(Constants.ATTR_NAME_GROUP_ID);
                symbolicName = attrs.getValue(Constants.ATTR_NAME_BUNDLE_SYMBOLIC_NAME);
                version = StringUtils.defaultIfBlank((String)attrs.getValue(Constants.ATTR_NAME_BUNDLE_VERSION), (String)attrs.getValue(Constants.ATTR_NAME_IMPL_VERSION));
                displayName = StringUtils.defaultIfBlank((String)attrs.getValue(Constants.ATTR_NAME_IMPL_TITLE), (String)attrs.getValue(Constants.ATTR_NAME_BUNDLE_NAME));
            }
        }
        if (StringUtils.isBlank(symbolicName) || StringUtils.isBlank(version)) {
            logger.warn("Not a valid JAR or bundle information is missing for resource " + resource);
            return null;
        }
        PersistentBundle bundleInfo = new PersistentBundle(groupId, symbolicName, version);
        bundleInfo.setDisplayName(displayName);
        if (calculateChecksum) {
            bundleInfo.setChecksum(FileUtils.calculateDigest(resource.getInputStream()));
        }
        if (checkTransformationRequired) {
            bundleInfo.setTransformationRequired(PersistentBundleInfoBuilder.isTransformationRequired(resource));
        }
        bundleInfo.setResource(resource);
        return bundleInfo;
    }

    private static boolean isTransformationRequired(Resource resource) throws IOException {
        try (JarInputStream is = new JarInputStream((InputStream)new BufferedInputStream(resource.getInputStream()), false);){
            boolean bl = ModuleUtils.requiresTransformation(is.getManifest().getMainAttributes());
            return bl;
        }
    }

    private PersistentBundleInfoBuilder() {
    }
}

