/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence.jcr;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleInfoJcrHelper {
    private static final Logger logger = LoggerFactory.getLogger(BundleInfoJcrHelper.class);
    private static final String NODE_NAME_BUNDLES = "bundles";
    private static final String NODE_NAME_ROOT = "module-management";
    private static final String NODE_TYPE_BUNDLE = "jnt:moduleManagementBundle";
    private static final String NODE_TYPE_FOLDER = "jnt:moduleManagementBundleFolder";
    private static final String NODE_TYPE_ROOT = "jnt:moduleManagement";
    static final String PATH_BUNDLES = "/module-management/bundles";
    static final String PATH_ROOT = "/module-management";

    static JCRNodeWrapper findTargetNode(String bundleKey, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper target = null;
        String path = BundleInfoJcrHelper.getJcrPath(BundleInfo.fromKey(bundleKey));
        if (session.nodeExists(path)) {
            target = session.getNode(path);
        }
        if (target == null && SettingsBean.getInstance().isClusterActivated()) {
            session.refresh(true);
            JCRNodeWrapper jCRNodeWrapper = target = session.nodeExists(path) ? session.getNode(path) : null;
        }
        if (target != null) {
            logger.debug("Bundle node for key {} found at {}", (Object)bundleKey, (Object)path);
        }
        return target;
    }

    private static JCRNodeWrapper getBundlesNode(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper bundlesNode = null;
        try {
            bundlesNode = session.getNode(PATH_BUNDLES);
        }
        catch (PathNotFoundException e) {
            bundlesNode = BundleInfoJcrHelper.getRootNode(session).addNode(NODE_NAME_BUNDLES, NODE_TYPE_FOLDER);
        }
        return bundlesNode;
    }

    static String getJcrPath(BundleInfo bundleInfo) {
        StringBuilder path = new StringBuilder();
        path.append("/module-management/bundles/");
        if (StringUtils.isNotEmpty((String)bundleInfo.getGroupId())) {
            path.append(bundleInfo.getGroupId().replace('.', '/')).append('/');
        }
        path.append(bundleInfo.getSymbolicName()).append('/').append(bundleInfo.getVersion()).append('/').append(bundleInfo.getSymbolicName()).append('-').append(bundleInfo.getVersion()).append(".jar");
        return path.toString();
    }

    static String getJcrPath(PersistentBundle bundleInfo) {
        StringBuilder path = new StringBuilder();
        path.append("/module-management/bundles/");
        if (StringUtils.isNotEmpty((String)bundleInfo.getGroupId())) {
            path.append(bundleInfo.getGroupId().replace('.', '/')).append('/');
        }
        path.append(bundleInfo.getSymbolicName()).append('/').append(bundleInfo.getVersion()).append('/').append(bundleInfo.getSymbolicName()).append('-').append(bundleInfo.getVersion()).append(".jar");
        return path.toString();
    }

    static String getJcrPath(String bundleKey) {
        return BundleInfoJcrHelper.getJcrPath(BundleInfo.fromKey(bundleKey));
    }

    static JCRNodeWrapper getOrCreateTargetNode(PersistentBundle bundleInfo, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper target = BundleInfoJcrHelper.getBundlesNode(session);
        if (bundleInfo.getGroupId() != null) {
            target = BundleInfoJcrHelper.mkdirs(target, StringUtils.split((String)bundleInfo.getGroupId(), (char)'.'), session);
        }
        target = BundleInfoJcrHelper.mkdir(target, bundleInfo.getSymbolicName(), session);
        target = BundleInfoJcrHelper.mkdir(target, bundleInfo.getVersion(), session);
        String nodeName = bundleInfo.getSymbolicName() + '-' + bundleInfo.getVersion() + ".jar";
        try {
            target = target.getNode(nodeName);
        }
        catch (PathNotFoundException e) {
            target = target.addNode(nodeName, NODE_TYPE_BUNDLE);
        }
        return target;
    }

    private static JCRNodeWrapper getRootNode(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper root = null;
        try {
            root = session.getNode(PATH_ROOT);
        }
        catch (PathNotFoundException e) {
            root = session.getRootNode().addNode(NODE_NAME_ROOT, NODE_TYPE_ROOT);
        }
        return root;
    }

    private static JCRNodeWrapper mkdir(JCRNodeWrapper startNode, String childName, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper child = null;
        try {
            child = startNode.getNode(childName);
        }
        catch (PathNotFoundException e) {
            child = startNode.addNode(childName, NODE_TYPE_FOLDER);
        }
        return child;
    }

    private static JCRNodeWrapper mkdirs(JCRNodeWrapper startNode, String[] pathSegments, JCRSessionWrapper session) throws RepositoryException {
        for (String childName : pathSegments) {
            startNode = BundleInfoJcrHelper.mkdir(startNode, childName, session);
        }
        return startNode;
    }

    private BundleInfoJcrHelper() {
    }
}

