/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.spi.impl;

import java.util.Collection;
import java.util.Map;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidTargetException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.settings.SettingsBean;

public class BundleServiceDelegate
implements BundleService {
    private static final String CLUSTERED_SERVICE_FILTER = "(clustered=true)";
    private BundleService defaultBundleService;
    private SettingsBean settingsBean;

    @Override
    public void install(String uri, String target, boolean start) throws ModuleManagementException, InvalidTargetException {
        this.lookupService().install(uri, target, start);
    }

    @Override
    public void start(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().start(bundleInfo, target);
    }

    @Override
    public void stop(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().stop(bundleInfo, target);
    }

    @Override
    public void uninstall(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().uninstall(bundleInfo, target);
    }

    @Override
    public void refresh(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().refresh(bundleInfo, target);
    }

    @Override
    public void refresh(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().refresh(bundleInfos, target);
    }

    @Override
    public Map<String, BundleService.BundleInformation> getInfo(BundleInfo bundleInfo, String target) throws ModuleManagementException, InvalidTargetException {
        return this.lookupService().getInfo(bundleInfo, target);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException, InvalidTargetException {
        return this.lookupService().getInfos(bundleInfos, target);
    }

    @Override
    public BundleState getLocalState(BundleInfo bundleInfo) throws ModuleManagementException, ModuleNotFoundException {
        return this.lookupService().getLocalState(bundleInfo);
    }

    @Override
    public BundleService.BundleInformation getLocalInfo(BundleInfo bundleInfo) throws ModuleManagementException, ModuleNotFoundException {
        return this.lookupService().getLocalInfo(bundleInfo);
    }

    private BundleService lookupService() {
        BundleService service = this.settingsBean.isClusterActivated() ? BundleUtils.getOsgiService(BundleService.class, CLUSTERED_SERVICE_FILTER) : null;
        return service != null ? service : this.defaultBundleService;
    }

    public void setDefaultBundleService(BundleService defaultBundleService) {
        this.defaultBundleService = defaultBundleService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }
}

