/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.spi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidTargetException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBundleService
implements BundleService {
    private JahiaTemplateManagerService templateManagerService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultBundleService.class);

    private static Bundle getBundleEnsureExists(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = BundleUtils.getBundleBySymbolicName(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        if (bundle == null) {
            throw new ModuleNotFoundException(bundleInfo.getKey());
        }
        return bundle;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void install(String uri, String target, boolean start) throws ModuleManagementException {
        try {
            BundleContext bundleContext = FrameworkService.getBundleContext();
            Bundle bundle = bundleContext.getBundle(uri);
            if (bundle == null || bundle.getState() == 1) {
                bundle = bundleContext.installBundle(uri);
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(SettingsBean.getInstance().getModuleStartLevel());
            } else {
                BundleLifecycleUtils.updateBundle(bundle);
            }
            if (start) {
                bundle.start();
            }
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    protected void refreshUninstalledBundle(Bundle bundle) {
        if (1 == bundle.getState()) {
            BundleLifecycleUtils.refreshBundle(bundle);
        }
    }

    @Override
    public void start(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            DefaultBundleService.getBundleEnsureExists(bundleInfo).start();
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void stop(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            DefaultBundleService.getBundleEnsureExists(bundleInfo).stop();
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void uninstall(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
            bundle.uninstall();
            this.refreshUninstalledBundle(bundle);
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void refresh(BundleInfo bundleInfo, String target) throws ModuleManagementException {
        this.refresh(Collections.singleton(bundleInfo), target);
    }

    @Override
    public void refresh(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(bundleInfos.size());
        for (BundleInfo bundleInfo : bundleInfos) {
            bundles.add(DefaultBundleService.getBundleEnsureExists(bundleInfo));
        }
        BundleLifecycleUtils.refreshBundles(bundles, false, false);
    }

    @Override
    public Map<String, BundleService.BundleInformation> getInfo(BundleInfo bundleInfo, String target) throws ModuleManagementException, InvalidTargetException {
        BundleService.BundleInformation info;
        if (target != null) {
            throw new InvalidTargetException(target);
        }
        try {
            info = this.getLocalInfo(bundleInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle info", (Throwable)e);
            info = new BundleService.BundleInformation(){

                @Override
                public BundleState getOsgiState() throws ModuleManagementException {
                    throw new ModuleManagementException(e.getMessage(), e);
                }
            };
        }
        return Collections.singletonMap("", info);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException, InvalidTargetException {
        Map<String, BundleService.BundleInformation> result;
        if (target != null) {
            throw new InvalidTargetException(target);
        }
        try {
            result = new LinkedHashMap();
            for (BundleInfo bundleInfo : new LinkedHashSet<BundleInfo>(bundleInfos)) {
                BundleService.BundleInformation info = this.getLocalInfo(bundleInfo);
                result.put(bundleInfo.getKey(), info);
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle info", (Throwable)e);
            result = new FailingMap(new ExceptionProvider(){

                @Override
                public RuntimeException get() {
                    return new ModuleManagementException(e.getMessage(), e);
                }
            });
        }
        return Collections.singletonMap("", result);
    }

    @Override
    public BundleState getLocalState(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
        return BundleState.fromInt(bundle.getState());
    }

    @Override
    public BundleService.BundleInformation getLocalInfo(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
        final BundleState osgiState = BundleState.fromInt(bundle.getState());
        if (!BundleUtils.isJahiaModuleBundle(bundle)) {
            return new BundleService.BundleInformation(){

                @Override
                public BundleState getOsgiState() {
                    return osgiState;
                }
            };
        }
        final ModuleState moduleState = this.templateManagerService.getModuleStates().get(bundle);
        return new BundleService.ModuleInformation(){

            @Override
            public BundleState getOsgiState() {
                return osgiState;
            }

            @Override
            public ModuleState.State getModuleState() {
                return moduleState == null ? null : moduleState.getState();
            }
        };
    }

    protected static class FailingMap<K, V>
    implements Map<K, V> {
        private ExceptionProvider exceptionProvider;

        public FailingMap(ExceptionProvider exceptionProvider) {
            this.exceptionProvider = exceptionProvider;
        }

        @Override
        public void clear() {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean containsKey(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean containsValue(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw this.exceptionProvider.get();
        }

        @Override
        public V get(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean isEmpty() {
            throw this.exceptionProvider.get();
        }

        @Override
        public Set<K> keySet() {
            throw this.exceptionProvider.get();
        }

        @Override
        public V put(K arg0, V arg1) {
            throw this.exceptionProvider.get();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public V remove(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public int size() {
            throw this.exceptionProvider.get();
        }

        @Override
        public Collection<V> values() {
            throw this.exceptionProvider.get();
        }
    }

    protected static interface ExceptionProvider {
        public RuntimeException get();
    }
}

