/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.notification.HttpClientService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlExternalizationService {
    protected static final Pattern CSS_URL_PATTERN = Pattern.compile("url *\\( *\"?([^\\:\" )]*)\"? *\\)");
    private static final Logger logger = LoggerFactory.getLogger(HtmlExternalizationService.class);
    private HttpClientService httpClientService;
    private boolean inlineCss = true;
    private boolean removeExternalScripts = true;
    private boolean removeInlinedScripts = true;
    private boolean rewriteUrls = true;
    private boolean rewriteUrlsInCss = true;
    private HtmlTagAttributeTraverser urlTraverser;
    private boolean useServletContextResources = true;

    public String externalize(String sourceContent, RenderContext renderContext) {
        return this.externalize(sourceContent, renderContext.getURLGenerator().getServer(), renderContext.getRequest(), renderContext.getResponse());
    }

    public String externalize(String sourceContent, String serverUrl) {
        return this.externalize(sourceContent, serverUrl, null, null);
    }

    public String externalize(String sourceContent, String serverUrl, HttpServletRequest request, HttpServletResponse response) {
        String out = sourceContent;
        long timer = System.currentTimeMillis();
        if (this.removeExternalScripts || this.removeInlinedScripts) {
            out = this.removeJavaScript(out);
        }
        if (this.inlineCss) {
            out = this.processCss(out, serverUrl, request, response);
        }
        if (this.rewriteUrls) {
            out = this.rewriteUrls(out, serverUrl);
            if (logger.isDebugEnabled()) {
                logger.debug("...done processing URLs in " + (System.currentTimeMillis() - timer) + " ms");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info("...done externalizing output content in " + (System.currentTimeMillis() - timer) + " ms");
        }
        return out;
    }

    protected String processCss(String previousOut, String serverUrl, HttpServletRequest request, HttpServletResponse response) {
        Source source = new Source((CharSequence)previousOut);
        OutputDocument document = new OutputDocument(source);
        StringBuilder sb = new StringBuilder();
        List linkStartTags = source.getAllStartTags("link");
        for (StartTag linkTag : linkStartTags) {
            String href;
            Attributes attributes = linkTag.getAttributes();
            String rel = attributes.getValue("rel");
            if (rel == null || !"stylesheet".equalsIgnoreCase(rel) || (href = attributes.getValue("href")) == null) continue;
            String styleSheetContent = null;
            try {
                if (this.useServletContextResources || request == null || response == null) {
                    if (request != null && StringUtils.startsWith((String)href, (String)request.getContextPath())) {
                        href = StringUtils.substringAfter((String)href, (String)request.getContextPath());
                    }
                    if (href.startsWith("/modules/")) {
                        String after = StringUtils.substringAfter((String)href, (String)"/modules/");
                        String module = StringUtils.substringBefore((String)after, (String)"/");
                        JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module);
                        if (pack != null) {
                            String prefix = "/modules/" + module;
                            if (!href.startsWith(prefix)) {
                                href = prefix + "/" + StringUtils.substringAfter((String)after, (String)"/");
                            }
                            styleSheetContent = StringUtils.join((Collection)IOUtils.readLines((InputStream)pack.getResource(StringUtils.substringAfter((String)after, (String)"/")).getInputStream()), (char)'\n');
                        }
                    } else {
                        styleSheetContent = this.httpClientService.getResourceAsString(href);
                    }
                } else {
                    styleSheetContent = this.httpClientService.getResourceAsString(href, request, response);
                }
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve resource content for " + href + ".Cause: " + e.getMessage(), (Throwable)e);
            }
            if (!StringUtils.isNotEmpty((String)styleSheetContent)) continue;
            sb.setLength(0);
            sb.append("<style");
            Attribute typeAttribute = attributes.get("type");
            if (typeAttribute != null) {
                sb.append(' ').append((CharSequence)typeAttribute);
            }
            if (this.rewriteUrlsInCss) {
                String baseUrl = HttpClientService.isAbsoluteUrl(href) ? href : serverUrl + href;
                baseUrl = StringUtils.substringBeforeLast((String)baseUrl, (String)"/") + "/";
                styleSheetContent = this.rewriteCssUrls(styleSheetContent, baseUrl);
            }
            sb.append(">\n");
            if (request != null && Boolean.valueOf(request.getParameter("debug")).booleanValue()) {
                sb.append("/* ").append(href).append(" */\n");
            }
            sb.append(styleSheetContent).append("\n</style>");
            document.replace((Segment)linkTag, (CharSequence)sb.toString());
        }
        return document.toString();
    }

    protected String removeJavaScript(String out) {
        Source source = new Source((CharSequence)out);
        OutputDocument document = new OutputDocument(source);
        List scriptTags = source.getAllElements("script");
        for (Element scriptElement : scriptTags) {
            boolean doRemove = false;
            if (this.removeExternalScripts && this.removeInlinedScripts) {
                doRemove = true;
            } else {
                String srcAttr = scriptElement.getAttributeValue("src");
                boolean bl = doRemove = this.removeExternalScripts && StringUtils.isNotEmpty((String)srcAttr) || this.removeInlinedScripts && StringUtils.isEmpty((String)srcAttr);
            }
            if (!doRemove) continue;
            document.remove((Segment)scriptElement);
        }
        return document.toString();
    }

    protected String rewriteCssUrls(String cssContent, String urlBase) {
        return CSS_URL_PATTERN.matcher(cssContent).replaceAll("url(\"" + urlBase + "$1\")");
    }

    protected String rewriteUrls(String source, final String serverUrl) {
        return this.urlTraverser.traverse(source, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

            @Override
            public String visit(String url, RenderContext context, String tagName, String attrName, Resource resource) {
                return StringUtils.isNotEmpty((String)url) && url.startsWith("/") ? serverUrl + url : url;
            }
        });
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void setInlineCss(boolean inlineCss) {
        this.inlineCss = inlineCss;
    }

    public void setRemoveExternalScripts(boolean removeExternalScripts) {
        this.removeExternalScripts = removeExternalScripts;
    }

    public void setRemoveInlinedScripts(boolean removeInlinedScripts) {
        this.removeInlinedScripts = removeInlinedScripts;
    }

    public void setRewriteUrls(boolean rewriteUrls) {
        this.rewriteUrls = rewriteUrls;
    }

    public void setRewriteUrlsInCss(boolean rewriteUrlsInCss) {
        this.rewriteUrlsInCss = rewriteUrlsInCss;
    }

    public void setUrlTraverser(HtmlTagAttributeTraverser urlTraverser) {
        this.urlTraverser = urlTraverser;
    }

    public void setUseServletContextResources(boolean useServletContextResources) {
        this.useServletContextResources = useServletContextResources;
    }
}

