/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.jackrabbit.spi.commons.query.qom.AbstractQOMNode;
import org.apache.jackrabbit.spi.commons.query.qom.AndImpl;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ComparisonImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ConstraintImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.EquiJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LengthImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LiteralImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NotImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SourceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.StaticOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.UpperCaseImpl;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.ModificationInfo;
import org.jahia.services.query.QueryServiceImpl;

class QueryModifierAndOptimizerVisitor
extends DefaultQOMTreeVisitor {
    private ValueFactory valueFactory;
    private ModificationInfo modificationInfo;
    private Source originalSource;
    private Map<String, Selector> selectorsJoinedWithTranslation = new HashMap<String, Selector>();
    private Map<String, Set<String>> languagesPerSelector = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> newLanguagesPerSelector = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> nodeTypesPerSelector = new HashMap<String, Set<String>>();
    private static final String NO_LOCALE = "no_locale";
    private JCRSessionWrapper session = null;

    public QueryModifierAndOptimizerVisitor(ValueFactory valueFactory, ModificationInfo modificationInfo, Source originalSource, JCRSessionWrapper session) {
        this.valueFactory = valueFactory;
        this.modificationInfo = modificationInfo;
        this.originalSource = originalSource;
        this.session = session;
    }

    public Object visit(ChildNodeImpl node, Object data) throws Exception {
        String nodeTypeName;
        Selector selector;
        if (this.getModificationInfo().getMode() == TraversingMode.INITIALIZE_MODE && (selector = this.getSelector(this.getOriginalSource(), node.getSelectorName())) != null && ("nt:base".equals(nodeTypeName = selector.getNodeTypeName()) || "jnt:content".equals(nodeTypeName))) {
            HashSet<String> commonChildNodeTypes = new HashSet<String>();
            String primaryChildNodeType = this.getCommonChildNodeTypes(node.getParentPath(), commonChildNodeTypes);
            if (primaryChildNodeType != null) {
                commonChildNodeTypes = new HashSet();
                commonChildNodeTypes.add(primaryChildNodeType);
            }
            this.getNodeTypesPerSelector().put(node.getSelectorName(), commonChildNodeTypes);
        }
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(PropertyValueImpl node, Object data) throws Exception {
        AbstractQOMNode returnedData = this.getNewPropertyBasedNodeIfRequired((AbstractQOMNode)node);
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? returnedData : node;
    }

    public Object visit(ColumnImpl node, Object data) throws Exception {
        AbstractQOMNode returnedData = this.getNewPropertyBasedNodeIfRequired((AbstractQOMNode)node);
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? returnedData : node;
    }

    public Object visit(FullTextSearchImpl node, Object data) throws Exception {
        AbstractQOMNode returnedData = this.getNewPropertyBasedNodeIfRequired((AbstractQOMNode)node);
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? returnedData : node;
    }

    public Object visit(PropertyExistenceImpl node, Object data) throws Exception {
        if (this.getModificationInfo().getMode() == TraversingMode.INITIALIZE_MODE && "jcr:language".equals(node.getPropertyName())) {
            Selector selector = this.getSelector(this.getOriginalSource(), node.getSelectorName());
            Set<String> languages = this.getLanguagesPerSelector().get(selector.getSelectorName());
            if (languages == null) {
                languages = new HashSet<String>();
                this.getLanguagesPerSelector().put(selector.getSelectorName(), languages);
            }
            languages.add(NO_LOCALE);
        }
        AbstractQOMNode returnedData = this.getNewPropertyBasedNodeIfRequired((AbstractQOMNode)node);
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? returnedData : node;
    }

    public final Object visit(AndImpl node, Object data) throws Exception {
        Constraint constraint1 = node.getConstraint1();
        Constraint constraint2 = node.getConstraint2();
        boolean modified = false;
        Object returnedData = ((ConstraintImpl)node.getConstraint1()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE && returnedData != null && !returnedData.equals(node.getConstraint1())) {
            constraint1 = (Constraint)returnedData;
            modified = true;
        }
        returnedData = ((ConstraintImpl)node.getConstraint2()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE && returnedData != null && !returnedData.equals(node.getConstraint2())) {
            constraint2 = (Constraint)returnedData;
            modified = true;
        }
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = modified ? this.getModificationInfo().getQueryObjectModelFactory().and(constraint1, constraint2) : node;
        }
        return data;
    }

    public Object visit(ComparisonImpl node, Object data) throws Exception {
        Object returnedData = ((DynamicOperandImpl)node.getOperand1()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.INITIALIZE_MODE && "jcr.operator.equal.to".equals(node.getOperator()) && node.getOperand1() instanceof PropertyValue && "jcr:language".equals(((PropertyValue)node.getOperand1()).getPropertyName())) {
            String language;
            Selector selector = this.getSelector(this.getOriginalSource(), ((PropertyValue)node.getOperand1()).getSelectorName());
            Set<String> languages = this.getLanguagesPerSelector().get(selector.getSelectorName());
            if (languages == null) {
                languages = new HashSet<String>();
                this.getLanguagesPerSelector().put(selector.getSelectorName(), languages);
            }
            if (!languages.contains(language = ((Literal)node.getOperand2()).getLiteralValue().getString())) {
                languages.add(language);
            }
        }
        ((StaticOperandImpl)node.getOperand2()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getOperand1()) ? this.getModificationInfo().getQueryObjectModelFactory().comparison((DynamicOperand)returnedData, node.getOperator(), node.getOperand2()) : node;
        }
        return data;
    }

    public Object visit(JoinImpl node, Object data) throws Exception {
        if (this.getModificationInfo().getMode() == TraversingMode.INITIALIZE_MODE && node.getJoinCondition() instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition childNodeJoin = (ChildNodeJoinCondition)node.getJoinCondition();
            String childSelectorName = childNodeJoin.getChildSelectorName();
            Selector childSelector = this.getSelector(this.getOriginalSource(), childSelectorName);
            if ("jnt:translation".equals(childSelector.getNodeTypeName())) {
                this.getSelectorsJoinedWithTranslation().put(childNodeJoin.getParentSelectorName(), childSelector);
            }
        }
        Object returnedRight = ((SourceImpl)node.getRight()).accept((QOMTreeVisitor)this, data);
        Object returnedLeft = ((SourceImpl)node.getLeft()).accept((QOMTreeVisitor)this, data);
        Object returnedJoinCondition = ((JoinConditionImpl)node.getJoinCondition()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append(returnedRight, (Object)node.getRight()).append(returnedLeft, (Object)node.getLeft()).append(returnedJoinCondition, (Object)node.getJoinCondition());
            data = equalsBuilder.isEquals() ? node : this.getModificationInfo().getQueryObjectModelFactory().join(returnedLeft != null ? (Source)returnedLeft : node.getLeft(), returnedRight != null ? (Source)returnedRight : node.getRight(), node.getJoinType(), returnedJoinCondition != null ? (JoinCondition)returnedJoinCondition : node.getJoinCondition());
        }
        return data;
    }

    public Object visit(LengthImpl node, Object data) throws Exception {
        Object returnedData = ((PropertyValueImpl)node.getPropertyValue()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getPropertyValue()) ? this.getModificationInfo().getQueryObjectModelFactory().length((PropertyValue)returnedData) : node;
        }
        return data;
    }

    public Object visit(LowerCaseImpl node, Object data) throws Exception {
        Object returnedData = ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getOperand()) ? this.getModificationInfo().getQueryObjectModelFactory().lowerCase((DynamicOperand)returnedData) : node;
        }
        return data;
    }

    public Object visit(NotImpl node, Object data) throws Exception {
        Object returnedData = ((ConstraintImpl)node.getConstraint()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getConstraint()) ? this.getModificationInfo().getQueryObjectModelFactory().not((Constraint)data) : node;
        }
        return data;
    }

    public Object visit(OrderingImpl node, Object data) throws Exception {
        Object returnedData = ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getOperand()) ? (node.isAscending() ? this.getModificationInfo().getQueryObjectModelFactory().ascending((DynamicOperand)returnedData) : this.getModificationInfo().getQueryObjectModelFactory().descending((DynamicOperand)returnedData)) : node;
        }
        return data;
    }

    public final Object visit(OrImpl node, Object data) throws Exception {
        Constraint constraint1 = node.getConstraint1();
        Constraint constraint2 = node.getConstraint2();
        boolean modified = false;
        Object returnedData = ((ConstraintImpl)node.getConstraint1()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE && returnedData != null && !returnedData.equals(node.getConstraint1())) {
            constraint1 = (Constraint)returnedData;
            modified = true;
        }
        returnedData = ((ConstraintImpl)node.getConstraint2()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE && returnedData != null && !returnedData.equals(node.getConstraint2())) {
            constraint2 = (Constraint)returnedData;
            modified = true;
        }
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = modified ? this.getModificationInfo().getQueryObjectModelFactory().or(constraint1, constraint2) : node;
        }
        return data;
    }

    public Object visit(QueryObjectModelTree node, Object data) throws Exception {
        node.getSource().accept((QOMTreeVisitor)this, data);
        Constraint newConstraint = null;
        if (node.getConstraint() != null) {
            newConstraint = (Constraint)node.getConstraint().accept((QOMTreeVisitor)this, data);
        }
        Object[] newOrderingObjects = new Ordering[node.getOrderings().length];
        for (int i = 0; i < node.getOrderings().length; ++i) {
            newOrderingObjects[i] = (Ordering)node.getOrderings()[i].accept((QOMTreeVisitor)this, data);
        }
        Object[] newColumnObjects = new Column[node.getColumns().length];
        for (int i = 0; i < node.getColumns().length; ++i) {
            newColumnObjects[i] = (Column)node.getColumns()[i].accept((QOMTreeVisitor)this, data);
        }
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)newConstraint, (Object)node.getConstraint()).append(newOrderingObjects, (Object[])node.getOrderings()).append(newColumnObjects, (Object[])node.getColumns());
            data = equalsBuilder.isEquals() ? node : this.getModificationInfo().getQueryObjectModelFactory().createQuery(this.getModificationInfo().getModifiedSource((Source)node.getSource()), newConstraint, (Ordering[])newOrderingObjects, (Column[])newColumnObjects);
        }
        return data;
    }

    public Object visit(UpperCaseImpl node, Object data) throws Exception {
        Object returnedData = ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
        if (this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
            data = returnedData != null && !returnedData.equals(node.getOperand()) ? this.getModificationInfo().getQueryObjectModelFactory().upperCase((DynamicOperand)data) : node;
        }
        return data;
    }

    public Object visit(BindVariableValueImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(DescendantNodeImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(FullTextSearchScoreImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? (this.getSelectorsJoinedWithTranslation().get(node.getSelectorName()) != null ? this.getModificationInfo().getQueryObjectModelFactory().fullTextSearchScore(this.getSelectorsJoinedWithTranslation().get(node.getSelectorName()).getSelectorName()) : node) : data;
    }

    public Object visit(LiteralImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(NodeNameImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(SameNodeImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(ChildNodeJoinConditionImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(DescendantNodeJoinConditionImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(EquiJoinConditionImpl node, Object data) throws Exception {
        AbstractQOMNode returnedData = this.getNewPropertyBasedNodeIfRequired((AbstractQOMNode)node);
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? returnedData : node;
    }

    public Object visit(SameNodeJoinConditionImpl node, Object data) throws Exception {
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    public Object visit(SelectorImpl node, Object data) throws Exception {
        if (this.getModificationInfo().getMode() == TraversingMode.INITIALIZE_MODE && node.equals(this.getOriginalSource()) && "jnt:translation".equals(node.getNodeTypeName())) {
            this.getSelectorsJoinedWithTranslation().put(node.getSelectorName(), (Selector)node);
        }
        return this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE ? node : data;
    }

    private AbstractQOMNode getNewPropertyBasedNodeIfRequired(AbstractQOMNode node) throws RepositoryException {
        AbstractQOMNode newNode = node;
        if (node instanceof EquiJoinCondition) {
            newNode = this.getNewPropertyBasedNodeIfRequired(((EquiJoinCondition)node).getSelector1Name(), ((EquiJoinCondition)node).getProperty1Name(), node);
            newNode = this.getNewPropertyBasedNodeIfRequired(((EquiJoinCondition)node).getSelector2Name(), ((EquiJoinCondition)node).getProperty2Name(), newNode);
        } else {
            String selectorName = null;
            String propertyName = null;
            if (node instanceof PropertyValue) {
                selectorName = ((PropertyValue)node).getSelectorName();
                propertyName = ((PropertyValue)node).getPropertyName();
            } else if (node instanceof FullTextSearch) {
                selectorName = ((FullTextSearch)node).getSelectorName();
                propertyName = ((FullTextSearch)node).getPropertyName();
            } else if (node instanceof PropertyExistence) {
                selectorName = ((PropertyExistence)node).getSelectorName();
                propertyName = ((PropertyExistence)node).getPropertyName();
            } else if (node instanceof Column) {
                selectorName = ((Column)node).getSelectorName();
                propertyName = ((Column)node).getPropertyName();
            }
            newNode = this.getNewPropertyBasedNodeIfRequired(selectorName, propertyName, node);
        }
        return newNode;
    }

    private AbstractQOMNode getNewPropertyBasedNodeIfRequired(String selectorName, String propertyName, AbstractQOMNode node) throws RepositoryException {
        Selector selector = this.getSelector(this.getOriginalSource(), selectorName);
        if (selector == null) {
            return node;
        }
        try {
            if (this.getModificationInfo().getMode() == TraversingMode.CHECK_FOR_MODIFICATION_MODE || this.getModificationInfo().getMode() == TraversingMode.MODIFY_MODE) {
                String columnName;
                Set<String> languageCodes;
                if (this.getSelectorsJoinedWithTranslation().get(selector.getSelectorName()) != null) {
                    selector = this.getSelectorsJoinedWithTranslation().get(selector.getSelectorName());
                }
                if (!((languageCodes = this.getLanguagesPerSelector().get(selector.getSelectorName())) != null && !languageCodes.isEmpty() || this.session == null || this.session.getLocale() == null || "nt:query".equals(selector.getNodeTypeName()) || "jnt:query".equals(selector.getNodeTypeName()))) {
                    if (this.getModificationInfo().getMode() == TraversingMode.CHECK_FOR_MODIFICATION_MODE) {
                        Set<String> newLanguageCodes = this.getNewLanguagesPerSelector().get(selector.getSelectorName());
                        if (newLanguageCodes == null) {
                            newLanguageCodes = new HashSet<String>();
                            newLanguageCodes.add(this.session.getLocale().toString());
                            newLanguageCodes.add(NO_LOCALE);
                            this.getNewLanguagesPerSelector().put(selector.getSelectorName(), newLanguageCodes);
                        }
                        if (newLanguageCodes.contains(NO_LOCALE)) {
                            ExtendedPropertyDefinition propDef;
                            ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(selector.getNodeTypeName());
                            ExtendedPropertyDefinition extendedPropertyDefinition = propDef = propertyName != null ? this.getPropertyDefinition(nodeType, selector, propertyName) : null;
                            if (!"jnt:file".equals(selector.getNodeTypeName()) && propDef != null && propDef.isInternationalized()) {
                                newLanguageCodes.remove(NO_LOCALE);
                            }
                        }
                        this.getModificationInfo().setModificationNecessary(true);
                    } else {
                        QueryObjectModelFactory qomFactory = this.getModificationInfo().getQueryObjectModelFactory();
                        Set<String> newLanguageCodes = this.getNewLanguagesPerSelector().get(selector.getSelectorName());
                        if (newLanguageCodes != null) {
                            Not langConstraint = null;
                            for (String newLanguageCode : newLanguageCodes) {
                                Not currentConstraint = NO_LOCALE.equals(newLanguageCode) ? qomFactory.not((Constraint)qomFactory.propertyExistence(selector.getSelectorName(), "jcr:language")) : qomFactory.comparison((DynamicOperand)qomFactory.propertyValue(selector.getSelectorName(), "jcr:language"), "jcr.operator.equal.to", (StaticOperand)qomFactory.literal(this.getValueFactory().createValue(newLanguageCode)));
                                langConstraint = langConstraint == null ? currentConstraint : qomFactory.or((Constraint)langConstraint, (Constraint)currentConstraint);
                            }
                            this.getModificationInfo().getNewConstraints().add((Constraint)langConstraint);
                            if (languageCodes == null) {
                                languageCodes = new HashSet<String>();
                                this.getLanguagesPerSelector().put(selector.getSelectorName(), languageCodes);
                            }
                            languageCodes.addAll(newLanguageCodes);
                        }
                    }
                }
                if (node instanceof Column && StringUtils.startsWith((String)(columnName = ((Column)node).getColumnName()), (String)"rep:facet(") && !StringUtils.contains((String)columnName, (String)"locale=")) {
                    if (this.getModificationInfo().getMode() == TraversingMode.CHECK_FOR_MODIFICATION_MODE) {
                        this.getModificationInfo().setModificationNecessary(true);
                    } else {
                        String facetOptions = columnName.substring("rep:facet(".length());
                        if (languageCodes == null) {
                            languageCodes = this.getNewLanguagesPerSelector().get(selector.getSelectorName());
                        }
                        String languageCode = null;
                        if (languageCodes != null) {
                            for (String currentLanguageCode : languageCodes) {
                                if (NO_LOCALE.equals(currentLanguageCode)) continue;
                                languageCode = currentLanguageCode;
                                break;
                            }
                        }
                        if (!StringUtils.isEmpty(languageCode)) {
                            columnName = "rep:facet(locale=" + languageCode + (facetOptions.trim().length() > 1 ? "&" : "") + facetOptions;
                            QueryObjectModelFactory qomFactory = this.getModificationInfo().getQueryObjectModelFactory();
                            node = (AbstractQOMNode)qomFactory.column(selector.getSelectorName(), propertyName, columnName);
                        }
                    }
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            QueryServiceImpl.logger.debug("Type " + selector.getNodeTypeName() + " not found in registry", (Throwable)e);
        }
        return node;
    }

    private ExtendedPropertyDefinition getPropertyDefinition(ExtendedNodeType nodeType, Selector selector, String propertyName) throws RepositoryException {
        ExtendedPropertyDefinition propDef = null;
        if (!"jnt:translation".equals(nodeType.getName())) {
            Set<String> nodeTypes;
            if (("nt:base".equals(nodeType.getName()) || "jnt:content".equals(nodeType.getName())) && (nodeTypes = this.getNodeTypesPerSelector().get(selector.getSelectorName())) != null) {
                for (String commonNodeType : nodeTypes) {
                    nodeType = NodeTypeRegistry.getInstance().getNodeType(commonNodeType);
                    propDef = nodeType.getPropertyDefinitionsAsMap().get(propertyName);
                    if (propDef == null) continue;
                    break;
                }
            }
            if (propDef == null) {
                propDef = nodeType.getPropertyDefinitionsAsMap().get(propertyName);
            }
        }
        return propDef;
    }

    private String getCommonChildNodeTypes(String parentPath, Set<String> commonNodeTypes) throws RepositoryException {
        JCRNodeIteratorWrapper children;
        String commonPrimaryType = null;
        JCRNodeWrapper node = this.session.getNode(parentPath);
        HashSet<String> checkedPrimaryTypes = new HashSet<String>();
        if (node.hasNodes() && (children = node.getNodes()).getSize() < 100L) {
            while (children.hasNext()) {
                JCRNodeWrapper child = (JCRNodeWrapper)children.nextNode();
                if (commonPrimaryType == null && commonNodeTypes.isEmpty()) {
                    commonPrimaryType = child.getPrimaryNodeType().getName();
                    commonNodeTypes.addAll(child.getNodeTypes());
                } else if (commonPrimaryType != null && child.getPrimaryNodeType().getName().equals(commonPrimaryType)) {
                    commonPrimaryType = null;
                }
                if (checkedPrimaryTypes.contains(child.getPrimaryNodeType().getName())) continue;
                checkedPrimaryTypes.add(child.getPrimaryNodeType().getName());
                commonNodeTypes.retainAll(child.getNodeTypes());
            }
        }
        return commonPrimaryType;
    }

    public ModificationInfo getModificationInfo() {
        return this.modificationInfo;
    }

    public Source getOriginalSource() {
        return this.originalSource;
    }

    public Map<String, Selector> getSelectorsJoinedWithTranslation() {
        return this.selectorsJoinedWithTranslation;
    }

    public Map<String, Set<String>> getLanguagesPerSelector() {
        return this.languagesPerSelector;
    }

    public Map<String, Set<String>> getNewLanguagesPerSelector() {
        return this.newLanguagesPerSelector;
    }

    public Map<String, Set<String>> getNodeTypesPerSelector() {
        return this.nodeTypesPerSelector;
    }

    private Selector getSelector(Source source, String name) {
        SelectorImpl foundSelector = null;
        for (SelectorImpl selector : ((SourceImpl)source).getSelectors()) {
            if (!StringUtils.isEmpty((String)name) && !name.equals(selector.getSelectorName())) continue;
            foundSelector = selector;
            break;
        }
        return foundSelector;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    protected static enum TraversingMode {
        INITIALIZE_MODE,
        CHECK_FOR_MODIFICATION_MODE,
        MODIFY_MODE;

    }
}

