/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.scripting.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    public static final String CONFIGURATION_PAGE = "page";
    public static final String CONFIGURATION_GWT = "gwt";
    public static final String CONFIGURATION_MODULE = "module";
    public static final String CONFIGURATION_INCLUDE = "include";
    public static final String CONFIGURATION_WRAPPER = "wrapper";
    public static final String CONFIGURATION_WRAPPEDCONTENT = "wrappedcontent";
    private static Logger logger = LoggerFactory.getLogger(Resource.class);
    private JCRNodeWrapper node;
    private String templateType;
    private String template;
    private String resolvedTemplate;
    private String contextConfiguration;
    private Stack<String> wrappers = new Stack();
    private Script script;
    private boolean scriptNotFound = false;
    private String nodePath;
    private String canonicalPath;
    private JCRSessionWrapper sessionWrapper;
    private boolean lazyNodeFlagWarning = true;
    private Set<String> dependencies = new HashSet<String>();
    private List<String> missingResources = new ArrayList<String>();
    private List<Option> options = new ArrayList<Option>();
    private ExtendedNodeType resourceNodeType;
    private Map<String, Serializable> moduleParams = new HashMap<String, Serializable>();
    private Set<String> regexpDependencies = new LinkedHashSet<String>();
    private static final String CACHE_KEY = "cacheKey";
    private static final Predicate<String> CACHE_KEY_PREDICATE = Predicates.not((Predicate)Predicates.equalTo((Object)"cacheKey"));

    public Resource(JCRNodeWrapper node, String templateType, String template, String contextConfiguration) {
        this.node = node;
        this.nodePath = node.getPath();
        this.canonicalPath = node.getCanonicalPath();
        this.templateType = templateType;
        this.template = template;
        this.contextConfiguration = contextConfiguration;
        this.dependencies.add(node.getCanonicalPath());
    }

    public Resource(String path, String canonicalPath, JCRSessionWrapper sessionWrapper, String templateType, String template, String contextConfiguration) {
        this.nodePath = path;
        this.sessionWrapper = sessionWrapper;
        this.templateType = templateType;
        this.template = template;
        this.contextConfiguration = contextConfiguration;
        this.canonicalPath = canonicalPath;
        this.dependencies.add(path);
    }

    public JCRNodeWrapper getNode() {
        if (!this.isNodeLoaded()) {
            try {
                if (this.lazyNodeFlagWarning && this.sessionWrapper.getWorkspace().getName().equals("live") && !CONFIGURATION_PAGE.equals(this.contextConfiguration)) {
                    logger.warn("Performance warning: node loaded from JCR before the cache filter for resource: " + this.nodePath + ", render filter implementations have to be review, to avoid reading the node from the resource before the cache. You can enable debug log level to look at the current thread stack, this could help to identify the calling method");
                    if (logger.isDebugEnabled()) {
                        Thread.dumpStack();
                    }
                }
                this.node = this.sessionWrapper.getNode(this.nodePath);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Lazy Node from resource failed to be load, because Node is not found anymore", e);
            }
        }
        return this.node;
    }

    public JCRNodeWrapper safeLoadNode() {
        this.lazyNodeFlagWarning = false;
        return this.getNode();
    }

    public boolean isNodeLoaded() {
        return this.node != null;
    }

    public void setNode(JCRNodeWrapper node) {
        this.node = node;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    private JCRSessionWrapper getSession() throws RepositoryException {
        return this.isNodeLoaded() ? this.node.getSession() : this.sessionWrapper;
    }

    public String getWorkspace() {
        try {
            return this.getSession().getWorkspace().getName();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Locale getLocale() {
        try {
            return this.getSession().getLocale();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setTemplate(String template) {
        this.template = template;
        this.resolvedTemplate = template;
    }

    public String getContextConfiguration() {
        return this.contextConfiguration;
    }

    public String getResolvedTemplate() {
        if (StringUtils.isEmpty((String)this.resolvedTemplate)) {
            if (!StringUtils.isEmpty((String)this.template)) {
                this.resolvedTemplate = this.template;
            } else {
                try {
                    this.resolvedTemplate = this.node.isNodeType("jmix:renderable") && this.node.hasProperty("j:view") ? this.node.getProperty("j:view").getString() : "default";
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.resolvedTemplate = "default";
                }
            }
        }
        return this.resolvedTemplate;
    }

    public String getTemplate() {
        if (StringUtils.isEmpty((String)this.template)) {
            return "default";
        }
        return this.template;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getRegexpDependencies() {
        return this.regexpDependencies;
    }

    public List<String> getMissingResources() {
        return this.missingResources;
    }

    public Map<String, Serializable> getModuleParams() {
        return this.moduleParams;
    }

    public boolean hasWrapper() {
        return !this.wrappers.isEmpty();
    }

    public boolean hasWrapper(String wrapper) {
        return this.wrappers.contains(wrapper);
    }

    public String popWrapper() {
        return this.wrappers.pop();
    }

    public String pushWrapper(String wrapper) {
        return this.wrappers.push(wrapper);
    }

    public String getPath() {
        return this.nodePath + "." + this.getTemplate() + "." + this.templateType;
    }

    public String toString() {
        String primaryNodeTypeName = null;
        try {
            primaryNodeTypeName = this.getNode().getPrimaryNodeTypeName();
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving node primary node type name", (Throwable)e);
        }
        return "Resource{node=" + this.nodePath + ", primaryNodeTypeName='" + primaryNodeTypeName + "', templateType='" + this.templateType + "', template='" + this.getTemplate() + "', configuration='" + this.contextConfiguration + "'}";
    }

    @Deprecated
    public void addOption(String wrapper, ExtendedNodeType nodeType) {
        this.options.add(new Option(wrapper, nodeType));
    }

    @Deprecated
    public List<Option> getOptions() {
        return this.options;
    }

    @Deprecated
    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    @Deprecated
    public void removeOption(ExtendedNodeType mixinNodeType) {
        this.options.remove(new Option("", mixinNodeType));
    }

    public ExtendedNodeType getResourceNodeType() {
        return this.resourceNodeType;
    }

    public void setContextConfiguration(String contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
    }

    public Script getScript(RenderContext context) throws RepositoryException {
        if (this.script == null && !this.scriptNotFound) {
            try {
                this.script = RenderService.getInstance().resolveScript(this, context);
            }
            catch (TemplateNotFoundException e) {
                this.scriptNotFound = true;
                logger.debug("Script not found for resource: ", (Object)this.getPath());
            }
        }
        return this.script;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setResourceNodeType(ExtendedNodeType resourceNodeType) {
        this.resourceNodeType = resourceNodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (this.canonicalPath != null ? !this.canonicalPath.equals(resource.canonicalPath) : resource.canonicalPath != null) {
            return false;
        }
        if (this.templateType != null ? !this.templateType.equals(resource.templateType) : resource.templateType != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(resource.template) : resource.template != null) {
            return false;
        }
        if (this.wrappers != null ? !this.wrappers.equals(resource.wrappers) : resource.wrappers != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(resource.options) : resource.options != null) {
            return false;
        }
        if (this.resourceNodeType != null ? !this.resourceNodeType.equals(resource.resourceNodeType) : resource.resourceNodeType != null) {
            return false;
        }
        return !(this.moduleParams != null ? !Resource.filterModuleParams(this.moduleParams).equals(Resource.filterModuleParams(resource.moduleParams)) : resource.moduleParams != null);
    }

    private static Map<String, Serializable> filterModuleParams(Map<String, Serializable> moduleParams) {
        return moduleParams != null && moduleParams.containsKey(CACHE_KEY) ? Maps.filterKeys(moduleParams, CACHE_KEY_PREDICATE) : moduleParams;
    }

    public int hashCode() {
        int result = this.isNodeLoaded() ? this.node.hashCode() : 0;
        result = 31 * result + (this.canonicalPath != null ? this.canonicalPath.hashCode() : 0);
        result = 31 * result + (this.templateType != null ? this.templateType.hashCode() : 0);
        result = 31 * result + (this.getResolvedTemplate() != null ? this.getResolvedTemplate().hashCode() : 0);
        result = 31 * result + (this.wrappers != null ? this.wrappers.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.resourceNodeType != null ? this.resourceNodeType.hashCode() : 0);
        result = 31 * result + (this.moduleParams != null ? this.moduleParams.hashCode() : 0);
        return result;
    }

    @Deprecated
    public class Option
    implements Comparable<Option> {
        private final String wrapper;
        private final ExtendedNodeType nodeType;

        public Option(String wrapper, ExtendedNodeType nodeType) {
            this.wrapper = wrapper;
            this.nodeType = nodeType;
        }

        public ExtendedNodeType getNodeType() {
            return this.nodeType;
        }

        public String getWrapper() {
            return this.wrapper;
        }

        @Override
        public int compareTo(Option o) {
            return this.nodeType.getName().compareTo(o.getNodeType().getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return this.nodeType.getName().equals(option.nodeType.getName());
        }

        public int hashCode() {
            return this.nodeType.getName().hashCode();
        }
    }
}

