/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.services.render.filter.RenderChain;

public class URLFilter
extends AbstractFilter {
    private static final String TEMP_START_TAG = "<!-- jahia:temp value=\"URLParserStart";
    private static final String TEMP_FULL_START_TAG = "<!-- jahia:temp value=\"URLParserStartXXXXXXXX\" -->";
    private static final String TEMP_END_TAG = "<!-- jahia:temp value=\"URLParserEnd";
    private static final String TEMP_CLOSING = "\" -->";
    private static final String REPLACED_START_TAG = "<jahia:URLParserParsedReplaced id=\"";
    private HtmlTagAttributeTraverser urlTraverser;
    private HtmlTagAttributeTraverser.HtmlTagAttributeVisitor[] handlers;

    public URLFilter(HtmlTagAttributeTraverser urlTraverser) {
        this.urlTraverser = urlTraverser;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (this.handlers != null && this.handlers.length > 0) {
            String uuid;
            int i;
            String thisuuid = StringUtils.leftPad((String)Integer.toHexString(resource.hashCode()), (int)8, (String)"0");
            HashMap<String, String> alreadyParsedFragmentsMap = new HashMap<String, String>();
            StringBuilder sb = null;
            if (previousOut.indexOf(TEMP_START_TAG) > -1) {
                sb = new StringBuilder(previousOut);
                while ((i = sb.indexOf(TEMP_START_TAG)) > -1) {
                    uuid = sb.substring(i + TEMP_START_TAG.length(), i + TEMP_START_TAG.length() + 8);
                    String endTag = TEMP_END_TAG + uuid + TEMP_CLOSING;
                    int j = sb.indexOf(endTag);
                    alreadyParsedFragmentsMap.put(uuid, sb.substring(i + TEMP_FULL_START_TAG.length(), j));
                    sb.delete(i, j + endTag.length());
                    sb.insert(i, "\"/>").insert(i, uuid).insert(i, REPLACED_START_TAG);
                }
            }
            sb = new StringBuilder(this.urlTraverser.traverse(sb == null ? previousOut : sb.toString(), renderContext, resource, this.handlers));
            sb.insert(0, TEMP_CLOSING).insert(0, thisuuid).insert(0, TEMP_START_TAG);
            sb.append(TEMP_END_TAG).append(thisuuid).append(TEMP_CLOSING);
            while ((i = sb.indexOf(REPLACED_START_TAG)) > -1) {
                uuid = sb.substring(i + REPLACED_START_TAG.length(), i + REPLACED_START_TAG.length() + 8);
                sb.replace(i, i + REPLACED_START_TAG.length() + 8 + 3, (String)alreadyParsedFragmentsMap.get(uuid));
            }
            return sb.toString();
        }
        return previousOut;
    }

    public void setHandlers(HtmlTagAttributeTraverser.HtmlTagAttributeVisitor ... visitors) {
        this.handlers = visitors;
    }
}

