/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CacheUrlDependenciesParserFilter
implements HtmlTagAttributeTraverser.HtmlTagAttributeVisitor,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(CacheUrlDependenciesParserFilter.class);
    private URLResolverFactory urlResolverFactory;
    private String liveDmsContext;

    @Override
    public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
        String contextConfiguration = resource.getContextConfiguration();
        if (context.isLiveMode() && contextConfiguration.equals("module") && StringUtils.isNotEmpty((String)value)) {
            if (value.startsWith(this.liveDmsContext)) {
                resource.getDependencies().add(StringUtils.substringAfter((String)(value.contains("?") ? StringUtils.substringBefore((String)value, (String)"?") : value), (String)this.liveDmsContext));
            } else if (value.startsWith(context.getRequest().getContextPath().length() > 0 ? context.getRequest().getContextPath() + context.getServletPath() : context.getServletPath()) && !value.equals(resource.getNode().getUrl())) {
                try {
                    URLResolver urlResolver = this.urlResolverFactory.createURLResolver(value, context);
                    JCRNodeWrapper nodeWrapper = urlResolver.getNode();
                    resource.getDependencies().add(nodeWrapper.getCanonicalPath());
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return value;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.liveDmsContext = Jahia.getContextPath() + "/files/live";
    }
}

