/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencesToDependenciesFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(ReferencesToDependenciesFilter.class);

    @Override
    public String prepare(RenderContext renderContext, final Resource resource, RenderChain chain) throws Exception {
        if (resource.getNode().isNodeType("jmix:referencesInField")) {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, resource.getNode().getSession().getWorkspace().getName(), null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeIteratorWrapper ni = session.getNodeByIdentifier(resource.getNode().getIdentifier()).getNodes("j:referenceInField*");
                    while (ni.hasNext()) {
                        JCRNodeWrapper ref = (JCRNodeWrapper)ni.nextNode();
                        try {
                            resource.getDependencies().add(ref.getProperty("j:reference").getNode().getPath());
                        }
                        catch (PathNotFoundException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("j:reference property is not found on node {}", (Object)ref.getCanonicalPath());
                        }
                        catch (RepositoryException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("referenced node does not exist anymore {}", (Object)ref.getCanonicalPath());
                        }
                        catch (Exception e) {
                            logger.warn("Error adding dependency to node " + resource.getNode().getCanonicalPath(), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
        return null;
    }
}

