/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.RenderContextTuner;

public class TemplateNodesCacheKeyPartGenerator
implements CacheKeyPartGenerator,
RenderContextTuner {
    @Override
    public String getKey() {
        return "templateNodes";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        HttpServletRequest request = renderContext.getRequest();
        Template t = (Template)request.getAttribute("previousTemplate");
        return t != null ? t.serialize() : "";
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        return keyPart;
    }

    @Override
    public Object prepareContextForContentGeneration(String value, Resource resource, RenderContext renderContext) {
        HttpServletRequest request = renderContext.getRequest();
        Object original = request.getAttribute("previousTemplate");
        if (!StringUtils.isEmpty((String)value)) {
            Template template = new Template(value);
            request.setAttribute("previousTemplate", (Object)template);
        } else {
            request.removeAttribute("previousTemplate");
        }
        return original;
    }

    @Override
    public void restoreContextAfterContentGeneration(String value, Resource resource, RenderContext renderContext, Object original) {
        if (original != null) {
            renderContext.getRequest().setAttribute("previousTemplate", original);
        } else {
            renderContext.getRequest().removeAttribute("previousTemplate");
        }
    }
}

