/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistryImpl;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;

public class BundleFlowRegistry
extends FlowDefinitionRegistryImpl {
    private Set<FlowDefinitionRegistry> l = new HashSet<FlowDefinitionRegistry>();

    public boolean containsFlowDefinition(String id) {
        for (FlowDefinitionRegistry entry : this.l) {
            if (!entry.containsFlowDefinition(id)) continue;
            return true;
        }
        return super.containsFlowDefinition(id);
    }

    public FlowDefinition getFlowDefinition(String id) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        for (FlowDefinitionRegistry entry : this.l) {
            if (!entry.containsFlowDefinition(id)) continue;
            return entry.getFlowDefinition(id);
        }
        return super.getFlowDefinition(id);
    }

    public int getFlowDefinitionCount() {
        int c = 0;
        for (FlowDefinitionRegistry flowDefinitionRegistry : this.l) {
            c += flowDefinitionRegistry.getFlowDefinitionCount();
        }
        return c + super.getFlowDefinitionCount();
    }

    public String[] getFlowDefinitionIds() {
        ArrayList<String> s = new ArrayList<String>();
        for (FlowDefinitionRegistry entry : this.l) {
            for (String id : entry.getFlowDefinitionIds()) {
                s.add(id);
            }
        }
        return s.toArray(new String[s.size()]);
    }

    public boolean containsFlowRegistry(FlowDefinitionRegistry r) {
        return this.l.contains(r);
    }

    public void addFlowRegistry(FlowDefinitionRegistry r) {
        if (r.getFlowDefinitionCount() > 0) {
            this.l.add(r);
        }
    }

    public void removeFlowRegistry(FlowDefinitionRegistry r) {
        this.l.remove(r);
    }
}

