/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchCriteriaFactory;
import org.jahia.services.search.SearchResponse;

public final class SearchUtils {
    private static final String ATTR_SEARCH_RESPONSE = SearchResponse.class.getName();

    public static SearchResponse.FacetedResult getFacetedResult(String facetDefinitionId, RenderContext ctx) {
        SearchResponse searchResponse = SearchUtils.getSearchResponse(ctx);
        return searchResponse != null ? searchResponse.getFacetedResult(facetDefinitionId) : null;
    }

    public static SearchResponse getSearchResponse(RenderContext ctx) {
        SearchCriteria criteria = SearchCriteriaFactory.getInstance(ctx);
        return criteria != null ? ServicesRegistry.getInstance().getSearchService().search(criteria, ctx) : null;
    }

    static SearchResponse getStoredSearchResponse(SearchCriteria searchCriteria, HttpServletRequest request) {
        Map<Integer, SearchResponse> searchResponses = SearchUtils.getStoredSearchResponses(request, false);
        return searchResponses != null ? searchResponses.get(searchCriteria.hashCode()) : null;
    }

    private static Map<Integer, SearchResponse> getStoredSearchResponses(HttpServletRequest request, boolean createIfMissing) {
        HashMap responses = (HashMap)request.getAttribute(ATTR_SEARCH_RESPONSE);
        if (responses == null && createIfMissing) {
            responses = new HashMap();
            request.setAttribute(ATTR_SEARCH_RESPONSE, responses);
        }
        return responses;
    }

    static void storeSearchResponse(SearchCriteria searchCriteria, SearchResponse response, HttpServletRequest request) {
        SearchUtils.getStoredSearchResponses(request, true).put(searchCriteria.hashCode(), response);
    }
}

