/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.util.Version;
import org.jahia.services.search.analyzer.ASCIIFoldingAnalyzer;

public class FrenchSnowballAnalyzer
extends ASCIIFoldingAnalyzer {
    public static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList("l", "m", "t", "qu", "n", "s", "j", "d", "c", "jusqu", "quoiqu", "lorsqu", "puisqu"), true));

    public FrenchSnowballAnalyzer() {
        super((Analyzer)new SnowballAnalyzer(Version.LUCENE_30, "French", FrenchAnalyzer.getDefaultStopSet()));
    }

    public FrenchSnowballAnalyzer(CharArraySet stopwords) {
        super((Analyzer)new SnowballAnalyzer(Version.LUCENE_30, "French", (Set)stopwords));
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = super.tokenStream(fieldName, reader);
        result = new ElisionFilter(result, (Set)DEFAULT_ARTICLES);
        return result;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        TokenStream result = super.reusableTokenStream(fieldName, reader);
        result = new ElisionFilter(result, (Set)DEFAULT_ARTICLES);
        return result;
    }
}

